/*
 * Decompiled with CFR 0.152.
 */
package org.rx.exception;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Map;
import org.rx.annotation.ErrorCode;
import org.rx.bean.Tuple;
import org.rx.core.Cache;
import org.rx.core.Extends;
import org.rx.core.Linq;
import org.rx.core.Reflects;
import org.rx.core.Strings;
import org.rx.core.Sys;
import org.rx.core.YamlConfiguration;
import org.rx.exception.ApplicationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YamlCodeHandler {
    private static final Logger log = LoggerFactory.getLogger(YamlCodeHandler.class);
    public static final YamlCodeHandler INSTANCE = new YamlCodeHandler();

    protected YamlConfiguration getMessageSource() {
        return YamlConfiguration.RX_CONF;
    }

    public void handle(ApplicationException e) {
        Class<?> codeType = e.getErrorCode().getClass();
        if (codeType.isEnum()) {
            Map messageSource = this.getMessageSource().readAs(codeType.getName(), Map.class);
            if (messageSource == null) {
                return;
            }
            Enum anEnum = (Enum)e.getErrorCode();
            Field field = codeType.getDeclaredField(anEnum.name());
            ErrorCode errorCode = this.findCode(field, null, null);
            if (errorCode == null) {
                errorCode = new ErrorCode(){

                    @Override
                    public Class<? extends Annotation> annotationType() {
                        return ErrorCode.class;
                    }

                    @Override
                    public String value() {
                        return null;
                    }

                    @Override
                    public Class<? extends Throwable> cause() {
                        return Exception.class;
                    }

                    @Override
                    public ErrorCode.MessageFormatter messageFormatter() {
                        return ErrorCode.MessageFormatter.MessageFormat;
                    }
                };
            }
            e.setFriendlyMessage(this.friendlyMessage(errorCode, messageSource, anEnum.name(), e.getCodeValues()));
            return;
        }
        Cache<String, Tuple> cache = Cache.getInstance(Cache.MEMORY_CACHE);
        for (StackTraceElement stack : e.getStacks()) {
            Tuple caller;
            Map messageSource = this.getMessageSource().readAs(stack.getClassName(), Map.class);
            if (messageSource == null || (caller = Extends.as(cache.get(Sys.fastCacheKey("STrace", stack.getClassName()), p -> {
                Class type = Reflects.loadClass(stack.getClassName(), false);
                return Tuple.of(type, type.getDeclaredMethods());
            }), Tuple.class)) == null) continue;
            Method targetSite = null;
            ErrorCode errorCode = null;
            for (Method method : (Method[])caller.right) {
                if (!Strings.hashEquals(method.getName(), stack.getMethodName()) || (errorCode = this.findCode(method, e.getErrorCode().toString(), e.getCause())) == null) continue;
                log.debug("SystemException: Found @ErrorCode at {}", (Object)method);
                targetSite = method;
                break;
            }
            if (errorCode == null) continue;
            e.setFriendlyMessage(this.friendlyMessage(errorCode, messageSource, targetSite.getName(), e.getCodeValues()));
            break;
        }
        if (e.getFriendlyMessage() == null) {
            log.debug("SystemException: Not found @ErrorCode");
        }
    }

    private ErrorCode findCode(AccessibleObject member, String code, Throwable cause) {
        Linq<ErrorCode> errorCodes = Linq.from((ErrorCode[])member.getAnnotationsByType(ErrorCode.class));
        if (!errorCodes.any()) {
            log.debug("SystemException: Not found @ErrorCode in {}", (Object)member);
            return null;
        }
        if (code != null) {
            errorCodes = errorCodes.where(p -> code.equals(p.value()));
        }
        if (cause != null) {
            errorCodes = errorCodes.orderByDescending(p -> {
                byte count;
                Class<? extends Throwable> st = p.cause();
                for (count = 0; count < 8 && !st.equals(Exception.class); count = (byte)(count + 1)) {
                    st = st.getSuperclass();
                }
                return count;
            }).where(p -> p.cause().isAssignableFrom(cause.getClass()));
        }
        if (!errorCodes.any()) {
            return null;
        }
        return errorCodes.first();
    }

    private String friendlyMessage(ErrorCode errorCode, Map<String, Object> messageSource, String code, Object[] values) {
        String msg;
        if (!Strings.isEmpty((CharSequence)errorCode.value())) {
            code = code + "[" + errorCode.value() + "]";
        }
        if (!Exception.class.equals(errorCode.cause())) {
            code = code + "<" + errorCode.cause().getSimpleName() + ">";
        }
        if ((msg = Extends.as(messageSource.get(code), String.class)) == null) {
            log.debug("SystemException: Not found messageName {}", (Object)code);
            return null;
        }
        switch (errorCode.messageFormatter()) {
            case StringFormat: {
                msg = String.format(msg, values);
                break;
            }
            default: {
                msg = MessageFormat.format(msg, values);
            }
        }
        return msg;
    }

    private YamlCodeHandler() {
    }
}

