/*
 * Decompiled with CFR 0.152.
 */
package org.rx.io;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.rx.io.HybridStream;
import org.rx.io.IOStream;
import org.rx.io.Serializer;

public class BinaryStream
extends IOStream {
    private static final long serialVersionUID = 7204373912624988890L;
    private final IOStream baseStream;
    private final boolean leaveOpen;
    private transient DataInputStream reader;
    private transient DataOutputStream writer;
    private transient BufferedReader reader2;

    @Override
    public String getName() {
        return this.baseStream.getName();
    }

    @Override
    public DataInputStream getReader() {
        if (this.reader == null) {
            this.reader = new DataInputStream(this.baseStream.getReader());
        }
        return this.reader;
    }

    @Override
    public DataOutputStream getWriter() {
        if (this.writer == null) {
            this.writer = new DataOutputStream(this.baseStream.getWriter());
        }
        return this.writer;
    }

    @Override
    public boolean canSeek() {
        return this.baseStream.canSeek();
    }

    @Override
    public long getPosition() {
        return this.baseStream.getPosition();
    }

    @Override
    public void setPosition(long position) {
        this.baseStream.setPosition(position);
    }

    @Override
    public long getLength() {
        return this.baseStream.getLength();
    }

    public BinaryStream(IOStream stream) {
        this(stream, false);
    }

    @Override
    protected void freeObjects() {
        if (!this.leaveOpen) {
            this.baseStream.close();
        }
    }

    public boolean readBoolean() {
        return this.getReader().readBoolean();
    }

    public byte readByte() {
        return this.getReader().readByte();
    }

    @Override
    public short readShort() {
        return this.getReader().readShort();
    }

    @Override
    public int readInt() {
        return this.getReader().readInt();
    }

    public long readLong() {
        return this.getReader().readLong();
    }

    public float readFloat() {
        return this.getReader().readFloat();
    }

    public double readDouble() {
        return this.getReader().readDouble();
    }

    public char readChar() {
        return this.getReader().readChar();
    }

    public String readString() {
        return this.getReader().readUTF();
    }

    public String readLine() {
        if (this.reader2 == null) {
            this.reader2 = new BufferedReader(new InputStreamReader(this.getReader()));
        }
        return this.reader2.readLine();
    }

    public <T extends Serializable> T readObject() {
        try (HybridStream serialize = new HybridStream();){
            this.read(serialize, this.readLong());
            Serializable serializable = (Serializable)Serializer.DEFAULT.deserialize((IOStream)serialize.rewind());
            return (T)serializable;
        }
    }

    public void writeBoolean(boolean value) {
        this.getWriter().writeBoolean(value);
    }

    public void writeByte(byte value) {
        this.getWriter().writeByte(value);
    }

    @Override
    public void writeShort(short value) {
        this.getWriter().writeShort(value);
    }

    @Override
    public void writeInt(int value) {
        this.getWriter().writeInt(value);
    }

    public void writeLong(long value) {
        this.getWriter().writeLong(value);
    }

    public void writeFloat(float value) {
        this.getWriter().writeFloat(value);
    }

    public void writeDouble(double value) {
        this.getWriter().writeDouble(value);
    }

    public void writeChar(char value) {
        this.getWriter().writeChar(value);
    }

    @Override
    public void writeString(String value) {
        this.getWriter().writeUTF(value);
    }

    public void writeLine(String value) {
        this.write((value + System.lineSeparator()).getBytes(StandardCharsets.UTF_8));
    }

    public <T extends Serializable> void writeObject(T value) {
        try (IOStream stream = Serializer.DEFAULT.serialize(value);){
            this.writeLong(stream.getLength());
            this.write(stream);
        }
    }

    public BinaryStream(IOStream baseStream, boolean leaveOpen) {
        this.baseStream = baseStream;
        this.leaveOpen = leaveOpen;
    }

    public IOStream getBaseStream() {
        return this.baseStream;
    }
}

