/*
 * Decompiled with CFR 0.152.
 */
package org.rx.io;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.EnumSet;
import java.util.Set;

public class Bytes {
    static final SecureRandom DEF = new SecureRandom();

    public static String hexDump(ByteBuf buf) {
        return ByteBufUtil.prettyHexDump((ByteBuf)buf);
    }

    public static ByteBuf wrap(byte[] buffer, int offset, int length) {
        return Unpooled.wrappedBuffer((byte[])buffer, (int)offset, (int)length);
    }

    public static ByteBuf wrap(ByteBuffer buffer) {
        return Unpooled.wrappedBuffer((ByteBuffer)buffer);
    }

    public static byte[] getBytes(ByteBuf buf) {
        return ByteBufUtil.getBytes((ByteBuf)buf, (int)buf.readerIndex(), (int)buf.readableBytes(), (boolean)false);
    }

    public static byte[] arrayBuffer() {
        return new byte[128];
    }

    public static ByteBuf heapBuffer() {
        return Bytes.heapBuffer(256, false);
    }

    public static ByteBuf heapBuffer(int initialCapacity, boolean unpool) {
        UnpooledByteBufAllocator allocator = unpool ? UnpooledByteBufAllocator.DEFAULT : PooledByteBufAllocator.DEFAULT;
        return allocator.heapBuffer(initialCapacity, 0x1000000);
    }

    public static ByteBuf directBuffer() {
        return Bytes.directBuffer(1024);
    }

    public static ByteBuf directBuffer(int initialCapacity) {
        return PooledByteBufAllocator.DEFAULT.directBuffer(initialCapacity);
    }

    public static ByteBuf copyInputStream(InputStream in) {
        return Bytes.copyInputStream(in, in.available());
    }

    public static ByteBuf copyInputStream(InputStream in, int length) {
        ByteBuf buf = Bytes.directBuffer(length);
        buf.writeBytes(in, length);
        return buf;
    }

    public static long wrap(int a, int b) {
        return (long)a << 32 | (long)b & 0xFFFFFFFFL;
    }

    public static int[] unwrap(long l) {
        return new int[]{(int)(l >> 32), (int)l};
    }

    public static int findText(ByteBuf byteBuf, String str) {
        byte[] text = str.getBytes(StandardCharsets.UTF_8);
        int matchIndex = 0;
        for (int i = byteBuf.readerIndex(); i < byteBuf.readableBytes(); ++i) {
            int j = matchIndex;
            if (j >= text.length) continue;
            if (byteBuf.getByte(i) == text[j]) {
                matchIndex = j + 1;
                if (matchIndex != text.length) continue;
                return i;
            }
            matchIndex = 0;
        }
        return -1;
    }

    public static ByteBuf insertText(ByteBuf byteBuf, int index, String str) {
        return Bytes.insertText(byteBuf, index, str, Charset.defaultCharset());
    }

    public static ByteBuf insertText(ByteBuf byteBuf, int index, String str, Charset charset) {
        byte[] begin = new byte[index + 1];
        byte[] end = new byte[byteBuf.readableBytes() - begin.length];
        byteBuf.readBytes(begin);
        byteBuf.readBytes(end);
        byteBuf.writeBytes(begin);
        byteBuf.writeBytes(str.getBytes(charset));
        byteBuf.writeBytes(end);
        return byteBuf;
    }

    public static String readLine(byte[] buffer) {
        return Bytes.readLine(buffer, 0, buffer.length);
    }

    public static String readLine(byte[] buffer, int offset, int length) {
        int line = 10;
        int line2 = 13;
        for (int i = offset; i < Math.min(length, buffer.length); ++i) {
            byte b = buffer[i];
            if (b != 10 && b != 13) continue;
            return Bytes.toString(buffer, offset, i);
        }
        return null;
    }

    public static String toString(ByteBuffer buffer) {
        return Bytes.wrap(buffer).toString(StandardCharsets.UTF_8);
    }

    public static String toString(byte[] buffer, int offset, int length) {
        return new String(buffer, offset, length, StandardCharsets.UTF_8);
    }

    public static byte[] getBytes(int val) {
        byte[] buffer = new byte[4];
        Bytes.getBytes(val, buffer, 0);
        return buffer;
    }

    public static void getBytes(int val, byte[] buffer, int offset) {
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])buffer, (int)offset, (int)4);
        buf.writerIndex(0);
        buf.writeInt(val);
    }

    public static int getInt(byte[] buffer, int offset) {
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])buffer, (int)offset, (int)4);
        return buf.readInt();
    }

    public static byte[] getBytes(long val) {
        byte[] buffer = new byte[8];
        Bytes.getBytes(val, buffer, 0);
        return buffer;
    }

    public static void getBytes(long val, byte[] buffer, int offset) {
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])buffer, (int)offset, (int)8);
        buf.writerIndex(0);
        buf.writeLong(val);
    }

    public static long getLong(byte[] buffer, int offset) {
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])buffer, (int)offset, (int)8);
        return buf.readLong();
    }

    public static void reverse(byte[] array, int offset, int length) {
        for (int i = offset; i < length / 2; ++i) {
            byte temp = array[i];
            array[i] = array[array.length - i - 1];
            array[array.length - i - 1] = temp;
        }
    }

    public static byte[] randomBytes(int size) {
        byte[] bytes = new byte[size];
        DEF.nextBytes(bytes);
        return bytes;
    }

    public static strictfp String readableByteSize(double val) {
        if (val < 1024.0) {
            return String.format("%.0fB", val);
        }
        if (val < 1048576.0) {
            return String.format("%.1fKB", val / 1024.0);
        }
        if (val < 1.073741824E9) {
            return String.format("%.1fMB", val / 1048576.0);
        }
        if (val < 1.099511627776E12) {
            return String.format("%.1fGB", val / 1.073741824E9);
        }
        return String.format("%.1fTB", val / 1.099511627776E12);
    }

    public static <E extends Enum<E>> int toEnumVector(Set<E> set) {
        int vector = 0;
        for (Enum e : set) {
            if (e.ordinal() >= 32) {
                throw new IllegalArgumentException("The enum set is too large to fit in a bit vector: " + set);
            }
            vector = (int)((long)vector | 1L << e.ordinal());
        }
        return vector;
    }

    public static <E extends Enum<E>> EnumSet<E> fromEnumVector(Class<E> enumClass, int vector) {
        EnumSet<Enum> set = EnumSet.noneOf(enumClass);
        for (Enum e : (Enum[])enumClass.getEnumConstants()) {
            int mask = 1 << e.ordinal();
            if ((mask & vector) == 0) continue;
            set.add(e);
        }
        return set;
    }
}

