/*
 * Decompiled with CFR 0.152.
 */
package org.rx.io;

import java.nio.channels.FileLock;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import lombok.NonNull;
import org.rx.bean.FlagsEnum;
import org.rx.bean.NEnum;
import org.rx.io.FileStream;
import org.rx.util.function.Action;
import org.rx.util.function.Func;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CompositeLock {
    private static final Logger log = LoggerFactory.getLogger(CompositeLock.class);
    static final FileStream.Block ALL_BLOCK = new FileStream.Block(0L, Long.MAX_VALUE);
    private final FileStream owner;
    private final FlagsEnum<Flags> flags;
    final Map<FileStream.Block, ReadWriteLock> rwLocks = Collections.synchronizedMap(new WeakHashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T lock(FileStream.Block block, boolean shared, @NonNull Func<T> fn) {
        if (fn == null) {
            throw new NullPointerException("fn is marked non-null but is null");
        }
        Lock lock = null;
        if (this.flags.has(new Flags[]{Flags.READ_WRITE_LOCK})) {
            ReadWriteLock rwLock = this.rwLocks.computeIfAbsent(block, k -> {
                ReadWriteLock t = this.overlaps(k.position, k.size);
                if (t == null) {
                    t = new ReentrantReadWriteLock();
                }
                return t;
            });
            lock = shared ? rwLock.readLock() : rwLock.writeLock();
            lock.lock();
        }
        FileLock fLock = null;
        try {
            if (this.flags.has(new Flags[]{Flags.FILE_LOCK})) {
                fLock = this.owner.getRandomAccessFile().getChannel().lock(block.position, block.size, shared);
            }
            T t = fn.invoke();
            return t;
        }
        finally {
            if (fLock != null) {
                fLock.release();
            }
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    private ReadWriteLock overlaps(long position, long size) {
        for (Map.Entry<FileStream.Block, ReadWriteLock> entry : this.rwLocks.entrySet()) {
            FileStream.Block block = entry.getKey();
            if (position + size <= block.position || block.position + block.size <= position) continue;
            return entry.getValue();
        }
        return null;
    }

    public void readInvoke(Action action) {
        this.lock(ALL_BLOCK, true, action.toFunc());
    }

    public void readInvoke(Action action, long position) {
        this.readInvoke(action, position, Long.MAX_VALUE - position);
    }

    public void readInvoke(Action action, long position, long size) {
        this.lock(new FileStream.Block(position, size), true, action.toFunc());
    }

    public void writeInvoke(Action action) {
        this.lock(ALL_BLOCK, false, action.toFunc());
    }

    public void writeInvoke(Action action, long position) {
        this.writeInvoke(action, position, Long.MAX_VALUE - position);
    }

    public void writeInvoke(Action action, long position, long size) {
        this.lock(new FileStream.Block(position, size), false, action.toFunc());
    }

    public <T> T readInvoke(Func<T> action) {
        return this.lock(ALL_BLOCK, true, action);
    }

    public <T> T readInvoke(Func<T> action, long position) {
        return this.readInvoke(action, position, Long.MAX_VALUE - position);
    }

    public <T> T readInvoke(Func<T> action, long position, long size) {
        return this.lock(new FileStream.Block(position, size), true, action);
    }

    public <T> T writeInvoke(Func<T> action) {
        return this.lock(ALL_BLOCK, false, action);
    }

    public <T> T writeInvoke(Func<T> action, long position) {
        return this.writeInvoke(action, position, Long.MAX_VALUE - position);
    }

    public <T> T writeInvoke(Func<T> action, long position, long size) {
        return this.lock(new FileStream.Block(position, size), false, action);
    }

    CompositeLock(FileStream owner, FlagsEnum<Flags> flags) {
        this.owner = owner;
        this.flags = flags;
    }

    static enum Flags implements NEnum<Flags>
    {
        READ_WRITE_LOCK(1),
        FILE_LOCK(2),
        ALL(Flags.READ_WRITE_LOCK.value | Flags.FILE_LOCK.value);

        final int value;

        private Flags(int value) {
            this.value = value;
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }
}

