/*
 * Decompiled with CFR 0.152.
 */
package org.rx.io;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.rx.bean.DataRange;
import org.rx.bean.Tuple;
import org.rx.core.Linq;
import org.rx.io.Bytes;
import org.rx.io.FileStream;
import org.rx.io.IOStream;
import org.rx.util.Lazy;

public final class CompositeMmap
extends IOStream {
    private static final long serialVersionUID = -3293392999599916L;
    final FileStream owner;
    final FileStream.Block block;
    final Tuple<MappedByteBuffer, DataRange<Long>>[] buffers;
    long position;
    private transient InputStream reader;
    private transient OutputStream writer;

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new UnsupportedEncodingException();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        throw new UnsupportedEncodingException();
    }

    @Override
    public String getName() {
        return this.owner.getName();
    }

    @Override
    public InputStream getReader() {
        if (this.reader == null) {
            this.reader = new InputStream(){

                @Override
                public int available() {
                    return IOStream.safeRemaining(CompositeMmap.this.available());
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public int read(byte[] b, int off, int len) {
                    ByteBuf buf = Bytes.wrap(b, off, len);
                    buf.clear();
                    try {
                        int read = CompositeMmap.this.read(CompositeMmap.this.position, buf);
                        if (read > -1) {
                            CompositeMmap.this.position += (long)read;
                        }
                        int n = read;
                        return n;
                    }
                    finally {
                        buf.release();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public int read() {
                    ByteBuf buf = Bytes.directBuffer(1);
                    try {
                        int read = CompositeMmap.this.read(CompositeMmap.this.position, buf, 1);
                        if (read == -1) {
                            int n = read;
                            return n;
                        }
                        CompositeMmap.this.position += (long)read;
                        int n = buf.readByte() & 0xFF;
                        return n;
                    }
                    finally {
                        buf.release();
                    }
                }
            };
        }
        return this.reader;
    }

    @Override
    public OutputStream getWriter() {
        if (this.writer == null) {
            this.writer = new OutputStream(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void write(byte[] b, int off, int len) {
                    ByteBuf buf = Bytes.wrap(b, off, len);
                    try {
                        CompositeMmap.this.position += (long)CompositeMmap.this.write(CompositeMmap.this.position, buf);
                    }
                    finally {
                        buf.release();
                    }
                }

                @Override
                public void write(int b) {
                    ByteBuf buf = Bytes.directBuffer(1);
                    buf.writeByte(b);
                    try {
                        CompositeMmap.this.position += (long)CompositeMmap.this.write(CompositeMmap.this.position, buf);
                    }
                    finally {
                        buf.release();
                    }
                }

                @Override
                public void flush() {
                    CompositeMmap.this.flush();
                }
            };
        }
        return this.writer;
    }

    @Override
    public boolean canSeek() {
        return true;
    }

    @Override
    public synchronized long getPosition() {
        return this.position;
    }

    @Override
    public synchronized void setPosition(long position) {
        this.position = position;
    }

    @Override
    public long getLength() {
        return this.block.position + this.block.size;
    }

    public MappedByteBuffer[] buffers() {
        return Linq.from(this.buffers).select(p -> (MappedByteBuffer)p.left).toArray();
    }

    CompositeMmap(FileStream owner, FileChannel.MapMode mode, FileStream.Block block) {
        this.owner = owner;
        this.block = block;
        long totalCount = block.size;
        long max = Integer.MAX_VALUE;
        this.buffers = new Tuple[(int)Math.floorDiv(totalCount, max) + 1];
        long prev = 0L;
        for (int i = 0; i < this.buffers.length; ++i) {
            long count = Math.min(max, totalCount);
            DataRange<Long> range = new DataRange<Long>(prev, prev += count);
            this.buffers[i] = Tuple.of(owner.getRandomAccessFile().getChannel().map(mode, (Long)range.start, count).mark(), range);
            totalCount -= count;
        }
    }

    @Override
    protected void freeObjects() {
        for (Tuple<MappedByteBuffer, DataRange<Long>> tuple : this.buffers) {
            CompositeMmap.release((ByteBuffer)tuple.left);
        }
    }

    @Override
    public long available() {
        return this.remaining(this.position);
    }

    public synchronized long remaining(long position) {
        for (Tuple<MappedByteBuffer, DataRange<Long>> tuple : this.buffers) {
            DataRange range = (DataRange)tuple.right;
            if (!range.has(position)) continue;
            return (Long)range.end - position;
        }
        return 0L;
    }

    @Override
    public int read(ByteBuf dst, int length) {
        int read = this.read(this.position, dst, length);
        this.position += (long)read;
        return read;
    }

    public int read(long position, ByteBuf byteBuf) {
        return this.read(position, byteBuf, byteBuf.writableBytes());
    }

    public synchronized int read(long position, ByteBuf byteBuf, int readCount) {
        int read;
        this.checkNotClosed();
        int writerIndex = byteBuf.writerIndex();
        int finalReadCount = readCount;
        Lazy<byte[]> buffer = new Lazy<byte[]>(() -> new byte[Math.min(finalReadCount, 4096)]);
        for (Tuple<MappedByteBuffer, DataRange<Long>> tuple : this.buffers) {
            DataRange range = (DataRange)tuple.right;
            if (!range.has(position)) continue;
            MappedByteBuffer mbuf = (MappedByteBuffer)tuple.left;
            int pos = (int)(position - (Long)range.start);
            mbuf.position(mbuf.reset().position() + pos);
            int count = readCount;
            int limit = mbuf.remaining();
            if (limit < count) {
                count = limit;
            }
            int read2 = Math.min(count, buffer.getValue().length);
            mbuf.get(buffer.getValue(), 0, read2);
            byteBuf.writeBytes(buffer.getValue(), 0, read2);
            position += (long)count;
            if ((readCount -= count) == 0) break;
        }
        return (read = byteBuf.writerIndex() - writerIndex) == 0 ? -1 : read;
    }

    @Override
    public void write(ByteBuf src, int length) {
        this.position += (long)this.write(this.position, src, length);
    }

    public int write(long position, ByteBuf byteBuf) {
        return this.write(position, byteBuf, byteBuf.readableBytes());
    }

    public synchronized int write(long position, ByteBuf byteBuf, int writeCount) {
        this.checkNotClosed();
        int readerIndex = byteBuf.readerIndex();
        for (Tuple<MappedByteBuffer, DataRange<Long>> tuple : this.buffers) {
            DataRange range = (DataRange)tuple.right;
            if (!range.has(position)) continue;
            MappedByteBuffer mbuf = (MappedByteBuffer)tuple.left;
            int pos = (int)(position - (Long)range.start);
            mbuf.position(mbuf.reset().position() + pos);
            int count = writeCount;
            int limit = mbuf.remaining();
            int rIndex = byteBuf.readerIndex();
            int rEndIndex = rIndex + count;
            ByteBuf buf = byteBuf;
            if (limit < count) {
                count = limit;
                rEndIndex = rIndex + count;
                buf = buf.slice(rIndex, rEndIndex);
            }
            switch (buf.nioBufferCount()) {
                case 0: {
                    mbuf.put(ByteBuffer.wrap(Bytes.getBytes(buf)));
                    break;
                }
                case 1: {
                    mbuf.put(buf.nioBuffer());
                    break;
                }
                default: {
                    for (ByteBuffer byteBuffer : buf.nioBuffers()) {
                        mbuf.put(byteBuffer);
                    }
                }
            }
            byteBuf.readerIndex(rEndIndex);
            position += (long)count;
            if ((writeCount -= count) == 0) break;
        }
        return byteBuf.readerIndex() - readerIndex;
    }

    @Override
    public synchronized void flush() {
        for (Tuple<MappedByteBuffer, DataRange<Long>> tuple : this.buffers) {
            ((MappedByteBuffer)tuple.left).force();
        }
    }

    public FileStream.Block getBlock() {
        return this.block;
    }
}

