/*
 * Decompiled with CFR 0.152.
 */
package org.rx.io;

import java.io.InputStream;
import org.apache.commons.io.FilenameUtils;
import org.rx.core.Linq;
import org.rx.core.Strings;

public interface CrudFile<T> {
    default public boolean isDirectoryPath(String path) {
        if (Strings.isEmpty((CharSequence)path)) {
            return false;
        }
        char ch = path.charAt(path.length() - 1);
        return ch == '/' || ch == '\\' || Strings.isEmpty((CharSequence)FilenameUtils.getExtension((String)path));
    }

    default public String getDirectoryPath(String path) {
        return FilenameUtils.getFullPath((String)path);
    }

    default public String padDirectoryPath(String path) {
        if (Strings.isEmpty((CharSequence)path)) {
            return "";
        }
        char ch = path.charAt(path.length() - 1);
        if (ch == '/' || ch == '\\') {
            return path;
        }
        char separatorChar = path.lastIndexOf(92) != -1 ? (char)'\\' : '/';
        return path + separatorChar;
    }

    public String createDirectory(String var1);

    public Linq<T> listDirectories(String var1, boolean var2);

    public void saveFile(String var1, InputStream var2);

    public Linq<T> listFiles(String var1, boolean var2);

    public boolean exists(String var1);

    public void delete(String var1);
}

