/*
 * Decompiled with CFR 0.152.
 */
package org.rx.io;

import java.io.Serializable;
import java.util.List;
import org.rx.bean.DataTable;
import org.rx.io.EntityDatabaseImpl;
import org.rx.io.EntityQueryLambda;
import org.rx.util.function.Action;
import org.rx.util.function.Func;

public interface EntityDatabase
extends AutoCloseable {
    public static final String DEFAULT_FILE_PATH = "./rx";
    public static final EntityDatabase DEFAULT = new EntityDatabaseImpl();

    public <T> void save(T var1);

    public <T> void save(T var1, boolean var2);

    public <T> boolean deleteById(Class<T> var1, Serializable var2);

    public <T> long delete(EntityQueryLambda<T> var1);

    public <T> long count(EntityQueryLambda<T> var1);

    public <T> boolean exists(EntityQueryLambda<T> var1);

    public <T> boolean existsById(Class<T> var1, Serializable var2);

    public <T> T findById(Class<T> var1, Serializable var2);

    public <T> T findOne(EntityQueryLambda<T> var1);

    public <T> List<T> findBy(EntityQueryLambda<T> var1);

    public void compact();

    public <T> void dropMapping(Class<T> var1);

    public void createMapping(Class<?> ... var1);

    public String tableName(Class<?> var1);

    public <T> DataTable executeQuery(String var1, Class<T> var2);

    public int executeUpdate(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void transInvoke(int transactionIsolation, Action fn) {
        boolean doCommit = false;
        this.begin(transactionIsolation);
        try {
            fn.invoke();
            doCommit = true;
        }
        finally {
            if (doCommit) {
                this.commit();
            } else {
                this.rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public <T> T transInvoke(int transactionIsolation, Func<T> fn) {
        boolean doCommit = false;
        this.begin(transactionIsolation);
        try {
            T r = fn.invoke();
            doCommit = true;
            T t = r;
            return t;
        }
        finally {
            if (doCommit) {
                this.commit();
            } else {
                this.rollback();
            }
        }
    }

    public boolean isInTransaction();

    public void begin();

    public void begin(int var1);

    public void commit();

    public void rollback();
}

