/*
 * Decompiled with CFR 0.152.
 */
package org.rx.io;

import io.netty.util.concurrent.FastThreadLocal;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.IteratorUtils;
import org.h2.Driver;
import org.h2.api.H2Type;
import org.h2.jdbc.JdbcResultSet;
import org.h2.jdbc.JdbcSQLSyntaxErrorException;
import org.h2.jdbcx.JdbcConnectionPool;
import org.rx.annotation.DbColumn;
import org.rx.bean.DataColumn;
import org.rx.bean.DataRow;
import org.rx.bean.DataTable;
import org.rx.bean.DateTime;
import org.rx.bean.Decimal;
import org.rx.bean.NEnum;
import org.rx.bean.Tuple;
import org.rx.core.Arrays;
import org.rx.core.Constants;
import org.rx.core.Disposable;
import org.rx.core.Extends;
import org.rx.core.Linq;
import org.rx.core.Reflects;
import org.rx.core.RxConfig;
import org.rx.core.StringBuilder;
import org.rx.core.Strings;
import org.rx.core.Sys;
import org.rx.core.Tasks;
import org.rx.exception.InvalidException;
import org.rx.exception.TraceHandler;
import org.rx.io.EntityDatabase;
import org.rx.io.EntityQueryLambda;
import org.rx.io.Files;
import org.rx.io.IOStream;
import org.rx.io.Serializer;
import org.rx.third.guava.CaseFormat;
import org.rx.util.function.BiAction;
import org.rx.util.function.BiFunc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityDatabaseImpl
extends Disposable
implements EntityDatabase {
    private static final Logger log = LoggerFactory.getLogger(EntityDatabaseImpl.class);
    static final String SQL_CREATE = "CREATE TABLE IF NOT EXISTS $TABLE\n(\n$CREATE_COLUMNS\tconstraint $TABLE_PK\n\t\tprimary key ($PK)\n);";
    static final String SQL_CREATE_TEMP_TABLE = "CREATE TABLE $TABLE\n(\n$CREATE_COLUMNS);";
    static final String $TABLE = "$TABLE";
    static final String $CREATE_COLUMNS = "$CREATE_COLUMNS";
    static final String $PK = "$PK";
    static final String $UPDATE_COLUMNS = "$UPDATE_COLUMNS";
    static final Map<Class<?>, H2Type> H2_TYPES = new ConcurrentHashMap();
    static final Map<Class<?>, SqlMeta> SQL_META = new ConcurrentHashMap();
    static final FastThreadLocal<Connection> TX_CONN = new FastThreadLocal();
    final String filePath;
    final String timeRollingPattern;
    int rollingHours = 48;
    final int maxConnections;
    final Set<Class<?>> mappedEntityTypes = ConcurrentHashMap.newKeySet();
    boolean autoUnderscoreColumnName;
    boolean autoRollbackOnError;
    int slowSqlElapsed = 200;
    String curFilePath;
    JdbcConnectionPool connPool;

    static String columnName(Field field, DbColumn dbColumn, boolean autoUnderscoreColumnName) {
        if (dbColumn != null && !dbColumn.name().isEmpty()) {
            return dbColumn.name();
        }
        return autoUnderscoreColumnName ? CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, field.getName()) : field.getName();
    }

    JdbcConnectionPool getConnectionPool() {
        if (this.connPool == null) {
            String filePath;
            this.curFilePath = filePath = this.getFilePath();
            this.connPool = JdbcConnectionPool.create((String)String.format("jdbc:h2:%s;DB_CLOSE_DELAY=-1;DB_CLOSE_ON_EXIT=FALSE;TRACE_LEVEL_FILE=0;MODE=MySQL", filePath), null, null);
            this.connPool.setMaxConnections(this.maxConnections);
            if (!this.mappedEntityTypes.isEmpty()) {
                this.createMapping(Linq.from(this.mappedEntityTypes).toArray());
            }
        }
        return this.connPool;
    }

    String getFilePath() {
        return this.timeRollingPattern != null ? this.filePath + "_" + DateTime.now().toString(this.timeRollingPattern) : this.filePath;
    }

    public EntityDatabaseImpl() {
        this("./rx", null);
    }

    public EntityDatabaseImpl(String filePath, String timeRollingPattern) {
        this(filePath, timeRollingPattern, 0);
    }

    public EntityDatabaseImpl(String filePath, String timeRollingPattern, int maxConnections) {
        if (maxConnections <= 0) {
            maxConnections = Math.max(10, Constants.CPU_THREADS);
        }
        this.filePath = filePath;
        this.timeRollingPattern = timeRollingPattern;
        this.maxConnections = maxConnections;
        if (timeRollingPattern != null) {
            Tasks.timer().setTimeout(() -> {
                if (this.connPool == null || Strings.hashEquals(this.curFilePath, this.getFilePath())) {
                    return;
                }
                try {
                    this.clearTimeRollingFiles();
                }
                catch (Exception e) {
                    TraceHandler.INSTANCE.log(e);
                }
                this.connPool = null;
            }, d -> RxConfig.INSTANCE.getDisk().getEntityDatabaseRollPeriod(), null, Constants.TIMER_PERIOD_FLAG);
        }
    }

    @Override
    protected void freeObjects() {
        if (this.connPool != null) {
            this.connPool.dispose();
        }
    }

    public void clearTimeRollingFiles() {
        if (this.timeRollingPattern == null) {
            throw new InvalidException("Time rolling policy not enabled", new Object[0]);
        }
        String p = this.filePath;
        if (p.startsWith("~/")) {
            p = Sys.USER_HOME + p.substring(1);
        }
        Files.deleteBefore(Files.getFullPath((String)p), DateTime.now(this.timeRollingPattern).addHours(-this.rollingHours), "*.mv.db");
    }

    @Override
    public <T> void save(T entity) {
        Class<?> entityType = entity.getClass();
        SqlMeta meta = this.getMeta(entityType);
        Serializable id = (Serializable)((Field)meta.primaryKey.getValue().left).get(entity);
        if (id == null) {
            this.save(entity, true);
            return;
        }
        boolean isInTx = this.isInTransaction();
        if (!isInTx) {
            this.begin(2);
        }
        try {
            this.save(entity, !this.existsById(entityType, id));
            if (!isInTx) {
                this.commit();
            }
        }
        catch (Throwable e) {
            if (!isInTx) {
                this.rollback();
            }
            throw e;
        }
    }

    @Override
    public <T> void save(T entity, boolean doInsert) {
        SqlMeta meta = this.getMeta(entity.getClass());
        try {
            ArrayList<Object> params = new ArrayList<Object>();
            if (doInsert) {
                for (Map.Entry<String, Tuple<Field, DbColumn>> col : meta.insertView) {
                    params.add(((Field)col.getValue().left).get(entity));
                }
                this.executeUpdate(meta.insertSql, params);
                return;
            }
            StringBuilder cols = new StringBuilder(128);
            for (Map.Entry<String, Tuple<Field, DbColumn>> col : meta.secondaryView) {
                Object val = ((Field)col.getValue().left).get(entity);
                if (val == null) continue;
                cols.append("`%s`=?,", col.getKey());
                params.add(val);
            }
            cols.setLength(cols.length() - 1);
            Object id = ((Field)meta.primaryKey.getValue().left).get(entity);
            params.add(id);
            this.executeUpdate(new StringBuilder(meta.updateSql).replace($UPDATE_COLUMNS, cols.toString()).toString(), params);
        }
        catch (Exception e) {
            if (e instanceof JdbcSQLSyntaxErrorException && (Strings.startsWith((CharSequence)e.getMessage(), (CharSequence)"Column count does not match") || Strings.containsAll(e.getMessage(), "Column", "not found"))) {
                this.dropMapping(entity.getClass());
                log.info("recreate {} -> {}", entity.getClass(), (Object)e.getMessage());
                this.createMapping(entity.getClass());
                this.save(entity, doInsert);
                return;
            }
            throw e;
        }
    }

    @Override
    public <T> boolean deleteById(Class<T> entityType, Serializable id) {
        SqlMeta meta = this.getMeta(entityType);
        ArrayList<Object> params = new ArrayList<Object>(1);
        params.add(id);
        return this.executeUpdate(meta.deleteSql, params) > 0;
    }

    @Override
    public <T> long delete(EntityQueryLambda<T> query) {
        int rf;
        if (query.conditions.isEmpty()) {
            throw new InvalidException("Forbid: empty condition", new Object[0]);
        }
        query.limit(1000);
        SqlMeta meta = this.getMeta(query.entityType);
        StringBuilder sql = new StringBuilder(meta.deleteSql);
        sql.setLength(sql.length() - 2);
        StringBuilder subSql = new StringBuilder(meta.selectSql);
        this.replaceSelectColumns(subSql, meta.primaryKey.getKey());
        ArrayList<Object> params = new ArrayList<Object>();
        this.appendClause(subSql, query, params);
        sql.append(" IN(%s)", subSql);
        String execSql = sql.toString();
        long total = 0L;
        while ((rf = this.executeUpdate(execSql, params)) > 0) {
            total += (long)rf;
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> long count(EntityQueryLambda<T> query) {
        ArrayList tmpOrders = null;
        if (!query.orders.isEmpty()) {
            tmpOrders = new ArrayList(query.orders);
            query.orders.clear();
        }
        Integer tmpLimit = null;
        if (query.limit != null) {
            tmpLimit = query.limit;
            query.limit = null;
        }
        SqlMeta meta = this.getMeta(query.entityType);
        query.setAutoUnderscoreColumnName(this.autoUnderscoreColumnName);
        StringBuilder sql = new StringBuilder(meta.selectSql);
        this.replaceSelectColumns(sql, "COUNT(*)");
        ArrayList<Object> params = new ArrayList<Object>();
        this.appendClause(sql, query, params);
        try {
            Number num = (Number)this.executeScalar(sql.toString(), params);
            if (num == null) {
                long l = 0L;
                return l;
            }
            long l = num.longValue();
            return l;
        }
        finally {
            if (tmpOrders != null) {
                query.orders.addAll(tmpOrders);
            }
            if (tmpLimit != null) {
                query.limit = tmpLimit;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> boolean exists(EntityQueryLambda<T> query) {
        Integer tmpLimit = null;
        Integer tmpOffset = null;
        if (query.limit != null) {
            tmpLimit = query.limit;
            tmpOffset = query.offset;
            query.limit = 1;
            query.offset = null;
        }
        SqlMeta meta = this.getMeta(query.entityType);
        query.setAutoUnderscoreColumnName(this.autoUnderscoreColumnName);
        StringBuilder sql = new StringBuilder(meta.selectSql);
        this.replaceSelectColumns(sql, "1");
        ArrayList<Object> params = new ArrayList<Object>();
        this.appendClause(sql, query, params);
        try {
            boolean bl = this.executeScalar(sql.toString(), params) != null;
            return bl;
        }
        finally {
            if (tmpLimit != null) {
                query.limit = tmpLimit;
                query.offset = tmpOffset;
            }
        }
    }

    @Override
    public <T> boolean existsById(Class<T> entityType, Serializable id) {
        SqlMeta meta = this.getMeta(entityType);
        StringBuilder sql = new StringBuilder(meta.selectSql);
        this.replaceSelectColumns(sql, "1");
        EntityQueryLambda.pkClaus(sql, meta.primaryKey.getKey());
        sql.append(" LIMIT ").append("1");
        ArrayList<Object> params = new ArrayList<Object>(1);
        params.add(id);
        return this.executeScalar(sql.toString(), params) != null;
    }

    @Override
    public <T> T findById(Class<T> entityType, Serializable id) {
        SqlMeta meta = this.getMeta(entityType);
        StringBuilder sql = new StringBuilder(meta.selectSql);
        EntityQueryLambda.pkClaus(sql, meta.primaryKey.getKey());
        ArrayList<Object> params = new ArrayList<Object>(1);
        params.add(id);
        List<T> list = this.executeQuery(sql.toString(), params, entityType);
        return list.isEmpty() ? null : (T)list.get(0);
    }

    @Override
    public <T> T findOne(EntityQueryLambda<T> query) {
        List<T> list = this.findBy(query);
        if (list.size() > 1) {
            throw new InvalidException("Query yields more than one result", new Object[0]);
        }
        return list.get(0);
    }

    @Override
    public <T> List<T> findBy(EntityQueryLambda<T> query) {
        SqlMeta meta = this.getMeta(query.entityType);
        query.setAutoUnderscoreColumnName(this.autoUnderscoreColumnName);
        StringBuilder sql = new StringBuilder(meta.selectSql);
        ArrayList<Object> params = new ArrayList<Object>();
        this.appendClause(sql, query, params);
        return this.executeQuery(sql.toString(), params, query.entityType);
    }

    <T> void replaceSelectColumns(StringBuilder sql, String newColumns) {
        sql.replace(7, 8, newColumns);
    }

    <T> void appendClause(StringBuilder sql, EntityQueryLambda<T> query, List<Object> params) {
        String clause = query.toString(params);
        if (!params.isEmpty()) {
            sql.append(" WHERE ");
        }
        sql.append(clause);
    }

    SqlMeta getMeta(Class<?> entityType) {
        SqlMeta meta = SQL_META.get(entityType);
        if (meta == null) {
            throw new InvalidException("Entity {} mapping not found", entityType);
        }
        return meta;
    }

    @Override
    public void compact() {
        this.executeUpdate("SHUTDOWN COMPACT");
    }

    public <T> void dropIndex(Class<T> entityType, String fieldName) {
        Field field = Reflects.getFieldMap(entityType).get(fieldName);
        DbColumn dbColumn = field.getAnnotation(DbColumn.class);
        String tableName = this.tableName(entityType);
        String colName = EntityDatabaseImpl.columnName(field, dbColumn, this.autoUnderscoreColumnName);
        String sql = String.format("DROP INDEX %s ON %s;", this.indexName(tableName, colName), tableName);
        this.executeUpdate(sql);
    }

    public <T> void createIndex(Class<T> entityType, String fieldName) {
        Field field = Reflects.getFieldMap(entityType).get(fieldName);
        DbColumn dbColumn = field.getAnnotation(DbColumn.class);
        String tableName = this.tableName(entityType);
        String colName = EntityDatabaseImpl.columnName(field, dbColumn, this.autoUnderscoreColumnName);
        String index = dbColumn != null && (dbColumn.index() == DbColumn.IndexKind.UNIQUE_INDEX_ASC || dbColumn.index() == DbColumn.IndexKind.UNIQUE_INDEX_DESC) ? "UNIQUE " : "";
        String desc = dbColumn != null && (dbColumn.index() == DbColumn.IndexKind.INDEX_DESC || dbColumn.index() == DbColumn.IndexKind.UNIQUE_INDEX_DESC) ? " DESC" : "";
        String sql = String.format("CREATE %sINDEX IF NOT EXISTS %s ON %s (%s%s);", index, this.indexName(tableName, colName), tableName, colName, desc);
        this.executeUpdate(sql);
    }

    String indexName(String tableName, String columnName) {
        return String.format("%s_%s_index", tableName, columnName);
    }

    @Override
    public <T> void dropMapping(Class<T> entityType) {
        SqlMeta meta = this.getMeta(entityType);
        StringBuilder sql = new StringBuilder(meta.selectSql);
        sql.replace(0, 13, "DROP TABLE");
        this.executeUpdate(sql.toString());
        this.mappedEntityTypes.remove(entityType);
    }

    @Override
    public void createMapping(Class<?> ... entityTypes) {
        StringBuilder createCols = new StringBuilder();
        StringBuilder insert = new StringBuilder();
        for (Class<?> entityType : entityTypes) {
            createCols.setLength(0);
            String tableName = this.tableName(entityType);
            insert.setLength(0).append("INSERT INTO %s VALUES (", tableName);
            String pkName = null;
            LinkedHashMap<String, Tuple<Field, DbColumn>> columns = new LinkedHashMap<String, Tuple<Field, DbColumn>>();
            for (Field field : Reflects.getFieldMap(entityType).values()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                DbColumn dbColumn = field.getAnnotation(DbColumn.class);
                String colName = EntityDatabaseImpl.columnName(field, dbColumn, this.autoUnderscoreColumnName);
                Tuple<Field, DbColumn> tuple = Tuple.of(field, dbColumn);
                columns.put(colName, tuple);
                Class<?> fieldType = field.getType();
                String h2Type = EntityDatabaseImpl.toH2Type(fieldType);
                String extra = "";
                if (dbColumn != null) {
                    if (dbColumn.length() > 0) {
                        extra = "(" + dbColumn.length() + ")";
                    }
                    if (dbColumn.primaryKey()) {
                        pkName = colName;
                    }
                    if (dbColumn.autoIncrement()) {
                        extra = extra + " auto_increment";
                    }
                }
                createCols.appendLine("\t`%s` %s%s,", colName, h2Type, extra);
                if (dbColumn == null || !dbColumn.autoIncrement()) {
                    insert.append("?,");
                    continue;
                }
                insert.append("null,");
            }
            if (pkName == null) {
                throw new InvalidException("Require a primaryKey mapping", new Object[0]);
            }
            insert.setLength(insert.length() - 1).append(")");
            String sql = new StringBuilder(SQL_CREATE).replace($TABLE, tableName).replace($CREATE_COLUMNS, createCols.toString()).replace($PK, pkName).toString();
            log.debug("createMapping\n{}", (Object)sql);
            this.executeUpdate(sql);
            for (Tuple value : columns.values()) {
                DbColumn dbColumn = (DbColumn)value.right;
                if (dbColumn == null || dbColumn.primaryKey()) continue;
                if (dbColumn.index() == DbColumn.IndexKind.NONE) {
                    try {
                        this.dropIndex(entityType, ((Field)value.left).getName());
                    }
                    catch (Exception e) {
                        log.warn("dropIndex: {}", (Object)e.getMessage());
                    }
                    continue;
                }
                try {
                    this.createIndex(entityType, ((Field)value.left).getName());
                }
                catch (Exception e) {
                    log.warn("createIndex: {}", (Object)e.getMessage());
                }
            }
            String string = pkName;
            SQL_META.computeIfAbsent(entityType, k -> new SqlMeta(finalPkName, columns, insert.toString(), String.format("UPDATE %s SET $UPDATE_COLUMNS WHERE %s=?", tableName, finalPkName), String.format("DELETE FROM %s WHERE %s=?", tableName, finalPkName), String.format("SELECT * FROM %s", tableName)));
            this.mappedEntityTypes.add(entityType);
        }
    }

    @Override
    public String tableName(Class<?> entityType) {
        String n = Extends.metadata(entityType);
        if (n != null) {
            return n;
        }
        return this.autoUnderscoreColumnName ? CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, entityType.getSimpleName()) : entityType.getSimpleName();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static DataTable sharding(List<DataTable> queryResults, String querySql) {
        DataRow first;
        int endPos;
        DataTable template = queryResults.get(0);
        int startPos = Strings.indexOfIgnoreCase((CharSequence)querySql, (CharSequence)" WHERE ");
        if (startPos != -1) {
            int pos = startPos + " WHERE ".length();
            endPos = Strings.indexOfIgnoreCase((CharSequence)querySql, (CharSequence)" GROUP BY ", (int)pos);
            if (endPos == -1) {
                endPos = Strings.indexOfIgnoreCase((CharSequence)querySql, (CharSequence)" ORDER BY ", (int)pos);
            }
            if (endPos == -1) {
                endPos = Strings.indexOfIgnoreCase((CharSequence)querySql, (CharSequence)" LIMIT ", (int)pos);
            }
            if (endPos == -1) {
                endPos = querySql.length();
            }
            querySql = new StringBuilder(querySql).delete(startPos, endPos - startPos).toString();
        }
        if (Strings.isBlank((CharSequence)template.getTableName())) {
            String c = " FROM ";
            startPos = Strings.indexOfIgnoreCase((CharSequence)querySql, (CharSequence)c);
            if (startPos != -1) {
                endPos = querySql.indexOf(" ", startPos += c.length());
                if (endPos != -1) {
                    template.setTableName(querySql.substring(startPos, endPos));
                } else {
                    template.setTableName(querySql.substring(startPos));
                }
            }
            if (Strings.isBlank((CharSequence)template.getTableName())) {
                throw new InvalidException("Invalid table name", new Object[0]);
            }
        }
        for (DataColumn<?> column : template.getColumns()) {
            Tuple countMap = (Tuple)column.attr("HS_COUNT_MAP");
            if (countMap == null) continue;
            querySql = Strings.replaceIgnoreCase((String)querySql, (String)((String)countMap.left), (String)String.format("SUM(%s)", countMap.right));
            if (!((String)countMap.left).equalsIgnoreCase("COUNT(*)")) continue;
            querySql = Strings.replaceIgnoreCase((String)querySql, (String)"COUNT(1)", (String)String.format("SUM(%s)", countMap.right));
        }
        log.info("shardingSql: {}", (Object)querySql);
        try {
            first = (DataRow)IteratorUtils.first(template.getRows());
        }
        catch (IndexOutOfBoundsException e) {
            return template;
        }
        String tableName = template.getTableName();
        StringBuilder createCols = new StringBuilder();
        StringBuilder insert = new StringBuilder();
        insert.append("INSERT INTO %s VALUES (", tableName);
        int len = template.getColumns().size();
        ArrayList<Class<Object>> colTypes = new ArrayList<Class<Object>>(len);
        for (int i = 0; i < len; ++i) {
            Class fieldType;
            DataColumn column = template.getColumn(i);
            String colName = column.getColumnName();
            startPos = colName.indexOf("(");
            if (startPos != -1 && (endPos = colName.indexOf(")", ++startPos)) != -1) {
                colName = colName.substring(startPos, endPos);
            }
            if ((fieldType = column.getDataType()) == null && (fieldType = (Class<Object>)column.attr("HS_COLUMN_TYPE")) == null) {
                Object cell = first.get(i);
                fieldType = cell == null ? Object.class : cell.getClass();
            }
            colTypes.add(fieldType);
            createCols.appendLine("\t`%s` %s,", colName, EntityDatabaseImpl.toH2Type(fieldType));
            insert.append("?,");
        }
        createCols.setLength(createCols.length() - System.lineSeparator().length() - 1);
        String insertSql = insert.setLength(insert.length() - 1).append(")").toString();
        String url = "jdbc:h2:mem:";
        try (Connection conn = DriverManager.getConnection(url);){
            DataTable dataTable;
            block41: {
                Statement stmt = conn.createStatement();
                try {
                    String sql = new StringBuilder(SQL_CREATE_TEMP_TABLE).replace($TABLE, tableName).replace($CREATE_COLUMNS, createCols.toString()).toString();
                    log.debug("createMapping\n{}", (Object)sql);
                    stmt.executeUpdate(sql);
                    try (PreparedStatement prepStmt = conn.prepareStatement(insertSql);){
                        ArrayList<Object> params = new ArrayList<Object>();
                        for (DataTable dt : queryResults) {
                            for (DataRow row : dt.getRows()) {
                                params.clear();
                                for (DataColumn<?> col : dt.getColumns()) {
                                    params.add(row.get(col));
                                }
                                EntityDatabaseImpl.fillParams(prepStmt, params);
                                prepStmt.addBatch();
                            }
                        }
                        prepStmt.executeBatch();
                    }
                    DataTable combined = DataTable.read(stmt.executeQuery(querySql));
                    int columnCount = combined.getColumns().size();
                    for (int i = 0; i < columnCount; ++i) {
                        for (DataRow row : combined.getRows()) {
                            row.set(i, EntityDatabaseImpl.convertCell((Class)colTypes.get(i), row.get(i)));
                        }
                    }
                    dataTable = combined;
                    if (stmt == null) break block41;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return dataTable;
        }
    }

    static String toH2Type(Class<?> fieldType) {
        String h2Type = Reflects.isAssignable(fieldType, NEnum.class, (boolean)false) ? H2Type.INTEGER.getName() : (Reflects.isAssignable(fieldType, Decimal.class, (boolean)false) || fieldType == BigDecimal.class ? "NUMERIC(56, 6)" : (fieldType.isArray() ? (fieldType.getComponentType() == Object.class ? H2Type.BLOB.getName() : H2Type.JAVA_OBJECT.getName()) : H2_TYPES.getOrDefault(Reflects.primitiveToWrapper(fieldType), H2Type.JAVA_OBJECT).getName()));
        return h2Type;
    }

    public DataTable executeQuery(String sql) {
        return this.executeQuery(sql, null);
    }

    @Override
    public <T> DataTable executeQuery(String sql, Class<T> entityType) {
        return this.invoke((Connection conn) -> {
            DataTable dt = DataTable.read((JdbcResultSet)conn.createStatement().executeQuery(sql));
            if (entityType != null) {
                SqlMeta meta = this.getMeta(entityType);
                for (int i = 0; i < dt.getColumns().size(); ++i) {
                    DataColumn column = dt.getColumn(i);
                    Tuple<String, Tuple<Field, DbColumn>> bi = meta.upperColumns.get(column.getColumnName());
                    if (bi == null) continue;
                    column.setColumnName((String)bi.left);
                    Class<?> type = ((Field)((Tuple)bi.right).left).getType();
                    column.attr("HS_COLUMN_TYPE", type);
                    for (DataRow row : dt.getRows()) {
                        row.set(i, EntityDatabaseImpl.convertCell(type, row.get(i)));
                    }
                }
            }
            return dt;
        }, sql, Collections.emptyList());
    }

    @Override
    public int executeUpdate(String sql) {
        return this.invoke((Connection conn) -> conn.createStatement().executeUpdate(sql), sql, Collections.emptyList());
    }

    int executeUpdate(String sql, List<Object> params) {
        return this.invoke((Connection conn) -> {
            PreparedStatement stmt = conn.prepareStatement(sql);
            EntityDatabaseImpl.fillParams(stmt, params);
            return stmt.executeUpdate();
        }, sql, params);
    }

    <T> T executeScalar(String sql, List<Object> params) {
        return (T)this.invoke((Connection conn) -> {
            PreparedStatement stmt = conn.prepareStatement(sql);
            EntityDatabaseImpl.fillParams(stmt, params);
            try (ResultSet rs = stmt.executeQuery();){
                if (rs.next()) {
                    Object object = rs.getObject(1);
                    return object;
                }
                Object var5_6 = null;
                return var5_6;
            }
        }, sql, params);
    }

    <T> List<T> executeQuery(String sql, List<Object> params, Class<T> entityType) {
        SqlMeta meta = this.getMeta(entityType);
        ArrayList r = new ArrayList();
        this.invoke((Connection conn) -> {
            PreparedStatement stmt = conn.prepareStatement(sql);
            EntityDatabaseImpl.fillParams(stmt, params);
            try (ResultSet rs = stmt.executeQuery();){
                ResultSetMetaData metaData = rs.getMetaData();
                while (rs.next()) {
                    Object t = entityType.newInstance();
                    for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                        Tuple bi = (Tuple)meta.upperColumns.get((Object)metaData.getColumnName((int)i)).right;
                        if (bi == null) {
                            throw new InvalidException("Mapping {} not found", metaData.getColumnName(i));
                        }
                        Class<?> type = ((Field)bi.left).getType();
                        ((Field)bi.left).set(t, EntityDatabaseImpl.convertCell(type, rs.getObject(i)));
                    }
                    r.add(t);
                }
            }
        }, sql, params);
        return r;
    }

    static Object convertCell(Class<?> type, Object cell) {
        if (cell == null) {
            return Reflects.defaultValue(type);
        }
        if (type.isArray() && type.getComponentType() == Object.class) {
            Blob blob = (Blob)cell;
            Object[] arr = blob.length() == 0L ? Arrays.EMPTY_OBJECT_ARRAY : (Object[])Serializer.DEFAULT.deserialize(IOStream.wrap(null, blob.getBinaryStream()));
            return arr;
        }
        return Reflects.changeType(cell, type);
    }

    static void fillParams(PreparedStatement stmt, List<Object> params) {
        int i = 0;
        while (i < params.size()) {
            Object val;
            if ((val = params.get(i++)) instanceof NEnum) {
                stmt.setInt(i, ((NEnum)val).getValue());
                continue;
            }
            if (val instanceof Object[]) {
                IOStream stream = Serializer.DEFAULT.serialize(val);
                try {
                    stmt.setBinaryStream(i, stream.getReader());
                    continue;
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                    continue;
                }
            }
            if (val instanceof Decimal) {
                stmt.setBigDecimal(i, ((Decimal)val).getValue());
                continue;
            }
            stmt.setObject(i, val);
        }
    }

    @Override
    public boolean isInTransaction() {
        return TX_CONN.isSet();
    }

    @Override
    public void begin() {
        this.begin(0);
    }

    @Override
    public void begin(int transactionIsolation) {
        Connection conn = (Connection)TX_CONN.getIfExists();
        if (conn == null) {
            conn = this.getConnectionPool().getConnection();
            TX_CONN.set((Object)conn);
        }
        if (transactionIsolation != 0) {
            conn.setTransactionIsolation(transactionIsolation);
        }
        conn.setAutoCommit(false);
    }

    @Override
    public void commit() {
        Connection conn = (Connection)TX_CONN.getIfExists();
        if (conn == null) {
            throw new InvalidException("Not in transaction", new Object[0]);
        }
        TX_CONN.remove();
        conn.commit();
        conn.close();
    }

    @Override
    public void rollback() {
        Connection conn = (Connection)TX_CONN.getIfExists();
        if (conn == null) {
            log.warn("Not in transaction");
            return;
        }
        TX_CONN.remove();
        conn.rollback();
        conn.close();
    }

    private void invoke(BiAction<Connection> fn, String sql, List<Object> params) {
        boolean isInTx;
        Connection conn = (Connection)TX_CONN.getIfExists();
        boolean bl = isInTx = conn != null;
        if (!isInTx) {
            conn = this.getConnectionPool().getConnection();
        }
        long startTime = System.nanoTime();
        try {
            fn.invoke(conn);
        }
        catch (Throwable e) {
            if (isInTx && this.autoRollbackOnError) {
                this.rollback();
            }
            throw e;
        }
        finally {
            this.postInvoke(sql, params, conn, isInTx, startTime);
        }
    }

    private void postInvoke(String sql, List<Object> params, Connection conn, boolean isInTx, long startTime) throws SQLException {
        long elapsed = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
        if (!isInTx) {
            conn.close();
        }
        if (elapsed > (long)this.slowSqlElapsed) {
            log.warn("slowSql: {} -> {}ms", (Object)sql, (Object)elapsed);
        } else if (log.isDebugEnabled()) {
            log.debug("executeQuery {}\n{}", (Object)sql, (Object)Sys.toJsonString(params));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T invoke(BiFunc<Connection, T> fn, String sql, List<Object> params) {
        boolean isInTx;
        Connection conn = (Connection)TX_CONN.getIfExists();
        boolean bl = isInTx = conn != null;
        if (!isInTx) {
            conn = this.getConnectionPool().getConnection();
        }
        long startTime = System.nanoTime();
        try {
            Connection t = fn.invoke(conn);
            return (T)t;
        }
        catch (Throwable e) {
            if (!isInTx) throw e;
            if (!this.autoRollbackOnError) throw e;
            this.rollback();
            throw e;
        }
        finally {
            this.postInvoke(sql, params, conn, isInTx, startTime);
        }
    }

    public void setRollingHours(int rollingHours) {
        this.rollingHours = rollingHours;
    }

    public void setAutoUnderscoreColumnName(boolean autoUnderscoreColumnName) {
        this.autoUnderscoreColumnName = autoUnderscoreColumnName;
    }

    public void setAutoRollbackOnError(boolean autoRollbackOnError) {
        this.autoRollbackOnError = autoRollbackOnError;
    }

    public void setSlowSqlElapsed(int slowSqlElapsed) {
        this.slowSqlElapsed = slowSqlElapsed;
    }

    static {
        H2_TYPES.put(String.class, H2Type.VARCHAR);
        H2_TYPES.put(byte[].class, H2Type.VARBINARY);
        H2_TYPES.put(Boolean.class, H2Type.BOOLEAN);
        H2_TYPES.put(Byte.class, H2Type.TINYINT);
        H2_TYPES.put(Short.class, H2Type.SMALLINT);
        H2_TYPES.put(Integer.class, H2Type.INTEGER);
        H2_TYPES.put(Long.class, H2Type.BIGINT);
        H2_TYPES.put(BigDecimal.class, H2Type.NUMERIC);
        H2_TYPES.put(Float.class, H2Type.REAL);
        H2_TYPES.put(Double.class, H2Type.DOUBLE_PRECISION);
        H2_TYPES.put(Date.class, H2Type.TIMESTAMP);
        H2_TYPES.put(Timestamp.class, H2Type.TIMESTAMP);
        H2_TYPES.put(UUID.class, H2Type.UUID);
        H2_TYPES.put(Reader.class, H2Type.CLOB);
        H2_TYPES.put(InputStream.class, H2Type.BLOB);
        Driver driver = Driver.load();
        log.info("Load H2 driver {}.{}", (Object)driver.getMajorVersion(), (Object)driver.getMinorVersion());
    }

    static class SqlMeta {
        final Map.Entry<String, Tuple<Field, DbColumn>> primaryKey;
        final Map<String, Tuple<Field, DbColumn>> columns;
        final Map<String, Tuple<String, Tuple<Field, DbColumn>>> upperColumns = new HashMap<String, Tuple<String, Tuple<Field, DbColumn>>>();
        final Linq<Map.Entry<String, Tuple<Field, DbColumn>>> insertView;
        final Linq<Map.Entry<String, Tuple<Field, DbColumn>>> secondaryView;
        final String insertSql;
        final String updateSql;
        final String deleteSql;
        final String selectSql;

        public SqlMeta(String primaryKey, Map<String, Tuple<Field, DbColumn>> columns, String insertSql, String updateSql, String deleteSql, String selectSql) {
            this.primaryKey = new AbstractMap.SimpleEntry<String, Tuple<Field, DbColumn>>(primaryKey, columns.get(primaryKey));
            this.columns = columns;
            for (Map.Entry<String, Tuple<Field, DbColumn>> entry : columns.entrySet()) {
                this.upperColumns.put(entry.getKey().toUpperCase(), Tuple.of(entry.getKey(), entry.getValue()));
            }
            this.insertView = Linq.from(columns.entrySet()).where(p -> ((Tuple)p.getValue()).right == null || !((DbColumn)((Tuple)p.getValue()).right).autoIncrement());
            this.secondaryView = Linq.from(columns.entrySet()).where(p -> !Extends.eq((String)p.getKey(), this.getPrimaryKey().getKey()));
            this.insertSql = insertSql;
            this.updateSql = updateSql;
            this.deleteSql = deleteSql;
            this.selectSql = selectSql;
        }

        public SqlMeta(Map.Entry<String, Tuple<Field, DbColumn>> primaryKey, Map<String, Tuple<Field, DbColumn>> columns, Linq<Map.Entry<String, Tuple<Field, DbColumn>>> insertView, Linq<Map.Entry<String, Tuple<Field, DbColumn>>> secondaryView, String insertSql, String updateSql, String deleteSql, String selectSql) {
            this.primaryKey = primaryKey;
            this.columns = columns;
            this.insertView = insertView;
            this.secondaryView = secondaryView;
            this.insertSql = insertSql;
            this.updateSql = updateSql;
            this.deleteSql = deleteSql;
            this.selectSql = selectSql;
        }

        public Map.Entry<String, Tuple<Field, DbColumn>> getPrimaryKey() {
            return this.primaryKey;
        }

        public Map<String, Tuple<Field, DbColumn>> getColumns() {
            return this.columns;
        }
    }
}

