/*
 * Decompiled with CFR 0.152.
 */
package org.rx.io;

import java.io.EOFException;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.NonNull;
import org.rx.codec.CodecUtil;
import org.rx.core.Constants;
import org.rx.core.Disposable;
import org.rx.core.Linq;
import org.rx.core.Sys;
import org.rx.core.Tasks;
import org.rx.exception.InvalidException;
import org.rx.io.Bytes;
import org.rx.io.FileStream;
import org.rx.io.KeyIndexer;
import org.rx.io.Serializer;
import org.rx.io.WALFileStream;

class ExternalSortingIndexer<TK>
extends Disposable
implements KeyIndexer<TK> {
    static final int DEF_SORT_VAL = 0x7FFFFFFE;
    static final HashKey[] ARR_TYPE = new HashKey[0];
    final WALFileStream wal;
    final long bufSize;
    final CopyOnWriteArrayList<Partition> partitions = new CopyOnWriteArrayList();
    boolean enableCache = true;
    long cacheTtl = 60000L;

    public ExternalSortingIndexer(File file, long bufSize, int readerCount) {
        int b = 24;
        this.bufSize = bufSize = bufSize / (long)b * (long)b;
        this.wal = new WALFileStream(file, bufSize, readerCount, Serializer.DEFAULT);
        this.wal.onGrow.combine((s, e) -> this.ensureGrow());
        this.ensureGrow();
    }

    @Override
    protected void freeObjects() {
        this.wal.close();
    }

    void ensureGrow() {
        this.wal.lock.writeInvoke(() -> {
            int count = (int)(this.wal.getLength() / this.bufSize);
            for (int i = this.partitions.size(); i < count; ++i) {
                this.partitions.add(new Partition(256L + (long)i * this.bufSize, this.bufSize));
            }
            int rc = this.partitions.size() - count;
            for (int i = 0; i < rc; ++i) {
                this.partitions.remove(this.partitions.size() - 1);
            }
        }, 256L);
    }

    public long size() {
        return (long)Linq.from(this.partitions).where(p -> p.keySize != -1).sum(p -> p.keySize);
    }

    @Override
    public KeyIndexer.KeyEntity<TK> newKey(TK key) {
        return new HashKey<TK>(key);
    }

    @Override
    public void save(@NonNull KeyIndexer.KeyEntity<TK> key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        HashKey fk = (HashKey)key;
        for (Partition partition : this.route(fk)) {
            if (partition.save(fk)) break;
        }
    }

    @Override
    public KeyIndexer.KeyEntity<TK> find(@NonNull TK k) {
        if (k == null) {
            throw new NullPointerException("k is marked non-null but is null");
        }
        HashKey<TK> fk = new HashKey<TK>(k);
        for (Partition partition : this.route(fk)) {
            if (!partition.find(fk)) continue;
            return fk;
        }
        return null;
    }

    Iterable<Partition> route(HashKey<TK> fk) {
        if (this.partitions.size() <= 5) {
            return this.partitions;
        }
        return this.wal.lock.readInvoke(() -> Linq.from(this.partitions).orderBy(p -> {
            HashKey min = p.min;
            HashKey max = p.max;
            if (min == null || max == null) {
                return Integer.MAX_VALUE;
            }
            if (min.hashId <= fk.hashId && fk.hashId <= max.hashId) {
                return p.keySize;
            }
            return 0x7FFFFFFE;
        }), 256L);
    }

    @Override
    public void clear() {
        this.wal.lock.writeInvoke(() -> {
            for (Partition partition : this.partitions) {
                partition.clear();
            }
            this.wal.clear();
        });
    }

    public String toString() {
        return "ExternalSortingIndexer{name=" + this.wal.getName() + ", bufSize=" + this.bufSize + ", partitions=" + Linq.from(this.partitions).select(p -> p.keySize).toList() + " / " + this.size() + '}';
    }

    public void setEnableCache(boolean enableCache) {
        this.enableCache = enableCache;
    }

    public void setCacheTtl(long cacheTtl) {
        this.cacheTtl = cacheTtl;
    }

    class Partition
    extends FileStream.Block {
        final long endPos;
        volatile int keySize;
        volatile HashKey<TK> min;
        volatile HashKey<TK> max;
        volatile WeakReference<HashKey<TK>[]> ref;

        Partition(long position, long size) {
            super(position, size);
            this.keySize = -1;
            this.endPos = position + size;
        }

        void clear() {
            ExternalSortingIndexer.this.wal.lock.writeInvoke(() -> {
                ExternalSortingIndexer.this.wal.setPosition(this.position);
                int i = 0;
                while ((long)i < this.size) {
                    ExternalSortingIndexer.this.wal.write(0);
                    ++i;
                }
                this.keySize = 0;
                this.max = null;
                this.min = null;
                this.setCache(null);
            }, this.position, this.size);
        }

        void setCache(HashKey<TK>[] ks) {
            if (ks == null) {
                this.ref = null;
                return;
            }
            if (ExternalSortingIndexer.this.enableCache) {
                this.ref = new WeakReference<HashKey<TK>[]>(ks);
                Tasks.setTimeout(ks::getClass, ExternalSortingIndexer.this.cacheTtl, this, Constants.TIMER_REPLACE_FLAG);
            }
        }

        HashKey<TK>[] unsafeLoad() {
            HashKey[] ks;
            WeakReference<HashKey<TK>[]> r = this.ref;
            HashKey[] hashKeyArray = ks = r != null ? (HashKey[])r.get() : null;
            if (ks == null) {
                int keySize = this.keySize;
                boolean setSize = keySize == -1;
                ArrayList keys = new ArrayList(setSize ? 10 : keySize);
                ExternalSortingIndexer.this.wal.setReaderPosition(this.position);
                int b = 24;
                byte[] buf = new byte[b];
                int kSize = setSize ? Integer.MAX_VALUE : keySize;
                for (long i = 0L; i < this.size && keys.size() < kSize; i += (long)b) {
                    if (ExternalSortingIndexer.this.wal.read(buf, 0, buf.length) != b) {
                        throw new EOFException();
                    }
                    HashKey k = new HashKey();
                    k.hashId = Bytes.getLong(buf, 0);
                    if (k.hashId == 0L) break;
                    k.logPosition = Bytes.getLong(buf, 8);
                    k.keyPos = Bytes.getLong(buf, 16);
                    keys.add(k);
                }
                ks = keys.toArray(ARR_TYPE);
                if (setSize) {
                    this.keySize = ks.length;
                    if (ks.length == 0) {
                        this.max = null;
                        this.min = null;
                    } else {
                        this.min = ks[0];
                        this.max = ks[ks.length - 1];
                    }
                }
                this.setCache(ks);
            }
            return ks;
        }

        boolean find(HashKey<TK> ktf) {
            return ExternalSortingIndexer.this.wal.lock.readInvoke(() -> {
                Object[] keys = this.unsafeLoad();
                int i = Arrays.binarySearch(keys, ktf);
                if (i < 0) {
                    return false;
                }
                Object t = keys[i];
                ktf.logPosition = ((HashKey)t).logPosition;
                ktf.keyPos = ((HashKey)t).keyPos;
                return true;
            });
        }

        boolean save(HashKey<TK> ktf) {
            long newLogPos = ktf.logPosition;
            return ExternalSortingIndexer.this.wal.lock.writeInvoke(() -> {
                if (this.find(ktf)) {
                    ktf.logPosition = newLogPos;
                    ExternalSortingIndexer.this.wal.setPosition(ktf.keyPos + 8L);
                    ExternalSortingIndexer.this.wal.write(Bytes.getBytes(ktf.logPosition));
                    WeakReference<HashKey<TK>[]> ref = this.ref;
                    HashKey[] ks = ref != null ? (HashKey[])ref.get() : null;
                    if (ks != null) {
                        int i = (int)(ktf.keyPos - this.position) / 24;
                        HashKey k = ks[i];
                        if (k.hashId != ktf.hashId) {
                            throw new InvalidException("compute index error", new Object[0]);
                        }
                        ks[i].logPosition = ktf.logPosition;
                    }
                    return true;
                }
                long wPos = ExternalSortingIndexer.this.wal.getPosition();
                if (wPos < this.endPos) {
                    HashKey<TK>[] oks = this.unsafeLoad();
                    Comparable[] ks = new HashKey[oks.length + 1];
                    System.arraycopy(oks, 0, ks, 0, oks.length);
                    ks[ks.length - 1] = Sys.deepClone(ktf);
                    Arrays.parallelSort((Comparable[])ks);
                    ExternalSortingIndexer.this.wal.setPosition(this.position);
                    byte[] buf = new byte[24];
                    for (Comparable fk : ks) {
                        ((HashKey)fk).keyPos = ExternalSortingIndexer.this.wal.getPosition();
                        Bytes.getBytes(((HashKey)fk).hashId, buf, 0);
                        Bytes.getBytes(((HashKey)fk).logPosition, buf, 8);
                        Bytes.getBytes(((HashKey)fk).keyPos, buf, 16);
                        ExternalSortingIndexer.this.wal.write(buf);
                    }
                    this.keySize = ks.length;
                    this.min = ks[0];
                    this.max = ks[this.keySize - 1];
                    this.setCache((HashKey<TK>[])ks);
                    return true;
                }
                return false;
            }, this.position, this.size);
        }
    }

    static class HashKey<TK>
    extends KeyIndexer.KeyEntity<TK>
    implements Comparable<HashKey<TK>> {
        static final int BYTES = 24;
        private static final long serialVersionUID = -3136532663217712845L;
        long hashId;
        long keyPos = -1L;

        static <TK> long hash(TK key) {
            return key instanceof Long ? (Long)key : CodecUtil.hash64(Serializer.DEFAULT.serializeToBytes(key));
        }

        private HashKey() {
            super(null);
        }

        public HashKey(TK key) {
            super(key);
            this.hashId = HashKey.hash(key);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HashKey hashKey = (HashKey)o;
            return this.hashId == hashKey.hashId;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.hashId);
        }

        @Override
        public int compareTo(HashKey<TK> o) {
            return Long.compare(this.hashId, o.hashId);
        }

        @Override
        public String toString() {
            return "ExternalSortingIndexer.HashKey(super=" + super.toString() + ", hashId=" + this.hashId + ", keyPos=" + this.keyPos + ")";
        }
    }
}

