/*
 * Decompiled with CFR 0.152.
 */
package org.rx.io;

import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import javax.activation.MimetypesFileTypeMap;
import lombok.NonNull;
import org.rx.bean.FlagsEnum;
import org.rx.io.BufferedRandomAccessFile;
import org.rx.io.Bytes;
import org.rx.io.CompositeLock;
import org.rx.io.CompositeMmap;
import org.rx.io.FileMode;
import org.rx.io.Files;
import org.rx.io.IOStream;
import org.rx.util.Lazy;
import org.rx.util.Snowflake;
import org.rx.util.function.TripleFunc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStream
extends IOStream
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(FileStream.class);
    private static final long serialVersionUID = 8857792573177348449L;
    private FileMode fileMode;
    private FlagsEnum<CompositeLock.Flags> lockFlags;
    private transient BufferedRandomAccessFile randomAccessFile;
    private final transient Lazy<CompositeLock> lock = new Lazy<CompositeLock>(() -> new CompositeLock(this, this.lockFlags));
    private transient InputStream reader;
    private transient OutputStream writer;

    public static File createTempFile() {
        File temp = File.createTempFile(String.valueOf(Snowflake.DEFAULT.nextId()), ".rfs");
        temp.setReadable(true);
        temp.setWritable(true);
        return temp;
    }

    public CompositeLock getLock() {
        return this.lock.getValue();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeUTF(this.randomAccessFile.getPath());
        out.writeLong(this.getPosition());
        this.setPosition(0L);
        this.read(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        File file;
        in.defaultReadObject();
        if (this.fileMode == FileMode.READ_ONLY) {
            this.fileMode = FileMode.READ_WRITE;
        }
        if ((file = new File(in.readUTF())).exists()) {
            file = FileStream.createTempFile();
        }
        try {
            this.randomAccessFile = new BufferedRandomAccessFile(file, this.fileMode, 4096);
        }
        catch (Exception e) {
            log.warn("readObject", (Throwable)e);
            this.randomAccessFile = new BufferedRandomAccessFile(FileStream.createTempFile(), this.fileMode, 4096);
        }
        long pos = in.readLong();
        this.write(in);
        this.setPosition(pos);
    }

    public String getPath() {
        return this.randomAccessFile.getPath();
    }

    @Override
    public String getName() {
        return Files.getName((String)this.getPath());
    }

    public String getContentType() {
        MimetypesFileTypeMap mimeTypesMap = new MimetypesFileTypeMap();
        return mimeTypesMap.getContentType(this.getPath());
    }

    @Override
    public InputStream getReader() {
        if (this.reader == null) {
            this.reader = new InputStream(){

                @Override
                public int available() {
                    return IOStream.safeRemaining(FileStream.this.available());
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    return FileStream.this.randomAccessFile.read(b, off, len);
                }

                @Override
                public int read() throws IOException {
                    return FileStream.this.randomAccessFile.read();
                }
            };
        }
        return this.reader;
    }

    @Override
    public OutputStream getWriter() {
        if (this.writer == null) {
            this.writer = new OutputStream(){

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    FileStream.this.randomAccessFile.write(b, off, len);
                }

                @Override
                public void write(int b) throws IOException {
                    FileStream.this.randomAccessFile.write(b);
                }

                @Override
                public void flush() {
                    FileStream.this.flush();
                }
            };
        }
        return this.writer;
    }

    public synchronized boolean canWrite() {
        return !this.isClosed() && this.fileMode != FileMode.READ_ONLY;
    }

    @Override
    public boolean canSeek() {
        return true;
    }

    @Override
    public synchronized long getPosition() {
        return this.randomAccessFile.getFilePointer();
    }

    @Override
    public synchronized void setPosition(long position) {
        this.randomAccessFile.seek(position);
    }

    @Override
    public synchronized long getLength() {
        return this.randomAccessFile.length();
    }

    public synchronized void setLength(long length) {
        this.randomAccessFile.setLength(length);
    }

    public synchronized String getAttribute(String attrName) {
        UserDefinedFileAttributeView view = java.nio.file.Files.getFileAttributeView(Paths.get(this.randomAccessFile.getPath(), new String[0]), UserDefinedFileAttributeView.class, new LinkOption[0]);
        ByteBuffer buf = ByteBuffer.allocate(view.size(attrName));
        view.read(attrName, buf);
        buf.flip();
        return StandardCharsets.UTF_8.decode(buf).toString();
    }

    public synchronized void setAttribute(String attrName, String attrValue) {
        UserDefinedFileAttributeView view = java.nio.file.Files.getFileAttributeView(Paths.get(this.randomAccessFile.getPath(), new String[0]), UserDefinedFileAttributeView.class, new LinkOption[0]);
        if (attrValue == null) {
            view.delete(attrName);
            return;
        }
        view.write(attrName, StandardCharsets.UTF_8.encode(attrValue));
    }

    public FileStream() {
        this(FileStream.createTempFile());
    }

    public FileStream(String filePath) {
        this(new File(filePath));
    }

    public FileStream(File file) {
        this(file, FileMode.READ_WRITE, 4096);
    }

    public FileStream(File file, FileMode mode, int bufSize) {
        this(file, mode, bufSize, CompositeLock.Flags.READ_WRITE_LOCK.flags());
    }

    public FileStream(@NonNull File file, FileMode mode, int bufSize, @NonNull FlagsEnum<CompositeLock.Flags> lockFlags) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (lockFlags == null) {
            throw new NullPointerException("lockFlags is marked non-null but is null");
        }
        this.fileMode = mode;
        this.randomAccessFile = new BufferedRandomAccessFile(file, this.fileMode, bufSize);
        this.lockFlags = lockFlags;
    }

    @Override
    protected void freeObjects() throws Throwable {
        this.randomAccessFile.close();
    }

    @Override
    public synchronized byte[] toArray() {
        return super.toArray();
    }

    public final synchronized FileStream flip() {
        this.setLength(this.getPosition());
        this.setPosition(0L);
        return this;
    }

    @Override
    public synchronized long available() {
        return this.randomAccessFile.bytesRemaining();
    }

    @Override
    public synchronized int read(ByteBuf dst, int length) {
        int r;
        long pos = this.getPosition();
        FileChannel ch = this.randomAccessFile.getChannel();
        ch.position(pos);
        int totalRead = 0;
        ByteBuffer buffer = ByteBuffer.allocateDirect(Math.min(length, 4096));
        TripleFunc<ByteBuffer, Integer, ByteBuffer> resetFunc = (b, c) -> {
            b.clear();
            if (c < b.limit()) {
                b.limit((int)c);
            }
            return b;
        };
        while ((r = ch.read(resetFunc.invoke(buffer, length))) > 0) {
            buffer.flip();
            dst.writeBytes(buffer);
            length -= r;
            totalRead += r;
        }
        this.setPosition(pos + (long)totalRead);
        return totalRead;
    }

    @Override
    public void write(ByteBuf src, int length) {
        this.write0(src, length);
    }

    public long write0(ByteBuf src) {
        return this.write0(src, src.readableBytes());
    }

    public synchronized long write0(ByteBuf src, int length) {
        long w;
        long pos = this.getPosition();
        FileChannel ch = this.randomAccessFile.getChannel();
        ch.position(pos);
        int rIndex = src.readerIndex();
        int rEndIndex = rIndex + length;
        ByteBuf buf = src;
        if (buf.readableBytes() != length) {
            buf = buf.slice(rIndex, rEndIndex);
        }
        switch (buf.nioBufferCount()) {
            case 0: {
                w = ch.write(ByteBuffer.wrap(Bytes.getBytes(buf)));
                break;
            }
            case 1: {
                w = ch.write(buf.nioBuffer());
                break;
            }
            default: {
                w = ch.write(buf.nioBuffers());
            }
        }
        src.readerIndex(rEndIndex);
        this.setPosition(pos + w);
        return w;
    }

    @Override
    public void flush() {
        this.flush(false);
    }

    public synchronized void flush(boolean flushToDisk) {
        this.randomAccessFile.flush();
        if (flushToDisk) {
            this.randomAccessFile.sync();
        }
    }

    public CompositeMmap mmap(FileChannel.MapMode mode) {
        long pos = this.getPosition();
        return this.mmap(mode, pos, this.getLength() - pos);
    }

    public CompositeMmap mmap(FileChannel.MapMode mode, long position, long size) {
        if (mode == null) {
            mode = FileChannel.MapMode.READ_WRITE;
        }
        return new CompositeMmap(this, mode, new Block(position, size));
    }

    protected BufferedRandomAccessFile getRandomAccessFile() {
        return this.randomAccessFile;
    }

    public static class Block {
        public final long position;
        public final long size;

        public Block(long position, long size) {
            this.position = position;
            this.size = size;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Block)) {
                return false;
            }
            Block other = (Block)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.position != other.position) {
                return false;
            }
            return this.size == other.size;
        }

        protected boolean canEqual(Object other) {
            return other instanceof Block;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $position = this.position;
            result = result * 59 + (int)($position >>> 32 ^ $position);
            long $size = this.size;
            result = result * 59 + (int)($size >>> 32 ^ $size);
            return result;
        }
    }
}

