/*
 * Decompiled with CFR 0.152.
 */
package org.rx.io;

import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.concurrent.Future;
import org.rx.bean.FlagsEnum;
import org.rx.core.Delegate;
import org.rx.core.Disposable;
import org.rx.core.EventArgs;
import org.rx.core.EventPublisher;
import org.rx.core.Extends;
import org.rx.core.Tasks;
import org.rx.io.Files;
import org.rx.util.function.PredicateFunc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileWatcher
extends Disposable
implements EventPublisher<FileWatcher> {
    private static final Logger log = LoggerFactory.getLogger(FileWatcher.class);
    public final Delegate<FileWatcher, FileChangeEventArgs> onChanged = Delegate.create();
    private final String directoryPath;
    private final WatchService service;
    private final Future<?> future;
    private PredicateFunc<Path> filter;

    @Override
    public FlagsEnum<EventPublisher.EventFlags> eventFlags() {
        return EventPublisher.EventFlags.QUIETLY.flags();
    }

    public FileWatcher(String directoryPath) {
        this(directoryPath, null);
    }

    public FileWatcher(String directoryPath, PredicateFunc<Path> filter) {
        this.directoryPath = directoryPath;
        this.filter = filter;
        Files.createDirectory(directoryPath);
        this.service = FileSystems.getDefault().newWatchService();
        Paths.get(directoryPath, new String[0]).register(this.service, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
        this.future = Tasks.run(() -> {
            while (!this.isClosed()) {
                Extends.quietly(() -> {
                    WatchKey key = this.service.take();
                    for (WatchEvent<?> event : key.pollEvents()) {
                        this.raiseEvent(event);
                    }
                    key.reset();
                });
            }
        });
    }

    @Override
    protected void freeObjects() throws Throwable {
        this.future.cancel(true);
        this.service.close();
    }

    private void raiseEvent(WatchEvent<?> tmp) {
        WatchEvent<?> event = tmp;
        Path absolutePath = Paths.get(this.directoryPath, ((Path)event.context()).toString());
        if (this.filter != null && !this.filter.test(absolutePath)) {
            return;
        }
        this.raiseEvent(this.onChanged, new FileChangeEventArgs(absolutePath, event.kind()));
    }

    public String getDirectoryPath() {
        return this.directoryPath;
    }

    public void setFilter(PredicateFunc<Path> filter) {
        this.filter = filter;
    }

    public static class FileChangeEventArgs
    extends EventArgs {
        final Path path;
        final WatchEvent.Kind<Path> changeKind;

        public boolean isCreate() {
            return StandardWatchEventKinds.ENTRY_CREATE.equals(this.changeKind);
        }

        public boolean isModify() {
            return StandardWatchEventKinds.ENTRY_MODIFY.equals(this.changeKind);
        }

        public boolean isDelete() {
            return StandardWatchEventKinds.ENTRY_DELETE.equals(this.changeKind);
        }

        public FileChangeEventArgs(Path path, WatchEvent.Kind<Path> changeKind) {
            this.path = path;
            this.changeKind = changeKind;
        }

        public Path getPath() {
            return this.path;
        }
    }
}

