/*
 * Decompiled with CFR 0.152.
 */
package org.rx.io;

import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Stream;
import lombok.NonNull;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.CompressionLevel;
import net.lingala.zip4j.model.enums.EncryptionMethod;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.rx.core.Arrays;
import org.rx.core.Linq;
import org.rx.core.StringBuilder;
import org.rx.core.Strings;
import org.rx.exception.InvalidException;
import org.rx.io.CrudFile;
import org.rx.io.IOStream;
import org.rx.io.LocalCrudFile;

public class Files
extends FilenameUtils {
    public static final CrudFile<File> CURD_FILE = new LocalCrudFile();

    public static boolean isDirectory(String path) {
        return CURD_FILE.isDirectoryPath(path);
    }

    public static String createDirectory(String path) {
        return CURD_FILE.createDirectory(path);
    }

    public static void saveFile(String filePath, InputStream in) {
        CURD_FILE.saveFile(filePath, in);
    }

    public static void delete(String path) {
        CURD_FILE.delete(path);
    }

    public static Linq<File> listDirectories(String directoryPath, boolean recursive) {
        return CURD_FILE.listDirectories(directoryPath, recursive);
    }

    public static Linq<File> listFiles(String directoryPath, boolean recursive) {
        return CURD_FILE.listFiles(directoryPath, recursive);
    }

    public static boolean isPath(String str) {
        return str != null && (str.startsWith("/") || str.startsWith("\\") || str.startsWith(":\\", 1));
    }

    public static String concatPath(@NonNull String root, String ... paths) {
        if (root == null) {
            throw new NullPointerException("root is marked non-null but is null");
        }
        StringBuilder p = new StringBuilder(CURD_FILE.padDirectoryPath(root));
        if (!Arrays.isEmpty((Object[])paths)) {
            int l = paths.length - 1;
            for (int i = 0; i < l; ++i) {
                p.append(CURD_FILE.padDirectoryPath(paths[i]));
            }
            p.append(paths[l]);
        }
        return p.toString();
    }

    public static String changeExtension(@NonNull String filePath, String ext) {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        return String.format("%s.%s", Files.removeExtension((String)filePath), ext);
    }

    public static boolean isEmptyDirectory(String directoryPath) {
        boolean bl;
        block9: {
            Path dir = Paths.get(directoryPath, new String[0]);
            if (!java.nio.file.Files.isDirectory(dir, new LinkOption[0])) {
                throw new InvalidException("Path {} is not a directory", directoryPath);
            }
            Stream<Path> entries = java.nio.file.Files.list(dir);
            try {
                boolean bl2 = bl = !entries.findFirst().isPresent();
                if (entries == null) break block9;
            }
            catch (Throwable throwable) {
                if (entries != null) {
                    try {
                        entries.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            entries.close();
        }
        return bl;
    }

    public static void copy(String srcPath, String destPath) {
        File src = new File(srcPath);
        File dest = new File(destPath);
        if (src.isDirectory()) {
            FileUtils.copyDirectoryToDirectory((File)src, (File)dest);
            return;
        }
        if (dest.isDirectory()) {
            FileUtils.copyFileToDirectory((File)src, (File)dest);
            return;
        }
        FileUtils.copyFile((File)src, (File)dest);
    }

    public static void move(String srcPath, String destPath) {
        File src = new File(srcPath);
        File dest = new File(destPath);
        if (src.isDirectory()) {
            FileUtils.moveDirectory((File)src, (File)dest);
            return;
        }
        if (dest.isDirectory()) {
            FileUtils.moveFileToDirectory((File)src, (File)dest, (boolean)true);
            return;
        }
        FileUtils.moveFile((File)src, (File)dest);
    }

    public static void deleteBefore(String directoryPath, Date time) {
        Files.deleteBefore(directoryPath, time, null);
    }

    public static void deleteBefore(@NonNull String directoryPath, @NonNull Date time, String wildcard) {
        if (directoryPath == null) {
            throw new NullPointerException("directoryPath is marked non-null but is null");
        }
        if (time == null) {
            throw new NullPointerException("time is marked non-null but is null");
        }
        File dir = new File(directoryPath);
        if (!dir.exists()) {
            return;
        }
        IOFileFilter fileFilter = FileFilterUtils.ageFileFilter((Date)time);
        if (wildcard != null) {
            fileFilter = fileFilter.and((IOFileFilter)new WildcardFileFilter(wildcard));
        }
        for (File file : FileUtils.listFiles((File)dir, (IOFileFilter)fileFilter, (IOFileFilter)FileFilterUtils.directoryFileFilter())) {
            Files.delete(file.getPath());
        }
        for (File directory : Files.listDirectories(directoryPath, true)) {
            if (!Files.isEmptyDirectory(directory.getPath())) continue;
            directory.delete();
        }
    }

    public static String getMediaTypeFromName(String fileName) {
        String ext = Files.getExtension((String)fileName);
        if (Strings.isEmpty((CharSequence)ext)) {
            return "application/octet-stream";
        }
        if (Strings.equalsIgnoreCase((CharSequence)ext, (CharSequence)"png")) {
            return "image/png";
        }
        if (Strings.equalsIgnoreCase((CharSequence)ext, (CharSequence)"gif")) {
            return "image/gif";
        }
        if (Strings.equalsIgnoreCase((CharSequence)ext, (CharSequence)"jpg") || Strings.equalsIgnoreCase((CharSequence)ext, (CharSequence)"jpeg")) {
            return "image/jpeg";
        }
        if (Strings.equalsIgnoreCase((CharSequence)ext, (CharSequence)"pdf")) {
            return "application/pdf";
        }
        if (Strings.equalsIgnoreCase((CharSequence)ext, (CharSequence)"txt")) {
            return "text/markdown";
        }
        if (Strings.equalsIgnoreCase((CharSequence)ext, (CharSequence)"md")) {
            return "text/plain";
        }
        return "application/octet-stream";
    }

    public static Stream<String> readLines(String filePath) {
        return Files.readLines(filePath, StandardCharsets.UTF_8);
    }

    public static Stream<String> readLines(String filePath, Charset charset) {
        return java.nio.file.Files.lines(Paths.get(filePath, new String[0]), charset);
    }

    public static void writeLines(String filePath, Iterable<CharSequence> lines) {
        Files.writeLines(filePath, lines, StandardCharsets.UTF_8, new StandardOpenOption[0]);
    }

    public static void writeLines(String filePath, Iterable<CharSequence> lines, Charset charset, StandardOpenOption ... options) {
        java.nio.file.Files.write(Paths.get(filePath, new String[0]), lines, charset, (OpenOption[])options);
    }

    public static void zip(String zipFile, String srcPath) {
        Files.zip(new File(zipFile), null, Collections.singletonList(new File(srcPath)), Collections.emptyList());
    }

    public static void zip(String zipFile, IOStream srcStream) {
        Files.zip(new File(zipFile), null, Collections.emptyList(), Collections.singletonList(srcStream));
    }

    public static <T extends IOStream> void zip(File zipFile, String password, List<File> srcPaths, List<T> srcStreams) {
        try (ZipFile zip = new ZipFile(zipFile, password == null ? null : password.toCharArray());){
            ZipParameters zipParameters = new ZipParameters();
            zipParameters.setCompressionLevel(CompressionLevel.HIGHER);
            if (password != null) {
                zipParameters.setEncryptFiles(true);
                zipParameters.setEncryptionMethod(EncryptionMethod.AES);
            }
            if (!CollectionUtils.isEmpty(srcPaths)) {
                for (File srcPath : srcPaths) {
                    if (srcPath.isDirectory()) {
                        zip.addFolder(srcPath, zipParameters);
                        continue;
                    }
                    zip.addFile(srcPath, zipParameters);
                }
            }
            if (!CollectionUtils.isEmpty(srcStreams)) {
                for (IOStream srcStream : srcStreams) {
                    zipParameters.setFileNameInZip(srcStream.getName());
                    zip.addStream(srcStream.getReader(), zipParameters);
                }
            }
        }
    }

    public static void unzip(String zipFile) {
        Files.unzip(zipFile, "./");
    }

    public static void unzip(String zipFile, String destPath) {
        Files.unzip(new File(zipFile), null, destPath);
    }

    public static void unzip(File zipFile, String password, String destPath) {
        try (ZipFile zip = new ZipFile(zipFile, password == null ? null : password.toCharArray());){
            zip.extractAll(destPath);
        }
    }
}

