/*
 * Decompiled with CFR 0.152.
 */
package org.rx.io;

import io.netty.buffer.ByteBuf;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.rx.io.Bytes;
import org.rx.io.IOStream;

public class GZIPStream
extends IOStream {
    private static final long serialVersionUID = 5949731591101041212L;
    private final IOStream baseStream;
    private final boolean leaveOpen;
    private transient GZIPInputStream reader;
    private transient GZIPOutputStream writer;

    @Override
    public String getName() {
        return this.baseStream.getName();
    }

    @Override
    public GZIPInputStream getReader() {
        if (this.reader == null) {
            this.reader = new GZIPInputStream(this.baseStream.getReader(), 256);
        }
        return this.reader;
    }

    @Override
    public GZIPOutputStream getWriter() {
        if (this.writer == null) {
            this.writer = new GZIPOutputStream(this.baseStream.getWriter(), 256);
        }
        return this.writer;
    }

    @Override
    public boolean canSeek() {
        return this.baseStream.canSeek();
    }

    @Override
    public long getPosition() {
        return this.baseStream.getPosition();
    }

    @Override
    public void setPosition(long position) {
        this.baseStream.setPosition(position);
    }

    @Override
    public long getLength() {
        return this.baseStream.getLength();
    }

    public GZIPStream(IOStream stream) {
        this(stream, false);
    }

    @Override
    protected void freeObjects() throws Throwable {
        if (this.reader != null) {
            this.reader.close();
        }
        if (this.writer != null) {
            this.writer.close();
        }
        if (!this.leaveOpen) {
            this.baseStream.close();
        }
    }

    public void finish() {
        if (this.writer != null) {
            this.writer.finish();
        }
    }

    @Override
    public byte[] toArray() {
        long pos = this.getPosition();
        this.setPosition(0L);
        ByteBuf buf = Bytes.heapBuffer();
        while (this.read(buf, 256) != -1) {
        }
        this.setPosition(pos);
        return Bytes.getBytes(buf);
    }

    public GZIPStream(IOStream baseStream, boolean leaveOpen) {
        this.baseStream = baseStream;
        this.leaveOpen = leaveOpen;
    }
}

