/*
 * Decompiled with CFR 0.152.
 */
package org.rx.io;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.rx.io.FileStream;
import org.rx.io.IOStream;
import org.rx.io.MemoryStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HybridStream
extends IOStream
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(HybridStream.class);
    private static final long serialVersionUID = 2137331266386948293L;
    private final int maxMemorySize;
    private final String tempFilePath;
    private MemoryStream memoryStream;
    private FileStream fileStream;
    private String name;

    private synchronized IOStream getStream() {
        if (this.fileStream != null) {
            return this.fileStream;
        }
        if (this.memoryStream.getLength() > (long)this.maxMemorySize) {
            log.info("Arrival MaxMemorySize[{}] threshold, switch FileStream", (Object)this.maxMemorySize);
            this.fileStream = this.tempFilePath == null ? new FileStream() : new FileStream(this.tempFilePath);
            this.fileStream.write((IOStream)this.memoryStream.rewind());
            this.memoryStream.close();
            this.memoryStream = null;
            return this.fileStream;
        }
        return this.memoryStream;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            return this.getStream().getName();
        }
        return this.name;
    }

    @Override
    public InputStream getReader() {
        return this.getStream().getReader();
    }

    @Override
    public OutputStream getWriter() {
        return this.getStream().getWriter();
    }

    @Override
    public boolean canSeek() {
        return this.getStream().canSeek();
    }

    @Override
    public long getPosition() {
        return this.getStream().getPosition();
    }

    @Override
    public void setPosition(long position) {
        this.getStream().setPosition(position);
    }

    @Override
    public long getLength() {
        return this.getStream().getLength();
    }

    public HybridStream() {
        this(0x1000000, false, null);
    }

    public HybridStream(int maxMemorySize, boolean directMemory, String tempFilePath) {
        this.maxMemorySize = maxMemorySize;
        this.tempFilePath = tempFilePath;
        this.memoryStream = new MemoryStream(256, directMemory);
    }

    @Override
    protected void freeObjects() {
        this.getStream().close();
    }

    public void setName(String name) {
        this.name = name;
    }
}

