/*
 * Decompiled with CFR 0.152.
 */
package org.rx.io;

import io.netty.buffer.ByteBuf;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.Flushable;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import lombok.NonNull;
import org.rx.annotation.ErrorCode;
import org.rx.core.Disposable;
import org.rx.core.Extends;
import org.rx.core.Strings;
import org.rx.exception.ApplicationException;
import org.rx.io.Bytes;
import org.rx.io.FileStream;
import org.rx.io.HybridStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IOStream
extends Disposable
implements Closeable,
Flushable,
Extends {
    private static final Logger log = LoggerFactory.getLogger(IOStream.class);
    private static final long serialVersionUID = 3204673656139586437L;
    public static final int NON_READ_FULLY = -1;

    public static IOStream wrap(String filePath) {
        return IOStream.wrap(new File(filePath));
    }

    public static IOStream wrap(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return new FileStream(file);
    }

    public static IOStream wrap(String name, byte[] data) {
        HybridStream stream = new HybridStream();
        stream.setName(Extends.ifNull(name, ""));
        stream.write(data);
        return stream.rewind();
    }

    public static IOStream wrap(String name, InputStream in) {
        HybridStream stream = new HybridStream();
        stream.setName(Extends.ifNull(name, ""));
        stream.write(in);
        return stream.rewind();
    }

    public static long copy(@NonNull InputStream in, long length, @NonNull OutputStream out) {
        long copyLen;
        int read;
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        if (out == null) {
            throw new NullPointerException("out is marked non-null but is null");
        }
        byte[] buffer = Bytes.arrayBuffer();
        boolean readFully = length != -1L;
        for (copyLen = 0L; !(readFully && copyLen >= length || (read = in.read(buffer, 0, buffer.length)) == -1); copyLen += (long)read) {
            out.write(buffer, 0, read);
        }
        out.flush();
        return copyLen;
    }

    public static long checksum(byte[] bytes) {
        CRC32 crc32 = new CRC32();
        crc32.update(bytes, 0, bytes.length);
        return crc32.getValue();
    }

    public static long checksum(InputStream stream) {
        return IOStream.checksum(stream, 1024);
    }

    public static long checksum(InputStream stream, int bufferSize) {
        CheckedInputStream checkedInputStream = new CheckedInputStream(stream, new CRC32());
        byte[] buffer = new byte[bufferSize];
        while (checkedInputStream.read(buffer, 0, buffer.length) >= 0) {
        }
        return checkedInputStream.getChecksum().getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readString(@NonNull InputStream in, Charset charset) {
        String string;
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        ByteBuf buf = Bytes.heapBuffer();
        try {
            int r;
            byte[] sb = Bytes.arrayBuffer();
            while ((r = in.read(sb)) != -1) {
                buf.writeBytes(sb, 0, r);
            }
            string = buf.toString(charset);
        }
        catch (Throwable throwable) {
            buf.release();
            throw throwable;
        }
        buf.release();
        return string;
    }

    public static void writeString(@NonNull OutputStream out, @NonNull String value, Charset charset) {
        if (out == null) {
            throw new NullPointerException("out is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        out.write(value.getBytes(charset));
    }

    static int safeRemaining(long remaining) {
        return remaining >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)remaining;
    }

    public static void release(ByteBuffer buffer) {
        if (buffer == null || !buffer.isDirect() || buffer.capacity() == 0) {
            return;
        }
        IOStream.invoke(IOStream.invoke(IOStream.viewed(buffer), "cleaner", new Class[0]), "clean", new Class[0]);
    }

    private static Object invoke(Object target, String methodName, Class<?> ... args) {
        return AccessController.doPrivileged(() -> {
            try {
                Method method;
                try {
                    method = target.getClass().getMethod(methodName, args);
                }
                catch (NoSuchMethodException e) {
                    method = target.getClass().getDeclaredMethod(methodName, args);
                }
                method.setAccessible(true);
                return method.invoke(target, new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        });
    }

    private static ByteBuffer viewed(ByteBuffer buffer) {
        ByteBuffer viewedBuffer;
        Method[] methods;
        String methodName = "viewedBuffer";
        for (Method method : methods = buffer.getClass().getMethods()) {
            if (!Strings.hashEquals(method.getName(), "attachment")) continue;
            methodName = "attachment";
            break;
        }
        if ((viewedBuffer = (ByteBuffer)IOStream.invoke(buffer, methodName, new Class[0])) == null) {
            return buffer;
        }
        return IOStream.viewed(viewedBuffer);
    }

    public abstract InputStream getReader();

    public abstract OutputStream getWriter();

    public abstract String getName();

    public boolean canSeek() {
        return false;
    }

    @ErrorCode
    public long getPosition() {
        throw new ApplicationException(Extends.values(new Object[0]));
    }

    @ErrorCode
    public void setPosition(long position) {
        throw new ApplicationException(Extends.values(new Object[0]));
    }

    @ErrorCode
    public long getLength() {
        throw new ApplicationException(Extends.values(this.getClass().getSimpleName()));
    }

    @Override
    protected void freeObjects() throws Throwable {
        this.flush();
        Extends.tryClose(this.getWriter());
        Extends.tryClose(this.getReader());
    }

    @Override
    public void close() {
        Extends.quietly(() -> super.close());
    }

    public long available() {
        if (this.isClosed()) {
            return 0L;
        }
        return this.getReader().available();
    }

    public int read() {
        this.checkNotClosed();
        return this.getReader().read();
    }

    public int read(@NonNull byte[] buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        this.checkNotClosed();
        return this.read(buffer, 0, buffer.length);
    }

    public int read(@NonNull byte[] buffer, int offset, int length) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        this.checkNotClosed();
        Extends.require(offset, offset >= 0);
        return this.getReader().read(buffer, offset, length);
    }

    public long read(IOStream stream) {
        return this.read(stream, -1L);
    }

    public long read(@NonNull IOStream stream, long length) {
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        return this.read(stream.getWriter(), length);
    }

    public long read(OutputStream out) {
        return this.read(out, -1L);
    }

    public long read(OutputStream out, long length) {
        this.checkNotClosed();
        return IOStream.copy(this.getReader(), length, out);
    }

    public int read(ByteBuf dst) {
        int read;
        int total = 0;
        while ((read = this.read(dst, 256)) > 0) {
            total += read;
        }
        return total;
    }

    public int read(ByteBuf dst, int length) {
        return dst.writeBytes(this.getReader(), length);
    }

    public short readShort() {
        int ch1 = this.read();
        int ch2 = this.read();
        if ((ch1 | ch2) < 0) {
            throw new EOFException();
        }
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    public int readInt() {
        int ch1 = this.read();
        int ch2 = this.read();
        int ch3 = this.read();
        int ch4 = this.read();
        if ((ch1 | ch2 | ch3 | ch4) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public void write(int b) {
        this.checkNotClosed();
        this.getWriter().write(b);
    }

    public void write(@NonNull byte[] buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        this.checkNotClosed();
        this.write(buffer, 0, buffer.length);
    }

    public void write(@NonNull byte[] buffer, int offset, int length) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        this.checkNotClosed();
        Extends.require(offset, offset >= 0);
        this.getWriter().write(buffer, offset, length);
    }

    public long write(IOStream stream) {
        return this.write(stream, -1L);
    }

    public long write(@NonNull IOStream stream, long length) {
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        return this.write(stream.getReader(), length);
    }

    public long write(InputStream in) {
        return this.write(in, -1L);
    }

    public long write(InputStream in, long length) {
        this.checkNotClosed();
        return IOStream.copy(in, length, this.getWriter());
    }

    public void write(ByteBuf src) {
        this.write(src, src.readableBytes());
    }

    public void write(ByteBuf src, int length) {
        src.readBytes(this.getWriter(), length);
    }

    public void writeShort(short n) {
        this.write(n >>> 8 & 0xFF);
        this.write(n >>> 0 & 0xFF);
    }

    public void writeInt(int n) {
        this.write(n >>> 24 & 0xFF);
        this.write(n >>> 16 & 0xFF);
        this.write(n >>> 8 & 0xFF);
        this.write(n >>> 0 & 0xFF);
    }

    public void writeString(String str) {
        this.writeString(str, StandardCharsets.UTF_8);
    }

    public void writeString(String str, Charset charset) {
        this.write(str.getBytes(charset));
    }

    @Override
    public void flush() {
        this.checkNotClosed();
        this.getWriter().flush();
    }

    public byte[] toArray() {
        this.checkNotClosed();
        long pos = this.getPosition();
        this.setPosition(0L);
        byte[] data = new byte[(int)this.getLength()];
        this.read(data);
        this.setPosition(pos);
        return data;
    }

    public final <T extends IOStream> T rewind() {
        this.setPosition(0L);
        return (T)this;
    }
}

