/*
 * Decompiled with CFR 0.152.
 */
package org.rx.io;

import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.lang.reflect.Type;
import lombok.NonNull;
import org.rx.core.Cache;
import org.rx.core.Extends;
import org.rx.core.JsonTypeInvoker;
import org.rx.core.Reflects;
import org.rx.core.Strings;
import org.rx.core.Sys;
import org.rx.exception.TraceHandler;
import org.rx.io.Compressible;
import org.rx.io.GZIPStream;
import org.rx.io.HybridStream;
import org.rx.io.IOStream;
import org.rx.io.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdkAndJsonSerializer
implements Serializer,
JsonTypeInvoker {
    private static final Logger log = LoggerFactory.getLogger(JdkAndJsonSerializer.class);
    static final String GZIP_HEX = String.format("%04X%04X", (short)-21266, (short)1);

    public <T> IOStream serialize(@NonNull T obj, @NonNull Type type) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        HybridStream stream = new HybridStream();
        this.serialize(obj, type, stream);
        return stream.rewind();
    }

    @Override
    public <T> void serialize(@NonNull T obj, IOStream stream) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        this.serialize(obj, obj.getClass(), stream);
    }

    public <T> void serialize(@NonNull T obj, @NonNull Type type, @NonNull IOStream stream) {
        Class<?> objKls;
        String skipNS;
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        Cache<String, JdkAndJsonSerializer> cache = Cache.getInstance(Cache.MEMORY_CACHE);
        JsonWrapper obj0 = !cache.containsKey(skipNS = Sys.fastCacheKey("skipNS", objKls = obj.getClass())) && Serializable.class.isAssignableFrom(objKls) ? obj : new JsonWrapper(type, obj);
        Compressible c0 = Extends.as(obj0, Compressible.class);
        if (c0 != null && c0.enableCompress()) {
            stream.writeShort((short)-21266);
            stream.writeShort((short)1);
            try (GZIPStream gzip = new GZIPStream(stream, true);){
                ObjectOutputStream out = new ObjectOutputStream(gzip.getWriter());
                out.writeObject(obj0);
            }
            return;
        }
        long pos = stream.canSeek() ? stream.getPosition() : -1L;
        ObjectOutputStream out = new ObjectOutputStream(stream.getWriter());
        try {
            out.writeObject(obj0);
        }
        catch (NotSerializableException e) {
            if (pos == -1L) {
                throw e;
            }
            TraceHandler.INSTANCE.log("NotSerializable {}", obj, e);
            cache.put(skipNS, this);
            stream.setPosition(pos);
            out = new ObjectOutputStream(stream.getWriter());
            out.writeObject(new JsonWrapper(type, obj));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T deserialize(@NonNull IOStream stream, boolean leveOpen) {
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        try {
            Object object;
            Object obj0;
            try {
                ObjectInputStream in = new ObjectInputStream(stream.getReader());
                obj0 = in.readObject();
            }
            catch (StreamCorruptedException e) {
                if (!Strings.endsWith((CharSequence)e.getMessage(), (CharSequence)GZIP_HEX)) {
                    throw e;
                }
                try (GZIPStream gzip = new GZIPStream(stream, true);){
                    ObjectInputStream in = new ObjectInputStream(gzip.getReader());
                    obj0 = in.readObject();
                }
            }
            JsonWrapper wrapper = Extends.as(obj0, JsonWrapper.class);
            if (wrapper != null) {
                object = Sys.fromJson(wrapper.json, Extends.ifNull((Type)JSON_TYPE.getIfExists(), () -> Reflects.fromTypeDescriptor(wrapper.typeDescriptor)));
                return (T)object;
            }
            object = obj0;
            return (T)object;
        }
        finally {
            if (!leveOpen) {
                stream.close();
            }
        }
    }

    static class JsonWrapper
    implements Compressible {
        private static final long serialVersionUID = 8279878386622487781L;
        final String typeDescriptor;
        final String json;

        @Override
        public boolean enableCompress() {
            return Strings.length((CharSequence)this.json) >= 1000;
        }

        public JsonWrapper(Type type, Object obj) {
            this.typeDescriptor = Reflects.getTypeDescriptor(type);
            this.json = Sys.toJsonString(obj);
        }
    }
}

