/*
 * Decompiled with CFR 0.152.
 */
package org.rx.io;

public class KeyValueStoreConfig {
    private final Class<?> keyType;
    private final Class<?> valueType;
    private String directoryPath = "./data/";
    private long logGrowSize = 0x40000000L;
    private int logReaderCount = 1;
    private long flushDelayMillis = 1000L;
    private int iteratorPrefetchCount = 2;
    private int indexBufferSize = 0x4000000;
    private int indexReaderCount = 1;
    private int apiPort = -1;
    private String apiPassword;
    private boolean apiSsl;
    private boolean apiReturnJson;

    public static <TK, TV> KeyValueStoreConfig newConfig(Class<TK> keyType, Class<TV> valueType) {
        KeyValueStoreConfig conf = new KeyValueStoreConfig(keyType, valueType);
        conf.setLogGrowSize(0x1000000L);
        conf.setIndexBufferSize(0x100000);
        return conf;
    }

    public KeyValueStoreConfig(Class<?> keyType, Class<?> valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
    }

    public Class<?> getKeyType() {
        return this.keyType;
    }

    public Class<?> getValueType() {
        return this.valueType;
    }

    public String getDirectoryPath() {
        return this.directoryPath;
    }

    public long getLogGrowSize() {
        return this.logGrowSize;
    }

    public int getLogReaderCount() {
        return this.logReaderCount;
    }

    public long getFlushDelayMillis() {
        return this.flushDelayMillis;
    }

    public int getIteratorPrefetchCount() {
        return this.iteratorPrefetchCount;
    }

    public int getIndexBufferSize() {
        return this.indexBufferSize;
    }

    public int getIndexReaderCount() {
        return this.indexReaderCount;
    }

    public int getApiPort() {
        return this.apiPort;
    }

    public String getApiPassword() {
        return this.apiPassword;
    }

    public boolean isApiSsl() {
        return this.apiSsl;
    }

    public boolean isApiReturnJson() {
        return this.apiReturnJson;
    }

    public void setDirectoryPath(String directoryPath) {
        this.directoryPath = directoryPath;
    }

    public void setLogGrowSize(long logGrowSize) {
        this.logGrowSize = logGrowSize;
    }

    public void setLogReaderCount(int logReaderCount) {
        this.logReaderCount = logReaderCount;
    }

    public void setFlushDelayMillis(long flushDelayMillis) {
        this.flushDelayMillis = flushDelayMillis;
    }

    public void setIteratorPrefetchCount(int iteratorPrefetchCount) {
        this.iteratorPrefetchCount = iteratorPrefetchCount;
    }

    public void setIndexBufferSize(int indexBufferSize) {
        this.indexBufferSize = indexBufferSize;
    }

    public void setIndexReaderCount(int indexReaderCount) {
        this.indexReaderCount = indexReaderCount;
    }

    public void setApiPort(int apiPort) {
        this.apiPort = apiPort;
    }

    public void setApiPassword(String apiPassword) {
        this.apiPassword = apiPassword;
    }

    public void setApiSsl(boolean apiSsl) {
        this.apiSsl = apiSsl;
    }

    public void setApiReturnJson(boolean apiReturnJson) {
        this.apiReturnJson = apiReturnJson;
    }

    public String toString() {
        return "KeyValueStoreConfig(keyType=" + this.getKeyType() + ", valueType=" + this.getValueType() + ", directoryPath=" + this.getDirectoryPath() + ", logGrowSize=" + this.getLogGrowSize() + ", logReaderCount=" + this.getLogReaderCount() + ", flushDelayMillis=" + this.getFlushDelayMillis() + ", iteratorPrefetchCount=" + this.getIteratorPrefetchCount() + ", indexBufferSize=" + this.getIndexBufferSize() + ", indexReaderCount=" + this.getIndexReaderCount() + ", apiPort=" + this.getApiPort() + ", apiPassword=" + this.getApiPassword() + ", apiSsl=" + this.isApiSsl() + ", apiReturnJson=" + this.isApiReturnJson() + ")";
    }
}

