/*
 * Decompiled with CFR 0.152.
 */
package org.rx.io;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.rx.core.Linq;
import org.rx.io.CrudFile;

class LocalCrudFile
implements CrudFile<File> {
    LocalCrudFile() {
    }

    @Override
    public String createDirectory(String path) {
        String dirPath = this.getDirectoryPath(path);
        Files.createDirectories(Paths.get(dirPath, new String[0]), new FileAttribute[0]);
        return dirPath;
    }

    @Override
    public Linq<File> listDirectories(String directoryPath, boolean recursive) {
        if (!recursive) {
            return Linq.from(Files.newDirectoryStream(Paths.get(directoryPath, new String[0]), x$0 -> Files.isDirectory(x$0, new LinkOption[0]))).select(Path::toFile);
        }
        return Linq.from(FileUtils.listFilesAndDirs((File)new File(directoryPath), (IOFileFilter)FileFilterUtils.falseFileFilter(), (IOFileFilter)FileFilterUtils.directoryFileFilter()));
    }

    @Override
    public void saveFile(String filePath, InputStream in) {
        Files.copy(in, Paths.get(filePath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
    }

    @Override
    public Linq<File> listFiles(String directoryPath, boolean recursive) {
        IOFileFilter df = recursive ? FileFilterUtils.directoryFileFilter() : FileFilterUtils.falseFileFilter();
        return Linq.from(FileUtils.listFiles((File)new File(directoryPath), (IOFileFilter)FileFilterUtils.fileFileFilter(), (IOFileFilter)df));
    }

    @Override
    public boolean exists(String path) {
        return Files.exists(Paths.get(path, new String[0]), new LinkOption[0]);
    }

    @Override
    public void delete(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return;
        }
        FileUtils.forceDelete((File)file);
    }
}

