/*
 * Decompiled with CFR 0.152.
 */
package org.rx.io;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import lombok.NonNull;
import org.rx.annotation.ErrorCode;
import org.rx.exception.InvalidException;
import org.rx.io.Bytes;
import org.rx.io.IOStream;
import org.rx.util.Snowflake;

public final class MemoryStream
extends IOStream
implements Serializable {
    private static final long serialVersionUID = 6209361024929311435L;
    private String name;
    private boolean directBuffer;
    private transient ByteBuf buffer;
    private transient InputStream reader;
    private transient OutputStream writer;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt((int)this.getPosition());
        out.writeInt((int)this.getLength());
        this.setPosition(0L);
        this.read(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int pos = in.readInt();
        int len = in.readInt();
        this.buffer = this.directBuffer ? Bytes.directBuffer(len) : Bytes.heapBuffer(len, true);
        this.setLength(len);
        this.write(in);
        this.setPosition(pos);
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = String.valueOf(Snowflake.DEFAULT.nextId());
        }
        return this.name;
    }

    @Override
    public InputStream getReader() {
        if (this.reader == null) {
            this.reader = new InputStream(){
                int mark;

                @Override
                public boolean markSupported() {
                    return true;
                }

                @Override
                public synchronized void mark(int readlimit) {
                    this.mark = MemoryStream.this.buffer.readerIndex();
                }

                @Override
                public synchronized void reset() throws IOException {
                    MemoryStream.this.buffer.readerIndex(this.mark);
                }

                @Override
                public int available() {
                    return MemoryStream.this.buffer.readableBytes();
                }

                @Override
                public int read(byte[] b, int off, int len) {
                    int readableBytes = MemoryStream.this.buffer.readableBytes();
                    if (readableBytes == 0) {
                        return -1;
                    }
                    int len0 = Math.min(readableBytes, len);
                    MemoryStream.this.buffer.readBytes(b, off, len0);
                    return len0;
                }

                @Override
                public int read() {
                    if (MemoryStream.this.buffer.readableBytes() == 0) {
                        return -1;
                    }
                    return MemoryStream.this.buffer.readByte() & 0xFF;
                }
            };
        }
        return this.reader;
    }

    @Override
    public OutputStream getWriter() {
        if (this.writer == null) {
            this.writer = new OutputStream(){

                @Override
                public void write(byte[] b, int off, int len) {
                    MemoryStream.this.buffer.writerIndex(MemoryStream.this.buffer.readerIndex());
                    MemoryStream.this.buffer.writeBytes(b, off, len);
                    MemoryStream.this.buffer.readerIndex(MemoryStream.this.buffer.writerIndex());
                }

                @Override
                public void write(int b) {
                    MemoryStream.this.buffer.writerIndex(MemoryStream.this.buffer.readerIndex());
                    MemoryStream.this.buffer.writeByte(b);
                    MemoryStream.this.buffer.readerIndex(MemoryStream.this.buffer.writerIndex());
                }
            };
        }
        return this.writer;
    }

    @Override
    public boolean canSeek() {
        return true;
    }

    @Override
    public long getPosition() {
        return this.buffer.readerIndex();
    }

    @Override
    public void setPosition(long position) {
        if (position > Integer.MAX_VALUE) {
            throw new InvalidException("Position > Integer.MAX_VALUE", new Object[0]);
        }
        this.buffer.readerIndex((int)position);
    }

    @Override
    public long getLength() {
        return this.buffer.writerIndex();
    }

    public void setLength(int length) {
        this.buffer.writerIndex(length);
    }

    @ErrorCode
    public ByteBuf getBuffer() {
        this.checkNotClosed();
        return this.buffer;
    }

    public MemoryStream() {
        this(256, false);
    }

    public MemoryStream(boolean directBuffer) {
        this(256, directBuffer);
    }

    public MemoryStream(int initialCapacity, boolean directBuffer) {
        this.directBuffer = directBuffer;
        this.buffer = this.directBuffer ? Bytes.directBuffer(initialCapacity) : Bytes.heapBuffer(initialCapacity, true);
    }

    public MemoryStream(byte[] buffer, int offset, int length) {
        this(Bytes.wrap(buffer, offset, length), false);
    }

    public MemoryStream(@NonNull ByteBuf buf, boolean forWrite) {
        if (buf == null) {
            throw new NullPointerException("buf is marked non-null but is null");
        }
        if (forWrite) {
            buf.readerIndex(buf.writerIndex());
        }
        this.buffer = buf;
    }

    @Override
    protected void freeObjects() {
        this.buffer.release();
    }

    @Override
    public int read(ByteBuf dst, int length) {
        this.buffer.readBytes(dst, length);
        return length;
    }

    public void read(ByteBuf dst, int dstIndex, int length) {
        this.buffer.readBytes(dst, dstIndex, length);
    }

    @Override
    public void write(ByteBuf src, int length) {
        this.buffer.writeBytes(src, length);
    }

    public void write(ByteBuf src, int srcIndex, int length) {
        this.buffer.writeBytes(src, srcIndex, length);
    }

    public void setName(String name) {
        this.name = name;
    }
}

