/*
 * Decompiled with CFR 0.152.
 */
package org.rx.io;

import org.rx.core.Arrays;
import org.rx.io.HybridStream;
import org.rx.io.IOStream;
import org.rx.io.JdkAndJsonSerializer;

public interface Serializer {
    public static final Serializer DEFAULT = new JdkAndJsonSerializer();

    default public <T> byte[] serializeToBytes(T[] obj) {
        if (Arrays.isEmpty((Object[])obj)) {
            return Arrays.EMPTY_BYTE_ARRAY;
        }
        try (HybridStream stream = new HybridStream();){
            for (T t : obj) {
                this.serialize(t, stream);
            }
            byte[] byArray = stream.toArray();
            return byArray;
        }
    }

    default public <T> byte[] serializeToBytes(T obj) {
        try (IOStream stream = this.serialize(obj);){
            byte[] byArray = stream.toArray();
            return byArray;
        }
    }

    default public <T> IOStream serialize(T obj) {
        return this.serialize(obj, 0x1000000, false);
    }

    default public <T> HybridStream serialize(T obj, int maxMemorySize, boolean directMemory) {
        HybridStream stream = new HybridStream(maxMemorySize, directMemory, null);
        this.serialize(obj, stream);
        return (HybridStream)stream.rewind();
    }

    public <T> void serialize(T var1, IOStream var2);

    default public <T> T deserializeFromBytes(byte[] data) {
        return this.deserialize(IOStream.wrap("", data));
    }

    default public <T> T deserialize(IOStream stream) {
        return this.deserialize(stream, false);
    }

    public <T> T deserialize(IOStream var1, boolean var2);
}

