/*
 * Decompiled with CFR 0.152.
 */
package org.rx.io;

import io.netty.buffer.ByteBuf;
import io.netty.util.concurrent.FastThreadLocal;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.io.UnsupportedEncodingException;
import java.nio.channels.FileChannel;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.NonNull;
import org.rx.core.Constants;
import org.rx.core.Delegate;
import org.rx.core.EventArgs;
import org.rx.core.EventPublisher;
import org.rx.core.Extends;
import org.rx.core.Tasks;
import org.rx.exception.InvalidException;
import org.rx.io.CompositeLock;
import org.rx.io.CompositeMmap;
import org.rx.io.FileMode;
import org.rx.io.FileStream;
import org.rx.io.IOStream;
import org.rx.io.Serializer;
import org.rx.util.function.BiAction;
import org.rx.util.function.BiFunc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WALFileStream
extends IOStream
implements EventPublisher<WALFileStream> {
    private static final Logger log = LoggerFactory.getLogger(WALFileStream.class);
    private static final long serialVersionUID = 1414441456982833443L;
    static final float GROW_FACTOR = 0.75f;
    static final int HEADER_SIZE = 256;
    static final FastThreadLocal<Long> readerPosition = new FastThreadLocal();
    public final transient Delegate<WALFileStream, EventArgs> onGrow = Delegate.create();
    final FileStream file;
    final CompositeLock lock;
    final long growSize;
    final int readerCount;
    private CompositeMmap writer;
    private final LinkedTransferQueue<IOStream> readers = new LinkedTransferQueue();
    private final Serializer serializer;
    final MetaHeader meta;
    long flushDelayMillis = 1000L;
    private transient InputStream _reader;
    private transient OutputStream _writer;

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new UnsupportedEncodingException();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        throw new UnsupportedEncodingException();
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public InputStream getReader() {
        if (this._reader == null) {
            this._reader = new InputStream(){

                @Override
                public int available() {
                    return IOStream.safeRemaining(WALFileStream.this.available());
                }

                @Override
                public int read(byte[] b, int off, int len) {
                    return WALFileStream.this.ensureRead(reader -> reader.read(b, off, len));
                }

                @Override
                public int read() {
                    return WALFileStream.this.ensureRead(IOStream::read);
                }
            };
        }
        return this._reader;
    }

    @Override
    public OutputStream getWriter() {
        if (this._writer == null) {
            this._writer = new OutputStream(){

                @Override
                public void write(byte[] b, int off, int len) {
                    WALFileStream.this.ensureWrite(writer -> writer.write(b, off, len));
                }

                @Override
                public void write(int b) {
                    WALFileStream.this.ensureWrite(writer -> writer.write(b));
                }

                @Override
                public void flush() {
                    WALFileStream.this.flush();
                }
            };
        }
        return this._writer;
    }

    public long getReaderPosition() {
        return this.getReaderPosition(false);
    }

    public long getReaderPosition(boolean remove) {
        Long val = (Long)readerPosition.getIfExists();
        if (val == null) {
            throw new InvalidException("Reader position not set", new Object[0]);
        }
        if (remove) {
            readerPosition.remove();
        }
        return val;
    }

    public void setReaderPosition(long position) {
        readerPosition.set((Object)position);
    }

    @Override
    public boolean canSeek() {
        return true;
    }

    @Override
    public long getPosition() {
        return this.meta.getLogPosition();
    }

    @Override
    public void setPosition(long position) {
        this.meta.setLogPosition(position);
    }

    @Override
    public long getLength() {
        return this.lock.readInvoke(this.file::getLength);
    }

    public WALFileStream(File file, long growSize, int readerCount, @NonNull Serializer serializer) {
        if (serializer == null) {
            throw new NullPointerException("serializer is marked non-null but is null");
        }
        this.growSize = growSize;
        this.readerCount = readerCount;
        this.serializer = serializer;
        this.file = new FileStream(file, FileMode.READ_WRITE, 0);
        this.lock = this.file.getLock();
        if (!this.ensureGrow()) {
            this.createReaderAndWriter();
        }
        this.meta = this.loadMeta();
        this.meta.owner = this;
    }

    @Override
    protected void freeObjects() {
        this.releaseReaderAndWriter();
        this.file.close();
    }

    public void clear() {
        this.lock.writeInvoke(() -> {
            this.meta.setLogPosition(256L);
            this.meta.setSize(0);
        });
    }

    public void saveMeta() {
        this.checkNotClosed();
        this.lock.writeInvoke(() -> {
            this.writer.setPosition(0L);
            this.serializer.serialize(this.meta, this.writer);
            this._flush();
        }, 0L, 256L);
    }

    private MetaHeader loadMeta() {
        MetaHeader metaHeader;
        IOStream reader = this.readers.take();
        try {
            metaHeader = this.lock.readInvoke(() -> {
                reader.setPosition(0L);
                try {
                    return (MetaHeader)this.serializer.deserialize(reader, true);
                }
                catch (Exception e) {
                    if (e instanceof StreamCorruptedException) {
                        log.info("loadMeta {}", (Object)e.getMessage());
                        return new MetaHeader();
                    }
                    throw e;
                }
            }, 0L, 256L);
            this.readers.offer(reader);
        }
        catch (Throwable throwable) {
            this.readers.offer(reader);
            throw throwable;
        }
        return metaHeader;
    }

    private void createReaderAndWriter() {
        this.lock.writeInvoke(() -> {
            long length = this.getLength();
            this.writer = this.file.mmap(FileChannel.MapMode.READ_WRITE, 0L, length);
            this.readers.clear();
            for (int i = 0; i < this.readerCount; ++i) {
                this.readers.add(this.file.mmap(FileChannel.MapMode.READ_ONLY, 0L, length));
            }
            if (this.readers.isEmpty()) {
                this.readers.add(this.writer);
            }
        });
    }

    private void releaseReaderAndWriter() {
        this.lock.writeInvoke(() -> {
            IOStream tmp;
            if (this.writer != null) {
                this.writer.close();
            }
            while ((tmp = this.readers.poll()) != null) {
                tmp.close();
            }
        });
    }

    private boolean ensureGrow() {
        return this.lock.writeInvoke(() -> {
            long length = this.file.getLength();
            if (length < this.growSize || this.meta != null && (float)this.meta.getLogPosition() / (float)length > 0.75f) {
                long resize = length + this.growSize;
                log.info("growSize {} {}->{}", new Object[]{this.getName(), length, resize});
                this._setLength(resize);
                this.raiseEvent(this.onGrow, EventArgs.EMPTY);
                return true;
            }
            return false;
        });
    }

    private void _setLength(long length) {
        this.releaseReaderAndWriter();
        this.file.setLength(length);
        this.createReaderAndWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long available() {
        long l;
        IOStream reader = this.readers.take();
        try {
            l = this.lock.readInvoke(reader::available);
            this.readers.offer(reader);
        }
        catch (Throwable throwable) {
            this.readers.offer(reader);
            throw throwable;
        }
        return l;
    }

    @Override
    public int read(ByteBuf dst, int length) {
        return this.ensureRead(reader -> reader.read(dst, length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int ensureRead(BiFunc<IOStream, Integer> action) {
        int n;
        IOStream reader = this.readers.take();
        try {
            long readerPosition = this.getReaderPosition();
            n = this.lock.readInvoke(() -> {
                reader.setPosition(readerPosition);
                int read = (Integer)action.invoke(reader);
                this.setReaderPosition(reader.getPosition());
                return read;
            }, readerPosition);
            this.readers.offer(reader);
        }
        catch (Throwable throwable) {
            this.readers.offer(reader);
            throw throwable;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T readObjectBackwards(BiFunc<IOStream, T> action) {
        IOStream reader = this.readers.take();
        try {
            long readerPosition = this.getReaderPosition();
            Object object = this.lock.readInvoke(() -> {
                reader.setPosition(readerPosition);
                Object obj = action.invoke(reader);
                this.setReaderPosition(reader.getPosition());
                return obj;
            }, 256L, readerPosition);
            return (T)object;
        }
        finally {
            this.readers.offer(reader);
        }
    }

    @Override
    public void write(ByteBuf src, int length) {
        this.ensureWrite(writer -> writer.write(src, length));
    }

    private void ensureWrite(BiAction<IOStream> action) {
        long logPosition = this.meta.getLogPosition();
        this.lock.writeInvoke(() -> {
            if (logPosition != this.meta.getLogPosition()) {
                throw new InvalidException("Concurrent error", new Object[0]);
            }
            this.ensureGrow();
            this.writer.setPosition(logPosition);
            action.invoke(this.writer);
            this._flush();
            this.meta.setLogPosition(this.writer.getPosition());
        }, logPosition);
    }

    private void _flush() {
        long delay = this.flushDelayMillis;
        if (delay <= 0L) {
            this.writer.flush();
            return;
        }
        Tasks.setTimeout(this::flush, delay, this.writer, Constants.TIMER_SINGLE_FLAG);
    }

    @Override
    public void flush() {
        this.lock.writeInvoke(() -> this.writer.flush());
    }

    public void setFlushDelayMillis(long flushDelayMillis) {
        this.flushDelayMillis = flushDelayMillis;
    }

    static class MetaHeader
    implements Serializable {
        private static final long serialVersionUID = 3894764623767567837L;
        private transient WALFileStream owner;
        private volatile long logPos = 256L;
        private AtomicInteger size = new AtomicInteger();
        Object extra;

        MetaHeader() {
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeLong(this.logPos);
            out.writeInt(this.size.get());
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            this.logPos = in.readLong();
            this.size = new AtomicInteger();
            this.size.set(in.readInt());
        }

        public long getLogPosition() {
            return this.logPos;
        }

        public void setLogPosition(long logPosition) {
            Extends.require(logPosition, logPosition >= 256L);
            this.logPos = logPosition;
            this.writeBack();
        }

        public int getSize() {
            return this.size.get();
        }

        public void setSize(int size) {
            this.size.set(size);
            this.writeBack();
        }

        public int incrementSize() {
            int s = this.size.incrementAndGet();
            this.writeBack();
            return s;
        }

        public int decrementSize() {
            int s = this.size.decrementAndGet();
            this.writeBack();
            return s;
        }

        private void writeBack() {
            if (this.owner == null) {
                return;
            }
            this.owner.saveMeta();
        }
    }
}

