/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.MapUtils;
import org.rx.bean.Tuple;
import org.rx.core.StringBuilder;
import org.rx.core.Strings;
import org.rx.net.Sockets;
import org.rx.net.http.HttpClient;

public class AuthenticEndpoint
implements Serializable {
    private static final long serialVersionUID = -8777400710799771803L;
    static final String AT_FLAG = "@";
    static final String AUTH_FLAG = ":";
    static final String PARAM_FLAG = "?";
    private final InetSocketAddress endpoint;
    private String username;
    private String password;
    private Map<String, String> parameters;

    public static AuthenticEndpoint valueOf(String authenticEndpoint) {
        int i = Strings.lastIndexOf((CharSequence)authenticEndpoint, (CharSequence)AT_FLAG);
        if (i == -1) {
            Tuple<InetSocketAddress, Map<String, String>> tuple = AuthenticEndpoint.decodeEndpoint(authenticEndpoint);
            return new AuthenticEndpoint((InetSocketAddress)tuple.left, null, null, (Map)tuple.right);
        }
        Tuple<InetSocketAddress, Map<String, String>> tuple = AuthenticEndpoint.decodeEndpoint(authenticEndpoint.substring(i + AT_FLAG.length()));
        String auth = authenticEndpoint.substring(0, i);
        if ((i = auth.indexOf(AUTH_FLAG)) == -1) {
            return new AuthenticEndpoint((InetSocketAddress)tuple.left, auth, null, (Map)tuple.right);
        }
        return new AuthenticEndpoint((InetSocketAddress)tuple.left, auth.substring(0, i), auth.substring(i + AUTH_FLAG.length()), (Map)tuple.right);
    }

    private static Tuple<InetSocketAddress, Map<String, String>> decodeEndpoint(String endpoint) {
        int i = endpoint.lastIndexOf(PARAM_FLAG);
        if (i == -1) {
            return Tuple.of(Sockets.parseEndpoint(endpoint), Collections.emptyMap());
        }
        return Tuple.of(Sockets.parseEndpoint(endpoint.substring(0, i)), HttpClient.decodeQueryString(endpoint.substring(i)));
    }

    public Map<String, String> getParameters() {
        if (this.parameters == null) {
            this.parameters = new ConcurrentHashMap<String, String>();
        }
        return this.parameters;
    }

    public AuthenticEndpoint(InetSocketAddress endpoint, String username, String password) {
        this(endpoint, username, password, null);
    }

    public AuthenticEndpoint(InetSocketAddress endpoint, String username, String password, Map<String, String> parameters) {
        this(endpoint);
        this.username = username;
        this.password = password;
        this.parameters = parameters;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        if (!Strings.isEmpty((CharSequence)this.username)) {
            s.append(this.username);
        }
        if (!Strings.isEmpty((CharSequence)this.password)) {
            s.append(":%s", this.password);
        }
        s.append("@%s", Sockets.toString(this.endpoint));
        if (!MapUtils.isEmpty(this.parameters)) {
            s.append(HttpClient.buildUrl(null, this.parameters));
        }
        return s.toString();
    }

    public AuthenticEndpoint(InetSocketAddress endpoint) {
        this.endpoint = endpoint;
    }

    public InetSocketAddress getEndpoint() {
        return this.endpoint;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

