/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net;

import io.netty.channel.AdaptiveRecvByteBufAllocator;
import io.netty.channel.WriteBufferWaterMark;

public enum MemoryMode {
    LOW(1024, 4096, 0x400000, 0x400000),
    MEDIUM(2048, MemoryMode.LOW.receiveBufInitial * 4, MemoryMode.LOW.receiveBufMaximum * 4, MemoryMode.LOW.sendBufHighWaterMark * 4),
    HIGH(4096, MemoryMode.MEDIUM.receiveBufInitial * 4, MemoryMode.MEDIUM.receiveBufMaximum * 4, MemoryMode.MEDIUM.sendBufHighWaterMark * 4);

    private final int backlog;
    private final int receiveBufInitial;
    private final int receiveBufMaximum;
    private final int sendBufHighWaterMark;
    private AdaptiveRecvByteBufAllocator tcpRecvByteBufAllocator;
    private AdaptiveRecvByteBufAllocator udpRecvByteBufAllocator;
    private WriteBufferWaterMark waterMark;

    public AdaptiveRecvByteBufAllocator adaptiveRecvByteBufAllocator(boolean isUdp) {
        if (isUdp) {
            if (this.udpRecvByteBufAllocator == null) {
                this.udpRecvByteBufAllocator = new AdaptiveRecvByteBufAllocator(this.receiveBufInitial, this.receiveBufInitial, this.receiveBufMaximum);
            }
            return this.udpRecvByteBufAllocator;
        }
        if (this.tcpRecvByteBufAllocator == null) {
            this.tcpRecvByteBufAllocator = new AdaptiveRecvByteBufAllocator(this.receiveBufInitial / 16, this.receiveBufInitial, this.receiveBufMaximum);
        }
        return this.tcpRecvByteBufAllocator;
    }

    public WriteBufferWaterMark writeBufferWaterMark() {
        if (this.waterMark == null) {
            this.waterMark = new WriteBufferWaterMark(this.sendBufHighWaterMark / 2, this.sendBufHighWaterMark);
        }
        return this.waterMark;
    }

    private MemoryMode(int backlog, int receiveBufInitial, int receiveBufMaximum, int sendBufHighWaterMark) {
        this.backlog = backlog;
        this.receiveBufInitial = receiveBufInitial;
        this.receiveBufMaximum = receiveBufMaximum;
        this.sendBufHighWaterMark = sendBufHighWaterMark;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public int getReceiveBufInitial() {
        return this.receiveBufInitial;
    }

    public int getReceiveBufMaximum() {
        return this.receiveBufMaximum;
    }

    public int getSendBufHighWaterMark() {
        return this.sendBufHighWaterMark;
    }

    public AdaptiveRecvByteBufAllocator getTcpRecvByteBufAllocator() {
        return this.tcpRecvByteBufAllocator;
    }

    public AdaptiveRecvByteBufAllocator getUdpRecvByteBufAllocator() {
        return this.udpRecvByteBufAllocator;
    }

    public WriteBufferWaterMark getWaterMark() {
        return this.waterMark;
    }
}

