/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.rx.net.Sockets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PingClient {
    private static final Logger log = LoggerFactory.getLogger(PingClient.class);
    private int times = 4;
    private int timeoutSeconds = 5;

    public Result ping(String endpoint) {
        return this.ping(Sockets.parseEndpoint(endpoint));
    }

    public Result ping(InetSocketAddress endpoint) {
        return this.ping(endpoint, this.times);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result ping(@NonNull InetSocketAddress endpoint, int times) {
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        long[] value = new long[times];
        for (int i = 0; i < value.length; ++i) {
            long startTime;
            Socket sock = new Socket();
            try {
                startTime = System.nanoTime();
                sock.connect(endpoint, this.timeoutSeconds * 1000);
            }
            catch (IOException e) {
                log.info("Ping error {}", (Object)e.toString());
                value[i] = -1L;
                continue;
            }
            finally {
                Sockets.closeOnFlushed(sock);
            }
            value[i] = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
        }
        return new Result(value);
    }

    public boolean isReachable(String host) {
        try {
            return this.isReachable(InetAddress.getByName(host));
        }
        catch (UnknownHostException e) {
            log.warn("isReachable {}", (Object)e.getMessage());
            return false;
        }
    }

    public boolean isReachable(InetAddress address) {
        return address.isReachable(this.timeoutSeconds * 1000);
    }

    public int getTimes() {
        return this.times;
    }

    public void setTimes(int times) {
        this.times = times;
    }

    public int getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public void setTimeoutSeconds(int timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public static class Result
    implements Serializable {
        private static final long serialVersionUID = 2269812764611557352L;
        private final long[] values;
        private final int lossCount;
        private final double avg;
        private final long min;
        private final long max;

        private Result(long[] values) {
            this.values = values;
            int nullVal = -1;
            this.lossCount = (int)Arrays.stream(values).filter(p -> p == (long)nullVal).count();
            this.avg = Arrays.stream(values).mapToDouble(p -> p == (long)nullVal ? 0.0 : (double)p).average().getAsDouble();
            this.min = Arrays.stream(values).filter(p -> p != (long)nullVal).min().orElse(nullVal);
            this.max = Arrays.stream(values).filter(p -> p != (long)nullVal).max().orElse(nullVal);
        }

        public long[] getValues() {
            return this.values;
        }

        public int getLossCount() {
            return this.lossCount;
        }

        public double getAvg() {
            return this.avg;
        }

        public long getMin() {
            return this.min;
        }

        public long getMax() {
            return this.max;
        }
    }
}

