/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;
import org.rx.bean.FlagsEnum;
import org.rx.core.Extends;
import org.rx.core.RxConfig;
import org.rx.net.MemoryMode;
import org.rx.net.TransportFlags;

public class SocketConfig
implements Extends {
    private static final long serialVersionUID = 5312790348211652335L;
    public static final int DELAY_TIMEOUT_MILLIS = 30000;
    private boolean useSharedTcpEventLoop = true;
    private boolean enableLog = RxConfig.INSTANCE.getNet().isEnableLog();
    private MemoryMode memoryMode = MemoryMode.LOW;
    private int connectTimeoutMillis = RxConfig.INSTANCE.getNet().getConnectTimeoutMillis();
    private FlagsEnum<TransportFlags> transportFlags = TransportFlags.NONE.flags();
    private byte[] aesKey;
    private final AtomicReference<Object> bypassList = new AtomicReference();

    public byte[] getAesKey() {
        if (this.aesKey == null) {
            return RxConfig.INSTANCE.getAesKey().getBytes(StandardCharsets.UTF_8);
        }
        return this.aesKey;
    }

    private Set<String> bypassList() {
        return new CopyOnWriteArraySet<String>(RxConfig.INSTANCE.getNet().getLanIps());
    }

    public boolean isUseSharedTcpEventLoop() {
        return this.useSharedTcpEventLoop;
    }

    public boolean isEnableLog() {
        return this.enableLog;
    }

    public MemoryMode getMemoryMode() {
        return this.memoryMode;
    }

    public int getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    public FlagsEnum<TransportFlags> getTransportFlags() {
        return this.transportFlags;
    }

    public void setUseSharedTcpEventLoop(boolean useSharedTcpEventLoop) {
        this.useSharedTcpEventLoop = useSharedTcpEventLoop;
    }

    public void setEnableLog(boolean enableLog) {
        this.enableLog = enableLog;
    }

    public void setMemoryMode(MemoryMode memoryMode) {
        this.memoryMode = memoryMode;
    }

    public void setConnectTimeoutMillis(int connectTimeoutMillis) {
        this.connectTimeoutMillis = connectTimeoutMillis;
    }

    public void setTransportFlags(FlagsEnum<TransportFlags> transportFlags) {
        this.transportFlags = transportFlags;
    }

    public void setAesKey(byte[] aesKey) {
        this.aesKey = aesKey;
    }

    public String toString() {
        return "SocketConfig(useSharedTcpEventLoop=" + this.isUseSharedTcpEventLoop() + ", enableLog=" + this.isEnableLog() + ", memoryMode=" + (Object)((Object)this.getMemoryMode()) + ", connectTimeoutMillis=" + this.getConnectTimeoutMillis() + ", transportFlags=" + this.getTransportFlags() + ", aesKey=" + Arrays.toString(this.getAesKey()) + ", bypassList=" + this.getBypassList() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getBypassList() {
        Object value = this.bypassList.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.bypassList;
            synchronized (atomicReference) {
                value = this.bypassList.get();
                if (value == null) {
                    Set<String> actualValue = this.bypassList();
                    value = actualValue == null ? this.bypassList : actualValue;
                    this.bypassList.set(value);
                }
            }
        }
        return (Set)(value == this.bypassList ? null : value);
    }
}

