/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.bootstrap.ServerBootstrapConfig;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.AdaptiveRecvByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.util.NetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.net.Authenticator;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.PasswordAuthentication;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.rx.bean.$;
import org.rx.bean.FlagsEnum;
import org.rx.core.Cache;
import org.rx.core.Extends;
import org.rx.core.Linq;
import org.rx.core.Reflects;
import org.rx.core.RxConfig;
import org.rx.core.ShellCommand;
import org.rx.core.Strings;
import org.rx.core.Sys;
import org.rx.exception.InvalidException;
import org.rx.io.Files;
import org.rx.net.AESCodec;
import org.rx.net.MemoryMode;
import org.rx.net.SocketConfig;
import org.rx.net.SocketInfo;
import org.rx.net.SocketProtocol;
import org.rx.net.TcpStatus;
import org.rx.net.TransportFlags;
import org.rx.net.WaterMarkHandler;
import org.rx.net.dns.DnsClient;
import org.rx.net.dns.DnsServer;
import org.rx.util.function.BiAction;
import org.rx.util.function.BiFunc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Sockets {
    private static final Logger log = LoggerFactory.getLogger(Sockets.class);
    public static final String ZIP_ENCODER = "ZIP_ENCODER";
    public static final String ZIP_DECODER = "ZIP_DECODER";
    public static final LengthFieldPrepender INT_LENGTH_PREPENDER = new LengthFieldPrepender(4);
    static final String M_0 = "lookupAllHostAddr";
    static final LoggingHandler DEFAULT_LOG = new LoggingHandler(LogLevel.INFO);
    static final Map<String, MultithreadEventLoopGroup> reactors = new ConcurrentHashMap<String, MultithreadEventLoopGroup>();
    static String loopbackAddr;
    static volatile DnsServer.ResolveInterceptor nsInterceptor;

    public static void injectNameService(List<InetSocketAddress> nameServerList) {
        if (CollectionUtils.isEmpty(nameServerList)) {
            throw new InvalidException("Empty server list", new Object[0]);
        }
        DnsClient client = new DnsClient(nameServerList);
        Sockets.injectNameService(client::resolveAll);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void injectNameService(@NonNull DnsServer.ResolveInterceptor interceptor) {
        if (interceptor == null) {
            throw new NullPointerException("interceptor is marked non-null but is null");
        }
        if (nsInterceptor == null) {
            Class<Sockets> clazz = Sockets.class;
            // MONITORENTER : org.rx.net.Sockets.class
            if (nsInterceptor == null) {
                nsInterceptor = interceptor;
                Class<InetAddress> type = InetAddress.class;
                try {
                    Field field = type.getDeclaredField("nameService");
                    Reflects.setAccess(field);
                    field.set(null, Sockets.nsProxy(field.get(null)));
                }
                catch (NoSuchFieldException e) {
                    Field field = type.getDeclaredField("nameServices");
                    Reflects.setAccess(field);
                    List nsList = (List)field.get(null);
                    nsList.set(0, Sockets.nsProxy(nsList.get(0)));
                }
            }
            // MONITOREXIT : clazz
        }
        nsInterceptor = interceptor;
        return;
    }

    private static Object nsProxy(Object ns) {
        Class<?> type = ns.getClass();
        InetAddress[] empty = new InetAddress[]{};
        return Proxy.newProxyInstance(type.getClassLoader(), type.getInterfaces(), (pObject, method, args) -> {
            if (Strings.hashEquals(method.getName(), M_0)) {
                String host = (String)args[0];
                try {
                    List<InetAddress> addresses = nsInterceptor.resolveHost(host);
                    if (!CollectionUtils.isEmpty(addresses)) {
                        return addresses.toArray(empty);
                    }
                }
                catch (Exception e) {
                    log.info("nsProxy {}", (Object)e.getMessage());
                }
            }
            return Reflects.invokeMethod(method, ns, args);
        });
    }

    public static EventLoopGroup reactor(String reactorName, boolean isTcp) {
        return (EventLoopGroup)reactors.computeIfAbsent(reactorName, k -> {
            int amount = RxConfig.INSTANCE.getNet().getReactorThreadAmount();
            return isTcp && Epoll.isAvailable() ? new EpollEventLoopGroup(amount) : new NioEventLoopGroup(amount);
        });
    }

    private static EventLoopGroup newEventLoop(int threadAmount) {
        return Epoll.isAvailable() ? new EpollEventLoopGroup(threadAmount) : new NioEventLoopGroup(threadAmount);
    }

    public static Class<? extends SocketChannel> channelClass() {
        return Epoll.isAvailable() ? EpollSocketChannel.class : NioSocketChannel.class;
    }

    public static ServerBootstrap serverBootstrap(BiAction<SocketChannel> initChannel) {
        return Sockets.serverBootstrap(null, initChannel);
    }

    public static ServerBootstrap serverBootstrap(SocketConfig config, final BiAction<SocketChannel> initChannel) {
        if (config == null) {
            config = new SocketConfig();
        }
        MemoryMode mode = config.getMemoryMode();
        int connectTimeoutMillis = config.getConnectTimeoutMillis();
        boolean highNetwork = connectTimeoutMillis <= 30000;
        int bossThreadAmount = 1;
        AdaptiveRecvByteBufAllocator recvByteBufAllocator = mode.adaptiveRecvByteBufAllocator(false);
        WriteBufferWaterMark writeBufferWaterMark = mode.writeBufferWaterMark();
        ServerBootstrap b = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(Sockets.newEventLoop(bossThreadAmount), config.isUseSharedTcpEventLoop() ? Sockets.reactor("_TCP", true) : Sockets.newEventLoop(0)).channel(Epoll.isAvailable() ? EpollServerSocketChannel.class : NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)mode.getBacklog())).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)connectTimeoutMillis)).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).option(ChannelOption.RCVBUF_ALLOCATOR, (Object)recvByteBufAllocator)).option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)writeBufferWaterMark)).childOption(ChannelOption.TCP_NODELAY, (Object)highNetwork).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childOption(ChannelOption.RCVBUF_ALLOCATOR, (Object)recvByteBufAllocator).childOption(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)writeBufferWaterMark).childHandler((ChannelHandler)WaterMarkHandler.DEFAULT);
        if (config.isEnableLog()) {
            b.handler((ChannelHandler)DEFAULT_LOG);
        }
        if (initChannel != null) {
            b.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel socketChannel) {
                    initChannel.invoke(socketChannel);
                }
            });
        }
        return b;
    }

    public static void closeBootstrap(ServerBootstrap bootstrap) {
        if (bootstrap == null) {
            return;
        }
        ServerBootstrapConfig config = bootstrap.config();
        EventLoopGroup group = config.group();
        if (group != null) {
            group.shutdownGracefully();
        }
        if ((group = config.childGroup()) != null && !reactors.containsValue(group)) {
            group.shutdownGracefully();
        }
    }

    public static Bootstrap bootstrap(SocketConfig config, BiAction<SocketChannel> initChannel) {
        return Sockets.bootstrap("_TCP", config, initChannel);
    }

    public static Bootstrap bootstrap(String reactorName, SocketConfig config, BiAction<SocketChannel> initChannel) {
        return Sockets.bootstrap(Sockets.reactor(reactorName, true), config, initChannel);
    }

    public static Bootstrap bootstrap(@NonNull EventLoopGroup eventLoopGroup, SocketConfig config, final BiAction<SocketChannel> initChannel) {
        if (eventLoopGroup == null) {
            throw new NullPointerException("eventLoopGroup is marked non-null but is null");
        }
        if (config == null) {
            config = new SocketConfig();
        }
        MemoryMode mode = config.getMemoryMode();
        int connectTimeoutMillis = config.getConnectTimeoutMillis();
        boolean highNetwork = connectTimeoutMillis <= 30000;
        AdaptiveRecvByteBufAllocator recvByteBufAllocator = mode.adaptiveRecvByteBufAllocator(false);
        WriteBufferWaterMark writeBufferWaterMark = mode.writeBufferWaterMark();
        Bootstrap b = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(eventLoopGroup)).channel(Sockets.channelClass())).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)connectTimeoutMillis)).option(ChannelOption.TCP_NODELAY, (Object)highNetwork)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).option(ChannelOption.RCVBUF_ALLOCATOR, (Object)recvByteBufAllocator)).option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)writeBufferWaterMark)).handler((ChannelHandler)WaterMarkHandler.DEFAULT);
        if (config.isEnableLog()) {
            b.handler((ChannelHandler)DEFAULT_LOG);
        }
        if (initChannel != null) {
            b.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel socketChannel) {
                    initChannel.invoke(socketChannel);
                }
            });
        }
        return b;
    }

    public static void addFrontendHandler(Channel channel, SocketConfig config) {
        FlagsEnum<TransportFlags> flags = config.getTransportFlags();
        if (flags == null) {
            return;
        }
        ChannelPipeline pipeline = channel.pipeline();
        if (flags.has(new TransportFlags[]{TransportFlags.FRONTEND_SSL})) {
            SelfSignedCertificate ssc = new SelfSignedCertificate();
            SslContext sslCtx = SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).build();
            pipeline.addLast(new ChannelHandler[]{sslCtx.newHandler(channel.alloc())});
        }
        if (flags.has(new TransportFlags[]{TransportFlags.FRONTEND_AES})) {
            if (config.getAesKey() == null) {
                throw new InvalidException("AES key is empty", new Object[0]);
            }
            pipeline.addLast(new AESCodec(config.getAesKey()).channelHandlers());
        }
        if (flags.has(new TransportFlags[]{TransportFlags.FRONTEND_COMPRESS})) {
            pipeline.addLast(ZIP_ENCODER, (ChannelHandler)ZlibCodecFactory.newZlibEncoder((ZlibWrapper)ZlibWrapper.GZIP)).addLast(ZIP_DECODER, (ChannelHandler)ZlibCodecFactory.newZlibDecoder((ZlibWrapper)ZlibWrapper.GZIP));
        }
    }

    public static void addBackendHandler(Channel channel, SocketConfig config, InetSocketAddress remoteEndpoint) {
        FlagsEnum<TransportFlags> flags = config.getTransportFlags();
        if (flags == null) {
            return;
        }
        ChannelPipeline pipeline = channel.pipeline();
        if (flags.has(new TransportFlags[]{TransportFlags.BACKEND_SSL})) {
            SslContext sslCtx = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
            pipeline.addLast(new ChannelHandler[]{sslCtx.newHandler(channel.alloc(), remoteEndpoint.getHostString(), remoteEndpoint.getPort())});
        }
        if (flags.has(new TransportFlags[]{TransportFlags.BACKEND_AES})) {
            if (config.getAesKey() == null) {
                throw new InvalidException("AES key is empty", new Object[0]);
            }
            pipeline.addLast(new AESCodec(config.getAesKey()).channelHandlers());
        }
        if (flags.has(new TransportFlags[]{TransportFlags.BACKEND_COMPRESS})) {
            pipeline.addLast(ZIP_ENCODER, (ChannelHandler)ZlibCodecFactory.newZlibEncoder((ZlibWrapper)ZlibWrapper.GZIP)).addLast(ZIP_DECODER, (ChannelHandler)ZlibCodecFactory.newZlibDecoder((ZlibWrapper)ZlibWrapper.GZIP));
        }
    }

    public static Bootstrap udpBootstrap(MemoryMode mode, BiAction<NioDatagramChannel> initChannel) {
        return Sockets.udpBootstrap("_UDP", mode, false, initChannel);
    }

    public static Bootstrap udpBootstrap(String reactorName, MemoryMode mode, BiAction<NioDatagramChannel> initChannel) {
        return Sockets.udpBootstrap(reactorName, mode, false, initChannel);
    }

    public static Bootstrap udpBootstrap(MemoryMode mode, boolean multicast, BiAction<NioDatagramChannel> initChannel) {
        return Sockets.udpBootstrap("_UDP", mode, multicast, initChannel);
    }

    static Bootstrap udpBootstrap(@NonNull String reactorName, MemoryMode mode, boolean multicast, final BiAction<NioDatagramChannel> initChannel) {
        if (reactorName == null) {
            throw new NullPointerException("reactorName is marked non-null but is null");
        }
        if (mode == null) {
            mode = MemoryMode.LOW;
        }
        NetworkInterface mif = null;
        if (multicast) {
            mif = NetworkInterface.getByInetAddress(Sockets.getLocalAddress(true));
        }
        Bootstrap b = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(Sockets.reactor(reactorName, false))).option(ChannelOption.RCVBUF_ALLOCATOR, (Object)mode.adaptiveRecvByteBufAllocator(true))).option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)mode.writeBufferWaterMark())).handler((ChannelHandler)WaterMarkHandler.DEFAULT);
        if (multicast) {
            ((Bootstrap)((Bootstrap)b.channelFactory(() -> new NioDatagramChannel(InternetProtocolFamily.IPv4))).option(ChannelOption.IP_MULTICAST_IF, (Object)mif)).option(ChannelOption.SO_REUSEADDR, (Object)true);
        } else {
            b.channel(NioDatagramChannel.class);
        }
        b.handler((ChannelHandler)DEFAULT_LOG);
        if (initChannel != null) {
            b.handler((ChannelHandler)new ChannelInitializer<NioDatagramChannel>(){

                protected void initChannel(NioDatagramChannel socketChannel) {
                    initChannel.invoke(socketChannel);
                }
            });
        }
        return b;
    }

    public static void writeAndFlush(Channel channel, @NonNull Queue<?> packs) {
        if (packs == null) {
            throw new NullPointerException("packs is marked non-null but is null");
        }
        EventLoop eventLoop = channel.eventLoop();
        if (eventLoop.inEventLoop()) {
            Object pack;
            while ((pack = packs.poll()) != null) {
                channel.write(pack).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
            }
            channel.flush();
            return;
        }
        eventLoop.execute(() -> {
            Object pack;
            while ((pack = packs.poll()) != null) {
                channel.write(pack).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
            }
            channel.flush();
        });
    }

    public static void closeOnFlushed(Channel channel) {
        if (channel == null || !channel.isActive()) {
            return;
        }
        channel.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public static ByteBuf getMessageBuf(Object msg) {
        if (msg instanceof DatagramPacket) {
            return (ByteBuf)((DatagramPacket)msg).content();
        }
        if (msg instanceof ByteBuf) {
            return (ByteBuf)msg;
        }
        throw new InvalidException("Unsupported msg type: {}", msg.getClass());
    }

    public static String protocolName(Channel channel) {
        return channel instanceof NioDatagramChannel ? "UDP" : "TCP";
    }

    public static ChannelFutureListener logBind(int port) {
        return f -> {
            String pn = Sockets.protocolName(f.channel());
            if (!f.isSuccess()) {
                log.error("{} Listen on port {} fail", new Object[]{pn, port, f.cause()});
                return;
            }
            log.info("{} Listened on {}", (Object)pn, (Object)f.channel().localAddress());
        };
    }

    public static ChannelFutureListener logConnect(InetSocketAddress endpoint) {
        return f -> {
            if (!f.isSuccess()) {
                log.error("TCP Connect {} fail", (Object)endpoint, (Object)f.cause());
                return;
            }
            log.info("TCP Connected {}", (Object)endpoint);
        };
    }

    public static void dumpPipeline(String name, Channel channel) {
        if (log.isTraceEnabled()) {
            ChannelPipeline pipeline = channel.pipeline();
            LinkedList<ChannelInboundHandler> inboundHandlers = new LinkedList<ChannelInboundHandler>();
            LinkedList<ChannelOutboundHandler> outboundHandlers = new LinkedList<ChannelOutboundHandler>();
            log.trace(name + " list:");
            for (Map.Entry entry : pipeline) {
                String prefix;
                ChannelHandler handler = (ChannelHandler)entry.getValue();
                if (handler instanceof ChannelInboundHandler) {
                    prefix = "in";
                    inboundHandlers.add((ChannelInboundHandler)handler);
                    continue;
                }
                if (handler instanceof ChannelOutboundHandler) {
                    prefix = "out";
                    outboundHandlers.add((ChannelOutboundHandler)handler);
                    continue;
                }
                prefix = "?";
                log.trace(String.format("%s %s: %s", prefix, entry.getKey(), entry.getValue()));
            }
            log.trace(name + " sorted:");
            for (ChannelInboundHandler channelInboundHandler : inboundHandlers) {
                log.trace(String.format("in %s", channelInboundHandler));
            }
            for (ChannelOutboundHandler channelOutboundHandler : outboundHandlers) {
                log.trace(String.format("out %s", channelOutboundHandler));
            }
        }
    }

    public static boolean isBypass(Iterable<String> bypassList, String host) {
        if (bypassList == null) {
            return false;
        }
        for (String regex : bypassList) {
            if (!Files.wildcardMatch((String)host, (String)regex)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLanIp(InetAddress ip) {
        String hostAddress = ip.getHostAddress();
        if (Strings.hashEquals(Sockets.getLoopbackHostAddress(), hostAddress)) {
            return true;
        }
        return Sockets.isBypass(RxConfig.INSTANCE.getNet().getLanIps(), hostAddress);
    }

    public static boolean isValidIp(String ip) {
        return NetUtil.isValidIpV4Address((String)ip) || NetUtil.isValidIpV6Address((String)ip);
    }

    public static String getLoopbackHostAddress() {
        if (loopbackAddr == null) {
            loopbackAddr = Sockets.getLoopbackAddress().getHostAddress();
        }
        return loopbackAddr;
    }

    public static InetAddress getLoopbackAddress() {
        return InetAddress.getLoopbackAddress();
    }

    public static InetAddress getAnyLocalAddress() {
        return InetAddress.getByName("0.0.0.0");
    }

    public static InetAddress getLocalAddress() {
        return Sockets.getLocalAddress(false);
    }

    public static InetAddress getLocalAddress(boolean supportsMulticast) {
        Inet4Address first = Linq.from(Sockets.getLocalAddresses(supportsMulticast)).orderByDescending(Inet4Address::isSiteLocalAddress).firstOrDefault();
        if (first != null) {
            return first;
        }
        return InetAddress.getLocalHost();
    }

    public static List<Inet4Address> getLocalAddresses(boolean supportsMulticast) {
        ArrayList<Inet4Address> ips = new ArrayList<Inet4Address>();
        Enumeration<NetworkInterface> networks = NetworkInterface.getNetworkInterfaces();
        while (networks.hasMoreElements()) {
            NetworkInterface network = networks.nextElement();
            if (network.isLoopback() || network.isVirtual() || !network.isUp() || supportsMulticast && !network.supportsMulticast()) continue;
            Enumeration<InetAddress> addresses = network.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress addr = addresses.nextElement();
                if (addr.isLoopbackAddress() || addr.isAnyLocalAddress() || !(addr instanceof Inet4Address)) continue;
                ips.add((Inet4Address)addr);
            }
        }
        if (supportsMulticast && ips.isEmpty()) {
            throw new InvalidException("Not multicast network found", new Object[0]);
        }
        return ips;
    }

    public static InetSocketAddress newLoopbackEndpoint(int port) {
        return new InetSocketAddress(Sockets.getLoopbackAddress(), port);
    }

    public static InetSocketAddress newAnyEndpoint(int port) {
        return new InetSocketAddress(Sockets.getAnyLocalAddress(), port);
    }

    public static InetSocketAddress newEndpoint(String endpoint, int port) {
        return Sockets.newEndpoint(Sockets.parseEndpoint(endpoint), port);
    }

    public static InetSocketAddress newEndpoint(@NonNull InetSocketAddress endpoint, int port) {
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        if (endpoint.getPort() == port) {
            return endpoint;
        }
        return new InetSocketAddress(endpoint.getAddress(), port);
    }

    public static List<InetSocketAddress> newAllEndpoints(@NonNull InetSocketAddress endpoint) {
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        return Linq.from(InetAddress.getAllByName(endpoint.getHostString())).select(p -> new InetSocketAddress((InetAddress)p, endpoint.getPort())).toList();
    }

    public static InetSocketAddress parseEndpoint(@NonNull String endpoint) {
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        int i = endpoint.lastIndexOf(":");
        if (i == -1) {
            throw new InvalidException("Invalid endpoint {}", endpoint);
        }
        String ip = endpoint.substring(0, i);
        int port = Integer.parseInt(endpoint.substring(i + 1));
        return new InetSocketAddress(ip, port);
    }

    public static String toString(InetSocketAddress endpoint) {
        if (endpoint == null) {
            return "NULL";
        }
        return String.format("%s:%s", endpoint.getHostString(), endpoint.getPort());
    }

    public static void closeOnFlushed(Socket socket) {
        if (socket.isClosed()) {
            return;
        }
        Extends.quietly(() -> {
            if (socket.isConnected()) {
                socket.setSoLinger(true, 2);
                if (!socket.isOutputShutdown()) {
                    socket.shutdownOutput();
                }
                if (!socket.isInputShutdown()) {
                    socket.shutdownInput();
                }
            }
            socket.close();
        });
    }

    public static Linq<SocketInfo> socketInfos(SocketProtocol protocol) {
        try (ShellCommand cmd = new ShellCommand("netstat -aon");){
            ArrayList list = new ArrayList();
            cmd.onPrintOut.combine((s, e) -> {
                String line = e.getLine();
                if (!line.contains(protocol.name())) {
                    return;
                }
                String[] arr = Linq.from(Strings.split(line, "  ")).select(String::trim).where(p -> !p.isEmpty()).toArray();
                try {
                    SocketProtocol p2 = SocketProtocol.valueOf(arr[0]);
                    SocketInfo sockInfo = p2 == SocketProtocol.TCP ? new SocketInfo(p2, Sockets.parseEndpoint(arr[1]), Sockets.parseEndpoint(arr[2]), TcpStatus.valueOf(arr[3]), Long.parseLong(arr[4])) : new SocketInfo(p2, Sockets.parseEndpoint(arr[1]), null, null, Long.parseLong(arr[3]));
                    list.add(sockInfo);
                }
                catch (Exception ex) {
                    log.error("Parse line {} fail", (Object)Sys.toJsonString(arr), (Object)ex);
                }
            });
            cmd.start().waitFor();
            Linq<SocketInfo> q = Linq.from(list, true);
            q.forEach(p -> p.setProcessName(Sockets.processName(p.pid)));
            Linq<SocketInfo> linq = q;
            return linq;
        }
    }

    static String processName(long pid) {
        return Cache.getOrSet(Sys.fastCacheKey("processName", pid), k -> {
            $ name = $.$();
            try (ShellCommand cmd = new ShellCommand(String.format("tasklist /fi \"pid eq %s\"", pid));){
                String t = String.format(" %s", pid);
                cmd.onPrintOut.combine((s, e) -> {
                    int i = e.getLine().indexOf(t);
                    if (i == -1) {
                        return;
                    }
                    name.v = e.getLine().substring(0, i).trim();
                });
                cmd.start().waitFor();
            }
            return (String)name.v;
        });
    }

    public static <T> T httpProxyInvoke(String proxyAddr, BiFunc<String, T> func) {
        Sockets.setHttpProxy(proxyAddr);
        try {
            T t = func.apply(proxyAddr);
            return t;
        }
        finally {
            Sockets.clearHttpProxy();
        }
    }

    public static void setHttpProxy(String proxyAddr) {
        Sockets.setHttpProxy(proxyAddr, null, null, null);
    }

    public static void setHttpProxy(String proxyAddr, List<String> nonProxyHosts, String userName, String password) {
        InetSocketAddress ipe = Sockets.parseEndpoint(proxyAddr);
        Properties prop = System.getProperties();
        prop.setProperty("http.proxyHost", ipe.getAddress().getHostAddress());
        prop.setProperty("http.proxyPort", String.valueOf(ipe.getPort()));
        prop.setProperty("https.proxyHost", ipe.getAddress().getHostAddress());
        prop.setProperty("https.proxyPort", String.valueOf(ipe.getPort()));
        if (!CollectionUtils.isEmpty(nonProxyHosts)) {
            prop.setProperty("http.nonProxyHosts", String.join((CharSequence)"|", nonProxyHosts));
        }
        if (userName != null && password != null) {
            Authenticator.setDefault(new UserAuthenticator(userName, password));
        }
    }

    public static void clearHttpProxy() {
        System.clearProperty("http.proxyHost");
        System.clearProperty("http.proxyPort");
        System.clearProperty("https.proxyHost");
        System.clearProperty("https.proxyPort");
        System.clearProperty("http.nonProxyHosts");
    }

    static class UserAuthenticator
    extends Authenticator {
        final String userName;
        final String password;

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.userName, this.password.toCharArray());
        }

        public UserAuthenticator(String userName, String password) {
            this.userName = userName;
            this.password = password;
        }
    }

    public static interface ReactorNames {
        public static final String SHARED_TCP = "_TCP";
        public static final String SHARED_UDP = "_UDP";
        public static final String RPC = "RPC";
        public static final String DNS = "DNS";
        public static final String SS = "SS";
    }
}

