/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net;

import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.GenericFutureListener;
import org.rx.net.Sockets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
final class WaterMarkHandler
extends ChannelDuplexHandler {
    private static final Logger log = LoggerFactory.getLogger(WaterMarkHandler.class);
    public static final WaterMarkHandler DEFAULT = new WaterMarkHandler();

    private WaterMarkHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        Channel channel = ctx.channel();
        if (!channel.isWritable()) {
            Channel channel2 = channel;
            synchronized (channel2) {
                if (!channel.isWritable()) {
                    channel.flush();
                    log.warn("{} {} not writable", (Object)Sockets.protocolName(channel), (Object)channel);
                    channel.wait();
                }
            }
        }
        super.write(ctx, msg, promise.addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE));
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.doNotify(ctx.channel());
        super.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.doNotify(ctx.channel());
        super.exceptionCaught(ctx, cause);
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        Channel channel = ctx.channel();
        if (channel.isWritable()) {
            this.doNotify(channel);
        }
        super.channelWritabilityChanged(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doNotify(Channel channel) {
        Channel channel2 = channel;
        synchronized (channel2) {
            log.info("{} {} writable", (Object)Sockets.protocolName(channel), (Object)channel);
            channel.notifyAll();
        }
    }
}

