/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.dns;

import io.netty.channel.AddressedEnvelope;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsResponse;
import io.netty.resolver.dns.DnsNameResolver;
import io.netty.resolver.dns.DnsNameResolverBuilder;
import io.netty.resolver.dns.DnsServerAddressStream;
import io.netty.resolver.dns.DnsServerAddressStreamProvider;
import io.netty.resolver.dns.DnsServerAddressStreamProviders;
import io.netty.resolver.dns.DnsServerAddresses;
import io.netty.util.concurrent.Future;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import lombok.NonNull;
import org.rx.core.Disposable;
import org.rx.core.Linq;
import org.rx.core.RxConfig;
import org.rx.core.Tasks;
import org.rx.exception.TraceHandler;
import org.rx.net.Sockets;

public class DnsClient
extends Disposable {
    static DnsClient inlandClient;
    static DnsClient outlandClient;
    final Set<InetSocketAddress> serverEndpoints;
    final DnsNameResolver nameResolver;

    public static DnsClient inlandClient() {
        if (inlandClient == null) {
            inlandClient = new DnsClient(Linq.from(RxConfig.INSTANCE.getNet().getDns().getInlandServers()).select(Sockets::parseEndpoint).toList());
        }
        return inlandClient;
    }

    public static DnsClient outlandClient() {
        if (outlandClient == null) {
            outlandClient = new DnsClient(Linq.from(RxConfig.INSTANCE.getNet().getDns().getOutlandServers()).select(Sockets::parseEndpoint).toList());
        }
        return outlandClient;
    }

    public DnsClient(@NonNull Collection<InetSocketAddress> nameServerList) {
        if (nameServerList == null) {
            throw new NullPointerException("nameServerList is marked non-null but is null");
        }
        this.serverEndpoints = new LinkedHashSet<InetSocketAddress>(nameServerList);
        this.nameResolver = new DnsNameResolverBuilder(Sockets.reactor("_UDP", false).next()).nameServerProvider((DnsServerAddressStreamProvider)(!this.serverEndpoints.isEmpty() ? new DnsServerAddressStreamProviderImpl(this.serverEndpoints) : DnsServerAddressStreamProviders.platformDefault())).channelType(NioDatagramChannel.class).socketChannelType(Sockets.channelClass()).build();
    }

    @Override
    protected void freeObjects() {
        this.nameResolver.close();
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(DnsQuestion question) {
        return this.nameResolver.query(question).addListener(f -> {
            if (f.isSuccess()) {
                return;
            }
            TraceHandler.INSTANCE.log("Dns query fail question={}", question, f.cause());
        });
    }

    public InetAddress resolve(String inetHost) {
        return (InetAddress)Tasks.await(this.nameResolver.resolve(inetHost));
    }

    public List<InetAddress> resolveAll(String inetHost) {
        return (List)Tasks.await(this.nameResolver.resolveAll(inetHost));
    }

    public void clearCache() {
        this.nameResolver.resolveCache().clear();
    }

    public Set<InetSocketAddress> getServerEndpoints() {
        return this.serverEndpoints;
    }

    static class DnsServerAddressStreamProviderImpl
    implements DnsServerAddressStreamProvider {
        final DnsServerAddresses nameServer;

        public DnsServerAddressStreamProviderImpl(Iterable<InetSocketAddress> nameServerList) {
            this.nameServer = DnsServerAddresses.sequential(nameServerList);
        }

        public DnsServerAddressStream nameServerAddressStream(String hostname) {
            return this.nameServer.stream();
        }
    }
}

