/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.dns;

import io.netty.buffer.Unpooled;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.dns.DefaultDnsQuery;
import io.netty.handler.codec.dns.DefaultDnsQuestion;
import io.netty.handler.codec.dns.DefaultDnsRawRecord;
import io.netty.handler.codec.dns.DefaultDnsResponse;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.handler.codec.dns.DnsResponse;
import io.netty.handler.codec.dns.DnsResponseCode;
import io.netty.handler.codec.dns.DnsSection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.rx.bean.RandomList;
import org.rx.core.CachePolicy;
import org.rx.core.Linq;
import org.rx.exception.TraceHandler;
import org.rx.net.Sockets;
import org.rx.net.dns.DnsClient;
import org.rx.net.dns.DnsMessageUtil;
import org.rx.net.dns.DnsServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class DnsHandler
extends SimpleChannelInboundHandler<DefaultDnsQuery> {
    private static final Logger log = LoggerFactory.getLogger(DnsHandler.class);
    final DnsServer server;
    final boolean isTcp;
    final DnsClient client;

    public DnsHandler(DnsServer server, boolean isTcp, Collection<InetSocketAddress> nameServerList) {
        this.server = server;
        this.isTcp = isTcp;
        this.client = new DnsClient(nameServerList);
    }

    public void channelRead0(ChannelHandlerContext ctx, DefaultDnsQuery query) {
        DefaultDnsQuestion question = (DefaultDnsQuestion)query.recordAt(DnsSection.QUESTION);
        String domain = question.name().substring(0, question.name().length() - 1);
        List<InetAddress> hIps = this.server.getHosts(domain);
        if (!hIps.isEmpty()) {
            ctx.writeAndFlush((Object)this.newResponse(query, question, this.server.hostsTtl, Linq.from(hIps).select(InetAddress::getAddress)));
            log.debug("query domain by hosts {} -> {}", (Object)domain, (Object)hIps.size());
            return;
        }
        if (domain.endsWith("x.f-li.cn")) {
            ctx.writeAndFlush((Object)this.newResponse(query, question, 32767L, Collections.singletonList(Sockets.getLoopbackAddress().getAddress())));
            return;
        }
        RandomList<DnsServer.ResolveInterceptor> interceptors = this.server.interceptors;
        if (interceptors != null) {
            String k = "resolveHost:" + domain;
            List<InetAddress> sIps = (List<InetAddress>)this.server.interceptorCache.get(k);
            if (sIps == null) {
                this.server.interceptorCache.put(k, sIps, CachePolicy.absolute(CollectionUtils.isEmpty(sIps = interceptors.next().resolveHost(domain)) ? 5 : this.server.ttl));
            }
            if (CollectionUtils.isEmpty((Collection)sIps)) {
                ctx.writeAndFlush((Object)DnsMessageUtil.newErrorResponse(query, DnsResponseCode.NXDOMAIN));
                log.info("query domain by shadow {} -> EMPTY", (Object)domain);
                return;
            }
            ctx.writeAndFlush((Object)this.newResponse(query, question, this.server.ttl, Linq.from(sIps).select(InetAddress::getAddress)));
            log.info("query domain by shadow {} -> {}", (Object)domain, (Object)sIps.size());
            return;
        }
        this.client.query((DnsQuestion)question).addListener(f -> {
            AddressedEnvelope envelope = (AddressedEnvelope)f.getNow();
            if (!f.isSuccess()) {
                TraceHandler.INSTANCE.log("query domain fail {} -> {}", domain, envelope, f.cause());
                if (envelope == null) {
                    return;
                }
            }
            try {
                ctx.writeAndFlush((Object)DnsMessageUtil.newResponse(query, (DnsResponse)envelope.content(), this.isTcp));
            }
            finally {
                envelope.release();
            }
        });
    }

    private DefaultDnsResponse newResponse(DefaultDnsQuery query, DefaultDnsQuestion question, long ttl, Iterable<byte[]> addresses) {
        DefaultDnsResponse response = DnsMessageUtil.newResponse(query, this.isTcp);
        response.addRecord(DnsSection.QUESTION, (DnsRecord)question);
        for (byte[] address : addresses) {
            DefaultDnsRawRecord queryAnswer = new DefaultDnsRawRecord(question.name(), DnsRecordType.A, ttl, Unpooled.wrappedBuffer((byte[])address));
            response.addRecord(DnsSection.ANSWER, (DnsRecord)queryAnswer);
        }
        return response;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        TraceHandler.INSTANCE.log(cause);
    }
}

