/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.dns;

import io.netty.handler.codec.dns.DatagramDnsQuery;
import io.netty.handler.codec.dns.DatagramDnsResponse;
import io.netty.handler.codec.dns.DefaultDnsQuery;
import io.netty.handler.codec.dns.DefaultDnsResponse;
import io.netty.handler.codec.dns.DnsMessage;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsResponse;
import io.netty.handler.codec.dns.DnsResponseCode;
import io.netty.handler.codec.dns.DnsSection;
import io.netty.util.ReferenceCounted;
import java.net.InetSocketAddress;

public class DnsMessageUtil {
    public static DefaultDnsResponse newResponse(DefaultDnsQuery query, DnsResponse response, boolean isTcp) {
        DefaultDnsResponse newResponse = DnsMessageUtil.newResponse(query, isTcp);
        newResponse.setOpCode(response.opCode()).setCode(response.code()).setAuthoritativeAnswer(response.isAuthoritativeAnswer()).setTruncated(response.isTruncated()).setRecursionAvailable(response.isRecursionAvailable()).setRecursionDesired(response.isRecursionDesired()).setZ(response.z());
        for (DnsSection section : DnsSection.values()) {
            DnsMessageUtil.setRecords(section, (DnsMessage)response, (DnsMessage)newResponse);
        }
        return newResponse;
    }

    public static DefaultDnsResponse newResponse(DefaultDnsQuery query, boolean isTcp) {
        Object response = !isTcp && query instanceof DatagramDnsQuery ? new DatagramDnsResponse(((DatagramDnsQuery)query).recipient(), ((DatagramDnsQuery)query).sender(), query.id()) : new DefaultDnsResponse(query.id());
        return response;
    }

    public static DefaultDnsResponse newErrorResponse(DefaultDnsQuery dnsQuery, DnsResponseCode rCode) {
        if (dnsQuery instanceof DatagramDnsQuery) {
            return DnsMessageUtil.newErrorResponse(((DatagramDnsQuery)dnsQuery).recipient(), ((DatagramDnsQuery)dnsQuery).sender(), (DnsMessage)dnsQuery, rCode);
        }
        return DnsMessageUtil.newErrorResponse(null, null, (DnsMessage)dnsQuery, rCode);
    }

    private static DefaultDnsResponse newErrorResponse(InetSocketAddress sender, InetSocketAddress recipient, DnsMessage dnsMessage, DnsResponseCode rCode) {
        Object response = sender != null && recipient != null ? new DatagramDnsResponse(sender, recipient, dnsMessage.id(), dnsMessage.opCode(), rCode) : new DefaultDnsResponse(dnsMessage.id(), dnsMessage.opCode(), rCode);
        DnsMessageUtil.setRecords(DnsSection.QUESTION, dnsMessage, (DnsMessage)response);
        DnsMessageUtil.setRecords(DnsSection.ANSWER, dnsMessage, (DnsMessage)response);
        DnsMessageUtil.setRecords(DnsSection.AUTHORITY, dnsMessage, (DnsMessage)response);
        DnsMessageUtil.setRecords(DnsSection.ADDITIONAL, dnsMessage, (DnsMessage)response);
        return response;
    }

    private static void setRecords(DnsSection section, DnsMessage oldDnsMessage, DnsMessage newDnsMessage) {
        int count = oldDnsMessage.count(section);
        for (int i = 0; i < count; ++i) {
            DnsRecord dnsRecord = oldDnsMessage.recordAt(section, i);
            if (dnsRecord instanceof ReferenceCounted) {
                ((ReferenceCounted)dnsRecord).retain();
            }
            newDnsMessage.addRecord(section, dnsRecord);
        }
    }
}

