/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.dns;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.dns.DatagramDnsQueryDecoder;
import io.netty.handler.codec.dns.DatagramDnsResponseEncoder;
import io.netty.handler.codec.dns.TcpDnsQueryDecoder;
import io.netty.handler.codec.dns.TcpDnsResponseEncoder;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.rx.bean.RandomList;
import org.rx.core.Cache;
import org.rx.core.CachePolicy;
import org.rx.core.Disposable;
import org.rx.core.Extends;
import org.rx.core.Linq;
import org.rx.core.NEventArgs;
import org.rx.core.Tasks;
import org.rx.core.cache.DiskCache;
import org.rx.io.Files;
import org.rx.net.MemoryMode;
import org.rx.net.Sockets;
import org.rx.net.dns.DnsHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnsServer
extends Disposable {
    private static final Logger log = LoggerFactory.getLogger(DnsServer.class);
    static final boolean ENABLE_AUTO_RENEW = false;
    static final String DOMAIN_PREFIX = "resolveHost:";
    final ServerBootstrap serverBootstrap;
    int ttl = 1800;
    int hostsTtl = 180;
    boolean enableHostsWeight;
    final Map<String, RandomList<InetAddress>> hosts = new ConcurrentHashMap<String, RandomList<InetAddress>>();
    RandomList<ResolveInterceptor> interceptors;
    Cache<String, List<InetAddress>> interceptorCache;

    public void setInterceptors(RandomList<ResolveInterceptor> interceptors) {
        DiskCache cache;
        this.interceptors = interceptors;
        if (CollectionUtils.isEmpty(this.interceptors)) {
            return;
        }
        this.interceptorCache = cache = (DiskCache)Cache.getInstance(Cache.DISK_CACHE);
    }

    public DnsServer(int port) {
        this(port, null);
    }

    public DnsServer(int port, Collection<InetSocketAddress> nameServerList) {
        if (nameServerList == null) {
            nameServerList = Collections.emptyList();
        }
        DnsHandler tcpHandler = new DnsHandler(this, true, nameServerList);
        this.serverBootstrap = Sockets.serverBootstrap(channel -> channel.pipeline().addLast(new ChannelHandler[]{new TcpDnsQueryDecoder(), new TcpDnsResponseEncoder(), tcpHandler}));
        this.serverBootstrap.bind(port).addListener((GenericFutureListener)Sockets.logBind(port));
        DnsHandler udpHandler = new DnsHandler(this, false, nameServerList);
        Sockets.udpBootstrap("DNS", MemoryMode.MEDIUM, channel -> channel.pipeline().addLast(new ChannelHandler[]{new DatagramDnsQueryDecoder(), new DatagramDnsResponseEncoder(), udpHandler})).bind(port).addListener((GenericFutureListener)Sockets.logBind(port));
    }

    @Override
    protected void freeObjects() {
        Sockets.closeBootstrap(this.serverBootstrap);
    }

    public List<InetAddress> getHosts(String host) {
        RandomList<InetAddress> ips = this.hosts.get(host);
        if (CollectionUtils.isEmpty(ips)) {
            return Collections.emptyList();
        }
        return this.enableHostsWeight ? Linq.from(ips.next(), ips.next()).distinct().toList() : new ArrayList<InetAddress>(ips);
    }

    public List<InetAddress> getAllHosts(String host) {
        RandomList<InetAddress> ips = this.hosts.get(host);
        if (ips == null) {
            return Collections.emptyList();
        }
        return new ArrayList<InetAddress>(ips);
    }

    public boolean addHosts(String host, String ... ips) {
        if (ips == null) {
            throw new NullPointerException("ips is marked non-null but is null");
        }
        return this.addHosts(host, 2, Linq.from(ips).select(InetAddress::getByName).toSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addHosts(@NonNull String host, int weight, @NonNull Collection<InetAddress> ips) {
        if (host == null) {
            throw new NullPointerException("host is marked non-null but is null");
        }
        if (ips == null) {
            throw new NullPointerException("ips is marked non-null but is null");
        }
        boolean changed = false;
        RandomList list = this.hosts.computeIfAbsent(host, k -> new RandomList());
        for (InetAddress ip : ips) {
            RandomList randomList = list;
            synchronized (randomList) {
                if (list.contains(ip)) {
                    list.setWeight(ip, weight);
                    continue;
                }
                list.add(ip, weight);
                changed = true;
            }
        }
        return changed;
    }

    public boolean removeHosts(@NonNull String host, Collection<InetAddress> ips) {
        if (host == null) {
            throw new NullPointerException("host is marked non-null but is null");
        }
        return this.hosts.computeIfAbsent(host, k -> new RandomList()).removeAll(ips);
    }

    public void addHostsFile(String filePath) {
        Files.readLines(filePath).forEach(line -> {
            if (line.startsWith("#")) {
                return;
            }
            String t = "\t";
            int s = line.indexOf(t);
            int e = line.lastIndexOf(t);
            if (s == -1 || e == -1) {
                log.warn("Invalid line {}", line);
                return;
            }
            this.addHosts(line.substring(e + t.length()), line.substring(0, s));
        });
    }

    public void setTtl(int ttl) {
        this.ttl = ttl;
    }

    public void setHostsTtl(int hostsTtl) {
        this.hostsTtl = hostsTtl;
    }

    public void setEnableHostsWeight(boolean enableHostsWeight) {
        this.enableHostsWeight = enableHostsWeight;
    }

    public Map<String, RandomList<InetAddress>> getHosts() {
        return this.hosts;
    }

    private /* synthetic */ void lambda$setInterceptors$1(RandomList interceptors, DiskCache cache, DiskCache s, NEventArgs e) throws Throwable {
        List lastAddresses;
        Map.Entry entry = (Map.Entry)e.getValue();
        String key = Extends.as(entry.getKey(), String.class);
        if (key == null || !key.startsWith(DOMAIN_PREFIX)) {
            entry.setValue(null);
            return;
        }
        String domain = key.substring(DOMAIN_PREFIX.length());
        List addresses = Tasks.awaitQuietly(() -> this.lambda$setInterceptors$0(interceptors, domain, cache, key, lastAddresses = (List)entry.getValue()), 4000L);
        if (!CollectionUtils.isEmpty((Collection)addresses)) {
            entry.setValue(addresses);
        }
        log.info("renew {} lastAddresses={} currentAddresses={}", new Object[]{key, lastAddresses, entry.getValue()});
    }

    private /* synthetic */ List lambda$setInterceptors$0(RandomList interceptors, String domain, DiskCache cache, String key, List lastAddresses) throws Throwable {
        List<InetAddress> list = ((ResolveInterceptor)interceptors.next()).resolveHost(domain);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        cache.put(key, list, CachePolicy.absolute(this.ttl));
        log.info("renewAsync {} lastAddresses={} addresses={}", new Object[]{key, lastAddresses, list});
        return list;
    }

    public static interface ResolveInterceptor {
        public List<InetAddress> resolveHost(String var1);
    }
}

