/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.http;

import io.netty.handler.codec.http.HttpHeaderNames;
import java.net.Proxy;
import java.net.SocketAddress;
import okhttp3.Authenticator;
import okhttp3.Credentials;

public class AuthenticProxy
extends Proxy {
    private final Authenticator authenticator = (route, response) -> {
        String name = HttpHeaderNames.PROXY_AUTHORIZATION.toString();
        if (this.directOnFail && response.request().header(name) != null) {
            return null;
        }
        String credential = Credentials.basic((String)username, (String)password);
        return response.request().newBuilder().header(name, credential).build();
    };
    private boolean directOnFail = true;

    public AuthenticProxy(Proxy.Type type, SocketAddress sa, String username, String password) {
        super(type, sa);
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public boolean isDirectOnFail() {
        return this.directOnFail;
    }

    public void setDirectOnFail(boolean directOnFail) {
        this.directOnFail = directOnFail;
    }
}

