/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.http;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import org.rx.core.Linq;
import org.rx.net.http.cookie.PersistentCookieStorage;
import org.rx.net.http.cookie.VolatileCookieStorage;

public final class CookieContainer
implements CookieJar {
    final VolatileCookieStorage volatileStorage;
    final PersistentCookieStorage persistentStorage;

    static boolean isCookieExpired(Cookie cookie) {
        return cookie.expiresAt() < System.currentTimeMillis();
    }

    public CookieContainer() {
        this(new VolatileCookieStorage(), new PersistentCookieStorage());
    }

    public CookieContainer(VolatileCookieStorage cache, PersistentCookieStorage persistentStorage) {
        this.volatileStorage = cache;
        this.persistentStorage = persistentStorage;
        this.volatileStorage.addAll(persistentStorage.loadAll());
    }

    public List<Cookie> loadForRequest(HttpUrl url) {
        ArrayList<Cookie> cookiesToRemove = new ArrayList<Cookie>();
        ArrayList<Cookie> validCookies = new ArrayList<Cookie>();
        Iterator<Cookie> it = this.volatileStorage.iterator();
        while (it.hasNext()) {
            Cookie currentCookie = it.next();
            if (CookieContainer.isCookieExpired(currentCookie)) {
                cookiesToRemove.add(currentCookie);
                it.remove();
                continue;
            }
            if (!currentCookie.matches(url)) continue;
            validCookies.add(currentCookie);
        }
        this.persistentStorage.removeAll(cookiesToRemove);
        return validCookies;
    }

    public void saveFromResponse(HttpUrl url, List<Cookie> cookies) {
        this.volatileStorage.addAll(cookies);
        this.persistentStorage.saveAll(Linq.from(cookies).where(Cookie::persistent).toList());
    }

    public synchronized void clearSession() {
        this.volatileStorage.clear();
        this.volatileStorage.addAll(this.persistentStorage.loadAll());
    }

    public synchronized void clear() {
        this.volatileStorage.clear();
        this.persistentStorage.clear();
    }
}

