/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.http;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.annotation.JSONField;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.Proxy;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import kotlin.Pair;
import lombok.NonNull;
import okhttp3.Authenticator;
import okhttp3.ConnectionPool;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSink;
import org.apache.commons.collections4.MapUtils;
import org.rx.bean.ProceedEventArgs;
import org.rx.bean.Tuple;
import org.rx.core.Linq;
import org.rx.core.Reflects;
import org.rx.core.RxConfig;
import org.rx.core.Strings;
import org.rx.core.Sys;
import org.rx.exception.InvalidException;
import org.rx.io.Files;
import org.rx.io.HybridStream;
import org.rx.io.IOStream;
import org.rx.net.http.AuthenticProxy;
import org.rx.net.http.CookieContainer;
import org.rx.util.function.BiFunc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient {
    private static final Logger log = LoggerFactory.getLogger(HttpClient.class);
    public static final CookieContainer COOKIES = new CookieContainer();
    static final ConnectionPool POOL = new ConnectionPool(RxConfig.INSTANCE.getNet().getPoolMaxSize(), (long)RxConfig.INSTANCE.getNet().getPoolKeepAliveSeconds(), TimeUnit.SECONDS);
    static final MediaType FORM_TYPE = MediaType.parse((String)"application/x-www-form-urlencoded; charset=utf-8");
    static final MediaType JSON_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    static final X509TrustManager TRUST_MANAGER = new X509TrustManager(){
        final X509Certificate[] empty = new X509Certificate[0];

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.empty;
        }
    };
    boolean enableLog = RxConfig.INSTANCE.getNet().isEnableLog();
    boolean cachingStream = true;
    long timeoutMillis;
    boolean enableCookie;
    AuthenticProxy proxy;
    OkHttpClient client;
    HttpHeaders reqHeaders;
    ResponseContent resContent;

    public static String encodeCookie(List<Cookie> cookies) {
        if (cookies == null) {
            return "";
        }
        return String.join((CharSequence)"; ", Linq.from(cookies).select(p -> p.name() + "=" + p.value()));
    }

    public static List<Cookie> decodeCookie(@NonNull HttpUrl httpUrl, @NonNull String raw) {
        if (httpUrl == null) {
            throw new NullPointerException("httpUrl is marked non-null but is null");
        }
        if (raw == null) {
            throw new NullPointerException("raw is marked non-null but is null");
        }
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        String domain = httpUrl.topPrivateDomain();
        for (String pair : raw.split(Pattern.quote("; "))) {
            int i = pair.indexOf("=");
            if (i == -1) continue;
            Cookie.Builder builder = new Cookie.Builder();
            if (domain != null) {
                builder = builder.domain(domain);
            }
            cookies.add(builder.path("/").name(pair.substring(0, i)).value(pair.substring(i + 1)).build());
        }
        return cookies;
    }

    public static String buildUrl(String url, Map<String, Object> queryString) {
        if (url == null) {
            url = "";
        }
        if (queryString == null) {
            return url;
        }
        Map<String, String> query = HttpClient.decodeQueryString(url);
        query.putAll(queryString);
        int i = url.indexOf("?");
        if (i != -1) {
            url = url.substring(0, i);
        }
        StringBuilder sb = new StringBuilder(url);
        for (Map.Entry<String, String> entry : query.entrySet()) {
            String val = entry.getValue();
            if (val == null) continue;
            sb.append(sb.length() == url.length() ? "?" : "&").append(HttpClient.encodeUrl(entry.getKey())).append("=").append(HttpClient.encodeUrl(val.toString()));
        }
        return sb.toString();
    }

    public static Map<String, String> decodeQueryString(String url) {
        String[] pairs;
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        if (Strings.isEmpty((CharSequence)url)) {
            return params;
        }
        int i = url.indexOf("?");
        if (i != -1) {
            url = url.substring(i + 1);
        }
        for (String pair : pairs = url.split("&")) {
            int idx = pair.indexOf("=");
            String key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), StandardCharsets.UTF_8.name()) : pair;
            String value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1), StandardCharsets.UTF_8.name()) : null;
            params.put(key, value);
        }
        return params;
    }

    public static Map<String, String> decodeHeader(String raw) {
        String[] pairs;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (raw == null) {
            return map;
        }
        for (String pair : pairs = raw.split(Pattern.quote("\n"))) {
            int idx = pair.indexOf(Pattern.quote(":"));
            String key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), StandardCharsets.UTF_8.name()) : pair;
            String value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1), StandardCharsets.UTF_8.name()).trim() : "";
            map.put(key, value);
        }
        return map;
    }

    public static String encodeUrl(String str) {
        if (Strings.isEmpty((CharSequence)str)) {
            return "";
        }
        return URLEncoder.encode(str, StandardCharsets.UTF_8.name()).replace("+", "%20");
    }

    public static String decodeUrl(String str) {
        if (Strings.isEmpty((CharSequence)str)) {
            return "";
        }
        return URLDecoder.decode(str, StandardCharsets.UTF_8.name()).replace("%20", "+");
    }

    public static void saveRawCookie(@NonNull String url, @NonNull String cookie) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (cookie == null) {
            throw new NullPointerException("cookie is marked non-null but is null");
        }
        HttpUrl httpUrl = HttpUrl.get((String)url);
        COOKIES.saveFromResponse(httpUrl, HttpClient.decodeCookie(httpUrl, cookie));
    }

    static OkHttpClient createClient(long timeoutMillis, boolean enableCookie, Proxy proxy) {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, new TrustManager[]{TRUST_MANAGER}, new SecureRandom());
        Authenticator authenticator = proxy instanceof AuthenticProxy ? ((AuthenticProxy)proxy).getAuthenticator() : Authenticator.NONE;
        OkHttpClient.Builder builder = new OkHttpClient.Builder().sslSocketFactory(sslContext.getSocketFactory(), TRUST_MANAGER).hostnameVerifier((s, sslSession) -> true).connectionPool(POOL).retryOnConnectionFailure(true).connectTimeout(timeoutMillis, TimeUnit.MILLISECONDS).readTimeout(timeoutMillis, TimeUnit.MILLISECONDS).writeTimeout(timeoutMillis, TimeUnit.MILLISECONDS).proxy(proxy).proxyAuthenticator(authenticator);
        if (enableCookie) {
            builder.cookieJar((CookieJar)COOKIES);
        }
        return builder.build();
    }

    public synchronized void setTimeoutMillis(long timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
        this.client = null;
    }

    public synchronized void setEnableCookie(boolean enableCookie) {
        this.enableCookie = enableCookie;
        this.client = null;
    }

    public synchronized void setProxy(AuthenticProxy proxy) {
        this.proxy = proxy;
        this.client = null;
    }

    public HttpClient withUserAgent() {
        this.requestHeaders().set((CharSequence)HttpHeaderNames.USER_AGENT, (Object)RxConfig.INSTANCE.getNet().getUserAgent());
        return this;
    }

    public HttpClient withRequestCookie(String rawCookie) {
        this.requestHeaders().set((CharSequence)HttpHeaderNames.COOKIE, (Object)rawCookie);
        return this;
    }

    public HttpHeaders requestHeaders() {
        return this.requestHeaders(false);
    }

    public HttpHeaders requestHeaders(boolean readOnly) {
        if (this.reqHeaders == null) {
            if (readOnly) {
                return EmptyHttpHeaders.INSTANCE;
            }
            this.reqHeaders = new DefaultHttpHeaders();
        }
        return this.reqHeaders;
    }

    public HttpClient() {
        this(RxConfig.INSTANCE.getNet().getConnectTimeoutMillis());
    }

    public HttpClient(long timeoutMillis) {
        this(timeoutMillis, false);
    }

    public HttpClient(long timeoutMillis, boolean enableCookie) {
        this.timeoutMillis = timeoutMillis;
        this.enableCookie = enableCookie;
    }

    OkHttpClient getClient() {
        if (this.client == null) {
            this.client = HttpClient.createClient(this.timeoutMillis, this.enableCookie, this.proxy);
        }
        return this.client;
    }

    Request.Builder createRequest(String url) {
        Request.Builder builder = new Request.Builder().url(url);
        for (Map.Entry entry : this.requestHeaders()) {
            builder.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        return builder;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized ResponseContent invoke(String url, HttpMethod method, RequestContent content) {
        ProceedEventArgs args = new ProceedEventArgs(this.getClass(), new Object[]{method.toString(), content.toString()}, false);
        try {
            Request.Builder request = this.createRequest(url);
            RequestBody requestBody = content.toBody();
            if (HttpMethod.GET.equals((Object)method)) {
                request.get();
            } else if (HttpMethod.POST.equals((Object)method)) {
                request.post(requestBody);
            } else if (HttpMethod.HEAD.equals((Object)method)) {
                request.head();
            } else if (HttpMethod.PUT.equals((Object)method)) {
                request.put(requestBody);
            } else if (HttpMethod.PATCH.equals((Object)method)) {
                request.patch(requestBody);
            } else {
                if (!HttpMethod.DELETE.equals((Object)method)) throw new UnsupportedOperationException();
                request.delete(requestBody);
            }
            if (this.resContent != null) {
                this.resContent.response.close();
            }
            ResponseContent responseContent = this.resContent = args.proceed(() -> {
                ResponseContent rc = new ResponseContent(this.getClient().newCall(request.build()).execute());
                rc.cachingStream = this.cachingStream;
                return rc;
            });
            return responseContent;
        }
        catch (Throwable e) {
            args.setError(e);
            throw e;
        }
        finally {
            if (this.enableLog) {
                Sys.logHttp(args, url);
            }
        }
    }

    public ResponseContent head(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        return this.invoke(url, HttpMethod.HEAD, RequestContent.NONE);
    }

    public ResponseContent get(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        return this.invoke(url, HttpMethod.GET, RequestContent.NONE);
    }

    public ResponseContent post(String url, Map<String, Object> forms) {
        return this.post(url, forms, Collections.emptyMap());
    }

    public ResponseContent post(@NonNull String url, Map<String, Object> forms, Map<String, IOStream> files) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        return this.invoke(url, HttpMethod.POST, new FormContent(forms, files, this.requestHeaders(true)));
    }

    public ResponseContent postJson(@NonNull String url, @NonNull Object json) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        return this.invoke(url, HttpMethod.POST, new JsonContent(json, this.requestHeaders(true)));
    }

    public ResponseContent put(String url, Map<String, Object> forms) {
        return this.put(url, forms, Collections.emptyMap());
    }

    public ResponseContent put(@NonNull String url, Map<String, Object> forms, Map<String, IOStream> files) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        return this.invoke(url, HttpMethod.PUT, new FormContent(forms, files, this.requestHeaders(true)));
    }

    public ResponseContent putJson(@NonNull String url, @NonNull Object json) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        return this.invoke(url, HttpMethod.PUT, new JsonContent(json, this.requestHeaders(true)));
    }

    public ResponseContent patch(String url, Map<String, Object> forms) {
        return this.patch(url, forms, Collections.emptyMap());
    }

    public ResponseContent patch(@NonNull String url, Map<String, Object> forms, Map<String, IOStream> files) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        return this.invoke(url, HttpMethod.PATCH, new FormContent(forms, files, this.requestHeaders(true)));
    }

    public ResponseContent patchJson(@NonNull String url, @NonNull Object json) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        return this.invoke(url, HttpMethod.PATCH, new JsonContent(json, this.requestHeaders(true)));
    }

    public ResponseContent delete(String url, Map<String, Object> forms) {
        return this.delete(url, forms, Collections.emptyMap());
    }

    public ResponseContent delete(@NonNull String url, Map<String, Object> forms, Map<String, IOStream> files) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        return this.invoke(url, HttpMethod.DELETE, new FormContent(forms, files, this.requestHeaders(true)));
    }

    public ResponseContent deleteJson(@NonNull String url, @NonNull Object json) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        return this.invoke(url, HttpMethod.DELETE, new JsonContent(json, this.requestHeaders(true)));
    }

    public synchronized Tuple<RequestContent, ResponseContent> forward(HttpServletRequest servletRequest, HttpServletResponse servletResponse, String forwardUrl) {
        RequestContent reqContent;
        byte[] inBytes;
        final HttpHeaders reqHeaders = this.requestHeaders();
        for (String n : Collections.list(servletRequest.getHeaderNames())) {
            if (Strings.equalsIgnoreCase((CharSequence)n, (CharSequence)HttpHeaderNames.HOST)) continue;
            reqHeaders.set(n, (Object)servletRequest.getHeader(n));
        }
        String query = servletRequest.getQueryString();
        if (!Strings.isEmpty((CharSequence)query)) {
            forwardUrl = forwardUrl + (forwardUrl.lastIndexOf("?") == -1 ? "?" : "&") + query;
        }
        log.info("Forward request: {}\nheaders: {}", (Object)forwardUrl, (Object)Sys.toJsonString(reqHeaders));
        final String requestContentType = servletRequest.getContentType();
        ServletInputStream inStream = servletRequest.getInputStream();
        if (inStream != null && (inBytes = IOStream.wrap("", (InputStream)inStream).toArray()).length > 0) {
            reqContent = new RequestContent(){

                @Override
                public HttpHeaders getHeaders() {
                    return reqHeaders;
                }

                @Override
                public RequestBody toBody() {
                    return RequestBody.create((MediaType)(requestContentType != null ? MediaType.parse((String)requestContentType) : null), (byte[])inBytes);
                }
            };
        } else if (requestContentType != null) {
            if (Strings.startsWithIgnoreCase((CharSequence)requestContentType, (CharSequence)HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED)) {
                Map<String, Object> forms = Linq.from(Collections.list(servletRequest.getParameterNames())).toMap(p -> p, arg_0 -> ((HttpServletRequest)servletRequest).getParameter(arg_0));
                reqContent = new FormContent(forms, Collections.emptyMap(), reqHeaders);
            } else if (Strings.startsWithIgnoreCase((CharSequence)requestContentType, (CharSequence)"multipart/")) {
                Map<String, IOStream> files = Linq.from(servletRequest.getParts()).toMap(Part::getName, p -> IOStream.wrap(p.getSubmittedFileName(), p.getInputStream()));
                Set<String> fileNames = files.keySet();
                Map<String, Object> forms = Linq.from(Collections.list(servletRequest.getParameterNames())).where(p -> !fileNames.contains(p)).toMap(p -> p, arg_0 -> ((HttpServletRequest)servletRequest).getParameter(arg_0));
                reqContent = new FormContent(forms, files, reqHeaders);
            } else {
                log.warn("Not support {} {}", (Object)servletRequest, (Object)requestContentType);
                reqContent = new EmptyContent(MediaType.parse((String)requestContentType));
            }
        } else {
            reqContent = RequestContent.NONE;
        }
        ResponseContent resContent = new ResponseContent(this.getClient().newCall(this.createRequest(forwardUrl).method(servletRequest.getMethod(), reqContent.toBody()).build()).execute());
        resContent.cachingStream = this.cachingStream;
        servletResponse.setStatus(resContent.response.code());
        for (Pair header : resContent.getHeaders()) {
            servletResponse.setHeader((String)header.getFirst(), (String)header.getSecond());
        }
        ResponseBody responseBody = resContent.response.body();
        boolean hasResBody = responseBody != null;
        log.info("Forward response: {}\nheaders: {} hasBody: {}", new Object[]{resContent.getResponseUrl(), Sys.toJsonString(resContent.getHeaders()), hasResBody});
        if (hasResBody) {
            MediaType responseContentType = responseBody.contentType();
            if (responseContentType != null) {
                servletResponse.setContentType(responseContentType.toString());
            }
            servletResponse.setContentLength((int)responseBody.contentLength());
            ServletOutputStream out = servletResponse.getOutputStream();
            resContent.handle(in -> {
                IOStream.copy(in, -1L, (OutputStream)out);
                return null;
            });
        }
        return Tuple.of(reqContent, resContent);
    }

    public void setEnableLog(boolean enableLog) {
        this.enableLog = enableLog;
    }

    public void setCachingStream(boolean cachingStream) {
        this.cachingStream = cachingStream;
    }

    public static class ResponseContent {
        @JSONField(serialize=false)
        final Response response;
        boolean cachingStream = true;
        HybridStream stream;
        File file;
        String str;

        public String getResponseUrl() {
            return this.response.request().url().toString();
        }

        public String getResponseText() {
            return this.toString();
        }

        @JSONField(serialize=false)
        public Headers getHeaders() {
            return this.response.headers();
        }

        @JSONField(serialize=false)
        public Charset getCharset() {
            return (Charset)Reflects.invokeMethod(this.response.body(), "charset", new Object[0]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public synchronized <T> T handle(BiFunc<InputStream, T> fn) {
            if (!this.cachingStream) {
                ResponseBody body = this.response.body();
                if (body == null) {
                    throw new InvalidException("Empty response from url {}", this.getResponseUrl());
                }
                try {
                    InputStream inputStream = fn.invoke(body.byteStream());
                    return (T)inputStream;
                }
                finally {
                    body.close();
                }
            }
            if (this.stream != null) return (T)fn.invoke(((IOStream)this.stream.rewind()).getReader());
            ResponseBody body = this.response.body();
            if (body == null) {
                throw new InvalidException("Empty response from url {}", this.getResponseUrl());
            }
            try {
                this.stream = new HybridStream();
                this.stream.write(body.byteStream());
                return (T)fn.invoke(((IOStream)this.stream.rewind()).getReader());
            }
            finally {
                body.close();
            }
        }

        public synchronized HybridStream toStream() {
            this.cachingStream = true;
            return this.handle(in -> this.stream);
        }

        public File toFile(String filePath) {
            if (this.file == null) {
                this.file = this.handle(in -> {
                    Files.saveFile(filePath, in);
                    return new File(filePath);
                });
            }
            return this.file;
        }

        public <T extends Serializable> T toJson() {
            return (T)((Serializable)JSON.parse((String)this.toString()));
        }

        public String toString() {
            if (this.str == null) {
                this.str = this.handle(in -> IOStream.readString(in, this.getCharset()));
            }
            return this.str;
        }

        protected ResponseContent(Response response) {
            this.response = response;
        }

        public Response getResponse() {
            return this.response;
        }
    }

    static class EmptyContent
    implements RequestContent {
        final MediaType contentType;

        @Override
        public HttpHeaders getHeaders() {
            return EmptyHttpHeaders.INSTANCE;
        }

        @Override
        public RequestBody toBody() {
            return RequestBody.create((MediaType)this.contentType, (String)this.toString());
        }

        public String toString() {
            return "";
        }

        public EmptyContent(MediaType contentType) {
            this.contentType = contentType;
        }
    }

    static class FormContent
    implements RequestContent {
        final Map<String, Object> forms;
        final Map<String, IOStream> files;
        final HttpHeaders headers;

        @Override
        public RequestBody toBody() {
            if (MapUtils.isEmpty(this.files)) {
                String formString = HttpClient.buildUrl(null, this.forms);
                if (!Strings.isEmpty((CharSequence)formString)) {
                    formString = formString.substring(1);
                }
                return RequestBody.create((MediaType)FORM_TYPE, (String)formString);
            }
            MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
            if (!MapUtils.isEmpty(this.forms)) {
                for (Map.Entry<String, Object> entry : this.forms.entrySet()) {
                    if (entry.getValue() == null) continue;
                    builder.addFormDataPart(entry.getKey(), entry.getValue().toString());
                }
            }
            if (!MapUtils.isEmpty(this.files)) {
                for (Map.Entry<String, Object> entry : this.files.entrySet()) {
                    final IOStream stream = (IOStream)entry.getValue();
                    if (stream == null) continue;
                    builder.addFormDataPart(entry.getKey(), stream.getName(), new RequestBody(){

                        public MediaType contentType() {
                            return MediaType.parse((String)Files.getMediaTypeFromName(stream.getName()));
                        }

                        public void writeTo(BufferedSink bufferedSink) {
                            stream.read(bufferedSink.outputStream());
                        }
                    });
                }
            }
            return builder.build();
        }

        public String toString() {
            return "FormContent{forms=" + this.forms + ", files=" + this.files + '}';
        }

        public FormContent(Map<String, Object> forms, Map<String, IOStream> files, HttpHeaders headers) {
            this.forms = forms;
            this.files = files;
            this.headers = headers;
        }

        @Override
        public HttpHeaders getHeaders() {
            return this.headers;
        }
    }

    static class JsonContent
    implements RequestContent {
        final Object json;
        final HttpHeaders headers;
        String str;

        @Override
        public RequestBody toBody() {
            return RequestBody.create((MediaType)JSON_TYPE, (String)this.toString());
        }

        public String toString() {
            if (this.str == null) {
                this.str = Sys.toJsonString(this.json);
            }
            return this.str;
        }

        public JsonContent(Object json, HttpHeaders headers) {
            this.json = json;
            this.headers = headers;
        }

        @Override
        public HttpHeaders getHeaders() {
            return this.headers;
        }
    }

    public static interface RequestContent {
        public static final RequestContent NONE = new EmptyContent(null);

        public HttpHeaders getHeaders();

        public RequestBody toBody();
    }
}

