/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.http;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerExpectContinueHandler;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.rx.bean.MultiValueMap;
import org.rx.core.Arrays;
import org.rx.core.Disposable;
import org.rx.core.Extends;
import org.rx.core.Strings;
import org.rx.io.Bytes;
import org.rx.net.Sockets;
import org.rx.net.http.ServerRequest;
import org.rx.net.http.ServerResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServer
extends Disposable {
    private static final Logger log = LoggerFactory.getLogger(HttpServer.class);
    static final HttpDataFactory factory = new DefaultHttpDataFactory(16384L);
    final ServerBootstrap serverBootstrap;
    final Map<String, Handler> mapping = new ConcurrentHashMap<String, Handler>();

    public static String normalize(String uri) {
        uri = uri.trim();
        while (uri.endsWith("/")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        while (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        if (!uri.startsWith("/")) {
            uri = "/" + uri;
        }
        return uri;
    }

    public HttpServer(int port, boolean ssl) {
        SslContext sslCtx;
        if (ssl) {
            SelfSignedCertificate ssc = new SelfSignedCertificate();
            sslCtx = SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).build();
        } else {
            sslCtx = null;
        }
        this.serverBootstrap = Sockets.serverBootstrap(ch -> {
            ChannelPipeline p = ch.pipeline();
            if (sslCtx != null) {
                p.addLast(new ChannelHandler[]{sslCtx.newHandler(ch.alloc())});
            }
            p.addLast(new ChannelHandler[]{new HttpServerCodec(), new HttpServerExpectContinueHandler(), new HttpContentCompressor(), new ChunkedWriteHandler(), new ServerHandler()});
        });
        this.serverBootstrap.bind(port).addListener((GenericFutureListener)Sockets.logBind(port));
    }

    @Override
    protected void freeObjects() {
        Sockets.closeBootstrap(this.serverBootstrap);
    }

    public HttpServer requestMapping(String path, Handler handler) {
        this.mapping.put(HttpServer.normalize(path), handler);
        return this;
    }

    public Map<String, Handler> getMapping() {
        return this.mapping;
    }

    public static interface Handler {
        default public HttpMethod[] method() {
            return null;
        }

        public void handle(ServerRequest var1, ServerResponse var2) throws Throwable;
    }

    class ServerHandler
    extends SimpleChannelInboundHandler<HttpObject> {
        HttpRequest request;
        HttpPostRequestDecoder decoder;
        Handler handler;
        ServerRequest req;

        ServerHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
            if (msg instanceof HttpRequest) {
                this.request = (HttpRequest)msg;
                if (!this.request.decoderResult().isSuccess()) {
                    this.sendError(ctx, HttpResponseStatus.BAD_REQUEST);
                    return;
                }
                QueryStringDecoder queryStringDecoder = new QueryStringDecoder(this.request.uri());
                this.handler = HttpServer.this.mapping.get(queryStringDecoder.path());
                if (this.handler == null) {
                    this.sendError(ctx, HttpResponseStatus.NOT_FOUND);
                    return;
                }
                Object[] method = this.handler.method();
                if (method != null && !Arrays.contains((Object[])method, (Object)this.request.method())) {
                    this.sendError(ctx, HttpResponseStatus.METHOD_NOT_ALLOWED);
                    return;
                }
                this.req = new ServerRequest((InetSocketAddress)ctx.channel().remoteAddress(), this.request.uri(), this.request.method());
                this.req.getHeaders().setAll(this.request.headers());
                Map params = queryStringDecoder.parameters();
                if (!params.isEmpty()) {
                    for (Map.Entry p : params.entrySet()) {
                        for (String val : (List)p.getValue()) {
                            this.req.getQueryString().put((String)p.getKey(), val);
                        }
                    }
                }
                if (Strings.startsWith((CharSequence)this.req.getContentType(), (CharSequence)HttpHeaderValues.MULTIPART_FORM_DATA.toString()) || Strings.startsWith((CharSequence)this.req.getContentType(), (CharSequence)HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED.toString())) {
                    try {
                        this.decoder = new HttpPostRequestDecoder(factory, this.request);
                    }
                    catch (HttpPostRequestDecoder.ErrorDataDecoderException e) {
                        log.error("post decode", (Throwable)e);
                        this.sendError(ctx, HttpResponseStatus.BAD_REQUEST);
                        return;
                    }
                }
            }
            if (msg instanceof HttpContent) {
                if (this.req == null) {
                    return;
                }
                HttpContent content = (HttpContent)msg;
                if (this.decoder != null) {
                    try {
                        this.decoder.offer(content);
                    }
                    catch (HttpPostRequestDecoder.ErrorDataDecoderException e) {
                        log.error("post decode", (Throwable)e);
                        this.sendError(ctx, HttpResponseStatus.BAD_REQUEST);
                        return;
                    }
                    try {
                        while (this.decoder.hasNext()) {
                            InterfaceHttpData httpData = this.decoder.next();
                            if (httpData == null) continue;
                            if (httpData.getHttpDataType().equals((Object)InterfaceHttpData.HttpDataType.Attribute)) {
                                Attribute attr = (Attribute)httpData;
                                MultiValueMap<String, String> form = this.req.getForm();
                                if (form == null) {
                                    form = new MultiValueMap<String, String>();
                                    this.req.setForm(form);
                                }
                                form.put(attr.getName(), attr.getValue());
                                continue;
                            }
                            if (!httpData.getHttpDataType().equals((Object)InterfaceHttpData.HttpDataType.FileUpload)) continue;
                            FileUpload file = (FileUpload)httpData;
                            MultiValueMap<String, FileUpload> files = this.req.getFiles();
                            if (files == null) {
                                files = new MultiValueMap<String, FileUpload>();
                                this.req.setFiles(files);
                            }
                            files.put(file.getName(), file);
                        }
                    }
                    catch (HttpPostRequestDecoder.EndOfDataDecoderException e) {
                        log.debug("EndOfData", (Throwable)e);
                    }
                } else {
                    ByteBuf buf = this.req.getContent();
                    if (buf == null) {
                        buf = Bytes.heapBuffer(256, true);
                        this.req.setContent(buf);
                    }
                    buf.writeBytes(content.content());
                }
                if (msg instanceof LastHttpContent) {
                    DefaultFullHttpResponse response;
                    ServerResponse res = new ServerResponse();
                    try {
                        this.handler.handle(this.req, res);
                        if (res.getHeaders().contains((CharSequence)HttpHeaderNames.LOCATION)) {
                            response = new DefaultFullHttpResponse(this.request.protocolVersion(), HttpResponseStatus.FOUND, Unpooled.EMPTY_BUFFER);
                            this.sendResponse(ctx, (FullHttpResponse)response);
                            return;
                        }
                    }
                    catch (Throwable e) {
                        log.error("handle", e);
                        this.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
                        return;
                    }
                    response = new DefaultFullHttpResponse(this.request.protocolVersion(), HttpResponseStatus.OK, Extends.ifNull(res.getContent(), Unpooled.EMPTY_BUFFER));
                    response.headers().setAll(res.getHeaders());
                    this.sendResponse(ctx, (FullHttpResponse)response);
                }
            }
        }

        private void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(this.request.protocolVersion(), status, Unpooled.copiedBuffer((CharSequence)("Failure: " + status), (Charset)CharsetUtil.UTF_8));
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain; charset=UTF-8");
            this.sendResponse(ctx, (FullHttpResponse)response);
        }

        private void sendResponse(ChannelHandlerContext ctx, FullHttpResponse response) {
            boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)this.request);
            HttpUtil.setContentLength((HttpMessage)response, (long)response.content().readableBytes());
            if (keepAlive) {
                response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            } else {
                response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
            }
            ChannelFuture future = ctx.writeAndFlush((Object)response);
            if (!keepAlive) {
                future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
            if (this.decoder != null) {
                this.decoder.destroy();
                this.decoder = null;
            }
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            if (this.decoder != null) {
                this.decoder.cleanFiles();
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            log.error("caught", cause);
            if (ctx.channel().isActive()) {
                this.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
            }
        }
    }
}

