/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.http;

import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.rx.bean.ProceedEventArgs;
import org.rx.core.Arrays;
import org.rx.core.Extends;
import org.rx.core.JsonTypeInvoker;
import org.rx.core.Linq;
import org.rx.core.Reflects;
import org.rx.core.Strings;
import org.rx.core.Sys;
import org.rx.exception.InvalidException;
import org.rx.net.http.HttpClient;
import org.rx.util.function.BiFunc;
import org.rx.util.function.Func;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

public final class RestClient {
    private static final Logger log = LoggerFactory.getLogger(RestClient.class);

    public static <T> T facade(Class<T> contract, String serverPrefixUrl, BiFunc<String, Boolean> checkResponse) {
        RequestMapping baseMapping = contract.getAnnotation(RequestMapping.class);
        String prefix = serverPrefixUrl + RestClient.getFirstPath(baseMapping);
        boolean defMethod = RestClient.isPostMethod(baseMapping);
        return Sys.proxy(contract, (m, p) -> {
            String responseText;
            RequestMapping pathMapping = m.getAnnotation(RequestMapping.class);
            String path = RestClient.getFirstPath(pathMapping);
            if (Strings.isEmpty((CharSequence)path)) {
                path = m.getName();
            }
            String reqUrl = prefix + path;
            boolean doPost = Arrays.isEmpty((Object[])pathMapping.method()) ? defMethod : RestClient.isPostMethod(pathMapping);
            Parameter[] parameters = m.getParameters();
            Func<Map> getFormData = () -> {
                HashMap<String, Object> data = new HashMap<String, Object>();
                for (int i = 0; i < parameters.length; ++i) {
                    Parameter parameter = parameters[i];
                    RequestParam param = parameter.getAnnotation(RequestParam.class);
                    String name = param != null ? (!Strings.isEmpty((CharSequence)param.value()) ? param.value() : param.name()) : parameter.getName();
                    Object val = p.arguments[i];
                    if (val == null && param != null) {
                        val = Reflects.changeType(param.defaultValue(), parameter.getType());
                    }
                    data.put(name, val);
                }
                return data;
            };
            ProceedEventArgs args = new ProceedEventArgs(contract, new Object[1], m.getReturnType().equals(Void.TYPE));
            HttpClient client = new HttpClient();
            try {
                if (doPost) {
                    if (parameters.length == 1 && parameters[0].isAnnotationPresent(RequestBody.class)) {
                        args.getParameters()[0] = p.arguments[0];
                        responseText = args.proceed(() -> client.postJson(reqUrl, args.getParameters()[0]).toString());
                    } else {
                        Map data = getFormData.invoke();
                        args.getParameters()[0] = data;
                        responseText = args.proceed(() -> client.post(reqUrl, data).toString());
                    }
                } else {
                    Map data = getFormData.invoke();
                    args.getParameters()[0] = data;
                    responseText = args.proceed(() -> client.get(HttpClient.buildUrl(reqUrl, data)).toString());
                }
                if (checkResponse != null && !((Boolean)checkResponse.invoke(responseText)).booleanValue()) {
                    throw new InvalidException("Response status error", new Object[0]);
                }
            }
            catch (Exception e) {
                args.setError(e);
                throw e;
            }
            finally {
                Sys.log(args, msg -> {
                    if (doPost) {
                        msg.appendLine("POST:\t%s", reqUrl);
                    } else {
                        msg.appendLine("GET:\t%s", reqUrl);
                    }
                    msg.appendLine("Request:\t%s", Sys.toJsonString(args.getParameters()));
                    msg.append("Response:\t%s", args.getReturnValue());
                });
            }
            if (m.getReturnType().equals(Void.class)) {
                return null;
            }
            return Sys.fromJson(responseText, Extends.ifNull((Type)JsonTypeInvoker.JSON_TYPE.get(), m.getReturnType()));
        });
    }

    private static boolean isPostMethod(RequestMapping mapping) {
        return Arrays.isEmpty((Object[])mapping.method()) || Linq.from(mapping.method()).contains(RequestMethod.POST);
    }

    private static String getFirstPath(RequestMapping mapping) {
        return mapping != null ? Linq.from(!Arrays.isEmpty((Object[])mapping.value()) ? mapping.value() : mapping.path()).firstOrDefault() : null;
    }
}

