/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.http;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.util.CharsetUtil;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import lombok.NonNull;
import org.rx.bean.MultiValueMap;
import org.rx.core.Extends;
import org.rx.core.Strings;

public final class ServerRequest {
    private final InetSocketAddress remoteEndpoint;
    private final String uri;
    private final HttpMethod method;
    private final HttpHeaders headers = new DefaultHttpHeaders();
    private final AtomicReference<Object> cookies = new AtomicReference();
    private final MultiValueMap<String, String> queryString = new MultiValueMap();
    private MultiValueMap<String, String> form;
    private MultiValueMap<String, FileUpload> files;
    private ByteBuf content;

    private Set<Cookie> cookiesLazy() {
        String cookie = this.headers.get((CharSequence)HttpHeaderNames.COOKIE);
        if (Strings.isEmpty((CharSequence)cookie)) {
            return Collections.emptySet();
        }
        return ServerCookieDecoder.STRICT.decode(cookie);
    }

    public String getContentType() {
        return this.headers.get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
    }

    public ServerRequest(@NonNull InetSocketAddress remoteEndpoint, @NonNull String uri, HttpMethod method) {
        if (remoteEndpoint == null) {
            throw new NullPointerException("remoteEndpoint is marked non-null but is null");
        }
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        this.remoteEndpoint = remoteEndpoint;
        this.uri = uri;
        this.method = Extends.ifNull(method, HttpMethod.GET);
    }

    public String jsonBody() {
        Extends.require(this.content);
        return this.content.toString(CharsetUtil.UTF_8);
    }

    public InetSocketAddress getRemoteEndpoint() {
        return this.remoteEndpoint;
    }

    public String getUri() {
        return this.uri;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public MultiValueMap<String, String> getQueryString() {
        return this.queryString;
    }

    public MultiValueMap<String, String> getForm() {
        return this.form;
    }

    public MultiValueMap<String, FileUpload> getFiles() {
        return this.files;
    }

    public ByteBuf getContent() {
        return this.content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Cookie> getCookies() {
        Object value = this.cookies.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.cookies;
            synchronized (atomicReference) {
                value = this.cookies.get();
                if (value == null) {
                    Set<Cookie> actualValue = this.cookiesLazy();
                    value = actualValue == null ? this.cookies : actualValue;
                    this.cookies.set(value);
                }
            }
        }
        return (Set)(value == this.cookies ? null : value);
    }

    protected void setForm(MultiValueMap<String, String> form) {
        this.form = form;
    }

    protected void setFiles(MultiValueMap<String, FileUpload> files) {
        this.files = files;
    }

    protected void setContent(ByteBuf content) {
        this.content = content;
    }
}

