/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.http;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import org.rx.core.Sys;
import org.rx.io.Bytes;

public class ServerResponse {
    public static final AsciiString APPLICATION_JSON = AsciiString.cached((String)"application/json; charset=UTF-8");
    public static final AsciiString TEXT_HTML = AsciiString.cached((String)"text/html; charset=UTF-8");
    private final HttpHeaders headers = new DefaultHttpHeaders();
    private ByteBuf content;

    public void addCookie(Cookie cookie) {
        this.headers.add((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)ServerCookieEncoder.STRICT.encode(cookie));
    }

    public void setContentType(String contentType) {
        this.headers.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
    }

    public void jsonBody(Object json) {
        this.setContentType(APPLICATION_JSON.toString());
        this.content = Bytes.directBuffer();
        this.content.writeCharSequence((CharSequence)Sys.toJsonString(json), CharsetUtil.UTF_8);
    }

    public void htmlBody(String html) {
        this.setContentType(TEXT_HTML.toString());
        this.content = Bytes.directBuffer();
        this.content.writeCharSequence((CharSequence)html, CharsetUtil.UTF_8);
    }

    public void redirect(String newUri) {
        this.headers.set((CharSequence)HttpHeaderNames.LOCATION, (Object)newUri);
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public ByteBuf getContent() {
        return this.content;
    }

    public void setContent(ByteBuf content) {
        this.content = content;
    }
}

