/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.http.cookie;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import okhttp3.Cookie;

public class PersistentCookieStorage {
    final Map<String, Cookie> store = new ConcurrentHashMap<String, Cookie>();

    static String createCookieKey(Cookie cookie) {
        return (cookie.secure() ? "https" : "http") + "://" + cookie.domain() + cookie.path() + "|" + cookie.name();
    }

    public List<Cookie> loadAll() {
        return new ArrayList<Cookie>(this.store.values());
    }

    public void saveAll(Collection<Cookie> cookies) {
        for (Cookie cookie : cookies) {
            this.store.put(PersistentCookieStorage.createCookieKey(cookie), cookie);
        }
    }

    public void removeAll(Collection<Cookie> cookies) {
        for (Cookie cookie : cookies) {
            this.store.remove(PersistentCookieStorage.createCookieKey(cookie));
        }
    }

    public void clear() {
        this.store.clear();
    }
}

