/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.http.cookie;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import okhttp3.Cookie;
import org.rx.core.Linq;
import org.rx.net.http.cookie.IdentifiableCookie;

public class VolatileCookieStorage
implements Iterable<Cookie> {
    final Set<IdentifiableCookie> store = ConcurrentHashMap.newKeySet();

    public void addAll(Collection<Cookie> newCookies) {
        this.store.addAll(IdentifiableCookie.decorateAll(newCookies));
    }

    public void clear() {
        this.store.clear();
    }

    @Override
    public Iterator<Cookie> iterator() {
        return Linq.from(this.store).select(p -> p.cookie).iterator();
    }
}

