/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.nameserver;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.rx.core.EventArgs;
import org.rx.core.EventPublisher;
import org.rx.core.Extends;

public interface Nameserver
extends EventPublisher<Nameserver>,
AutoCloseable {
    public static final String EVENT_CLIENT_SYNC = "CLIENT_SYNC";
    public static final String EVENT_APP_ADDRESS_CHANGED = "APP_ADDRESS_CHANGED";
    public static final String EVENT_APP_ATTRS_CHANGED = "APP_ATTRS_CHANGED";
    public static final String APP_NAME_KEY = "app.name";

    default public int register(String appName, Set<InetSocketAddress> serverEndpoints) {
        return this.register(appName, 2, serverEndpoints);
    }

    public int register(String var1, int var2, Set<InetSocketAddress> var3);

    public void deregister();

    public <T extends Serializable> void attr(String var1, String var2, T var3);

    public <T extends Serializable> T attr(String var1, String var2);

    public <T extends Serializable> void instanceAttr(String var1, String var2, T var3);

    public <T extends Serializable> T instanceAttr(String var1, String var2);

    public List<InetAddress> discover(String var1);

    public List<InetAddress> discoverAll(String var1, boolean var2);

    public List<InstanceInfo> discover(String var1, List<String> var2);

    public List<InstanceInfo> discoverAll(String var1, boolean var2, List<String> var3);

    @Override
    default public void close() {
    }

    public static class InstanceInfo
    implements Extends {
        private static final long serialVersionUID = 454367372507105015L;
        final InetAddress address;
        final String instanceId;
        final Map<String, Serializable> attributes;

        public InstanceInfo(InetAddress address, String instanceId, Map<String, Serializable> attributes) {
            this.address = address;
            this.instanceId = instanceId;
            this.attributes = attributes;
        }

        public InetAddress getAddress() {
            return this.address;
        }

        public String getInstanceId() {
            return this.instanceId;
        }

        public Map<String, Serializable> getAttributes() {
            return this.attributes;
        }
    }

    public static class AppChangedEventArgs
    extends EventArgs {
        private static final long serialVersionUID = -398674064775226514L;
        final String appName;
        final InetAddress address;
        final boolean isUp;
        final String instanceId;
        final Map<String, Serializable> attributes;

        AppChangedEventArgs(String appName, InetAddress address, boolean isUp, Map<String, Serializable> attributes) {
            this.appName = appName;
            this.address = address;
            this.isUp = isUp;
            this.attributes = attributes;
            this.instanceId = (String)((Object)attributes.get("app.id"));
        }

        public String getAppName() {
            return this.appName;
        }

        public InetAddress getAddress() {
            return this.address;
        }

        public boolean isUp() {
            return this.isUp;
        }

        public String getInstanceId() {
            return this.instanceId;
        }

        public Map<String, Serializable> getAttributes() {
            return this.attributes;
        }
    }
}

