/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.nameserver;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import lombok.NonNull;
import org.rx.bean.RandomList;
import org.rx.core.Constants;
import org.rx.core.Delegate;
import org.rx.core.Disposable;
import org.rx.core.Extends;
import org.rx.core.Linq;
import org.rx.core.ResetEventWait;
import org.rx.core.RxConfig;
import org.rx.core.Sys;
import org.rx.core.Tasks;
import org.rx.core.TimeoutFlag;
import org.rx.exception.InvalidException;
import org.rx.net.Sockets;
import org.rx.net.nameserver.Nameserver;
import org.rx.net.rpc.Remoting;
import org.rx.net.rpc.RpcClientConfig;
import org.rx.util.function.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NameserverClient
extends Disposable {
    private static final Logger log = LoggerFactory.getLogger(NameserverClient.class);
    static final int DEFAULT_RETRY_PERIOD = 1000;
    static final int DEFAULT_RETRY = 2;
    static final int DEFAULT_HEALTH_PERIOD = 120000;
    static final List<RandomList<NsInfo>> group = new CopyOnWriteArrayList<RandomList<NsInfo>>();
    static final ResetEventWait syncRoot = new ResetEventWait();
    public final Delegate<Nameserver, Nameserver.AppChangedEventArgs> onAppAddressChanged = Delegate.create();
    final String appName;
    final RandomList<NsInfo> holder = new RandomList();
    final Set<InetSocketAddress> svrEps = ConcurrentHashMap.newKeySet();

    static void reInject() {
        Tasks.setTimeout(() -> {
            Linq<NsInfo> q = Linq.from(group).selectMany(RandomList::aliveList).where(p -> p.dnsPort != null);
            if (!q.any()) {
                log.warn("At least one dns server that required");
                return;
            }
            List<InetSocketAddress> ns = q.select(p -> Sockets.newEndpoint(p.registerEndpoint, (int)p.dnsPort)).distinct().toList();
            Sockets.injectNameService(ns);
            log.info("inject ns {}", (Object)Sys.toJsonString(ns));
            syncRoot.set();
        }, 500L, NameserverClient.class, Constants.TIMER_REPLACE_FLAG);
    }

    public Set<InetSocketAddress> registerEndpoints() {
        return Linq.from(this.holder).select(p -> p.registerEndpoint).toSet();
    }

    public Set<InetSocketAddress> discoveryEndpoints() {
        return Linq.from(this.holder).where(p -> p.dnsPort != null).select(p -> Sockets.newEndpoint(p.registerEndpoint, (int)p.dnsPort)).toSet();
    }

    public NameserverClient(String appName) {
        this.appName = appName;
        group.add(this.holder);
    }

    @Override
    protected void freeObjects() {
        group.remove(this.holder);
        for (NsInfo tuple : this.holder) {
            Extends.tryClose(tuple.ns);
        }
    }

    public void waitInject() throws TimeoutException {
        this.waitInject(30000L);
    }

    public void waitInject(long timeout) throws TimeoutException {
        if (!syncRoot.waitOne(timeout)) {
            throw new TimeoutException("Inject timeout");
        }
        syncRoot.reset();
    }

    public CompletableFuture<?> registerAsync(String ... registerEndpoints) {
        if (registerEndpoints == null) {
            throw new NullPointerException("registerEndpoints is marked non-null but is null");
        }
        if (registerEndpoints.length == 0) {
            throw new InvalidException("At least one server that required", new Object[0]);
        }
        return this.registerAsync(Linq.from(registerEndpoints).select(Sockets::parseEndpoint).toSet());
    }

    public CompletableFuture<?> registerAsync(@NonNull Set<InetSocketAddress> registerEndpoints) {
        if (registerEndpoints == null) {
            throw new NullPointerException("registerEndpoints is marked non-null but is null");
        }
        if (registerEndpoints.isEmpty()) {
            throw new InvalidException("At least one server that required", new Object[0]);
        }
        this.svrEps.addAll(Linq.from(registerEndpoints).selectMany(Sockets::newAllEndpoints).toSet());
        return Tasks.runAsync(() -> Extends.each(this.svrEps, regEp -> {
            RandomList<NsInfo> randomList = this.holder;
            synchronized (randomList) {
                if (Linq.from(this.holder).any(p -> Extends.eq(p.registerEndpoint, regEp))) {
                    return;
                }
                NsInfo tuple = new NsInfo((InetSocketAddress)regEp);
                this.holder.add(tuple);
                Action handshake = () -> {
                    try {
                        Integer lastDp = tuple.dnsPort;
                        tuple.dnsPort = tuple.ns.register(this.appName, this.svrEps);
                        if (Extends.eq(tuple.dnsPort, lastDp)) {
                            log.debug("login ns ok {} -> {}", regEp, (Object)tuple.dnsPort);
                            return;
                        }
                        log.info("login ns {} -> {} PREV={}", new Object[]{regEp, tuple.dnsPort, lastDp});
                        tuple.ns.instanceAttr(this.appName, "app.id", RxConfig.INSTANCE.getId());
                        NameserverClient.reInject();
                    }
                    catch (Throwable e) {
                        log.debug("login error", e);
                        Tasks.setTimeout(() -> {
                            tuple.dnsPort = tuple.ns.register(this.appName, this.svrEps);
                            tuple.ns.instanceAttr(this.appName, "app.id", RxConfig.INSTANCE.getId());
                            NameserverClient.reInject();
                            Extends.circuitContinue(false);
                        }, 1000L, this.appName, TimeoutFlag.SINGLE.flags(new TimeoutFlag[]{TimeoutFlag.PERIOD}));
                    }
                };
                RpcClientConfig<Nameserver> config = RpcClientConfig.statefulMode(regEp, 0);
                config.setInitHandler((ns, rc) -> {
                    rc.onConnected.combine((s, e) -> {
                        this.holder.setWeight(tuple, 2);
                        NameserverClient.reInject();
                    });
                    rc.onDisconnected.combine((s, e) -> {
                        this.holder.setWeight(tuple, 0);
                        NameserverClient.reInject();
                    });
                    rc.onReconnecting.combine((s, e) -> {
                        if (this.svrEps.addAll(Linq.from(registerEndpoints).selectMany(Sockets::newAllEndpoints).toSet())) {
                            this.registerAsync(this.svrEps);
                        }
                    });
                    rc.onReconnected.combine((s, e) -> {
                        tuple.dnsPort = null;
                        handshake.invoke();
                    });
                    ns.attachEvent("CLIENT_SYNC", (s, e) -> {
                        log.info("sync server endpoints: {}", (Object)Sys.toJsonString(e.getValue()));
                        if (((Set)e.getValue()).isEmpty()) {
                            return;
                        }
                        this.registerAsync((Set)e.getValue());
                    }, false);
                    ns.attachEvent("APP_ADDRESS_CHANGED", (s, e) -> {
                        log.info("app address changed: {} -> {}", (Object)e.getAppName(), (Object)e.getAddress());
                        this.onAppAddressChanged.invoke((Nameserver)s, (Nameserver.AppChangedEventArgs)e);
                    }, false);
                });
                tuple.ns = Remoting.createFacade(Nameserver.class, config);
                tuple.healthTask = Tasks.schedulePeriod(handshake, 120000L);
                handshake.invoke();
            }
        }));
    }

    public CompletableFuture<?> deregisterAsync() {
        return Tasks.runAsync(() -> Extends.each(this.holder, p -> Extends.quietly(() -> p.ns.deregister(), 2)));
    }

    public List<InetAddress> discover(@NonNull String appName) {
        if (appName == null) {
            throw new NullPointerException("appName is marked non-null but is null");
        }
        return this.holder.next().ns.discover(appName);
    }

    public List<InetAddress> discoverAll(@NonNull String appName, boolean exceptCurrent) {
        if (appName == null) {
            throw new NullPointerException("appName is marked non-null but is null");
        }
        return this.holder.next().ns.discoverAll(appName, exceptCurrent);
    }

    public List<Nameserver.InstanceInfo> discover(@NonNull String appName, List<String> instanceAttrKeys) {
        if (appName == null) {
            throw new NullPointerException("appName is marked non-null but is null");
        }
        return this.holder.next().ns.discover(appName, instanceAttrKeys);
    }

    public List<Nameserver.InstanceInfo> discoverAll(@NonNull String appName, boolean exceptCurrent, List<String> instanceAttrKeys) {
        if (appName == null) {
            throw new NullPointerException("appName is marked non-null but is null");
        }
        return this.holder.next().ns.discoverAll(appName, exceptCurrent, instanceAttrKeys);
    }

    public String getAppName() {
        return this.appName;
    }

    static class NsInfo {
        final InetSocketAddress registerEndpoint;
        Nameserver ns;
        Future<?> healthTask;
        volatile Integer dnsPort;

        public NsInfo(InetSocketAddress registerEndpoint) {
            this.registerEndpoint = registerEndpoint;
        }
    }
}

