/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.nameserver;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.rx.core.Constants;
import org.rx.core.Extends;
import org.rx.core.Linq;
import org.rx.core.NEventArgs;
import org.rx.core.NtpClock;
import org.rx.core.Sys;
import org.rx.core.Tasks;
import org.rx.exception.InvalidException;
import org.rx.net.Sockets;
import org.rx.net.dns.DnsServer;
import org.rx.net.nameserver.Nameserver;
import org.rx.net.nameserver.NameserverConfig;
import org.rx.net.rpc.Remoting;
import org.rx.net.rpc.RemotingContext;
import org.rx.net.transport.TcpServer;
import org.rx.net.transport.UdpClient;
import org.rx.net.transport.protocol.PingPacket;
import org.rx.net.transport.protocol.UdpMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NameserverImpl
implements Nameserver {
    private static final Logger log = LoggerFactory.getLogger(NameserverImpl.class);
    static final String NAME = "nameserver";
    final NameserverConfig config;
    final TcpServer rs;
    final DnsServer dnsServer;
    long syncDelay = 500L;
    final UdpClient ss;
    final Set<InetSocketAddress> svrEps = ConcurrentHashMap.newKeySet();
    final Map<Object, Map<String, Serializable>> attrs = new ConcurrentHashMap<Object, Map<String, Serializable>>();

    int getSyncPort() {
        if (this.config.getSyncPort() > 0) {
            return this.config.getSyncPort();
        }
        return this.config.getRegisterPort();
    }

    public Map<String, List<Nameserver.InstanceInfo>> getInstances() {
        return Linq.from(this.rs.getClients().values()).groupByIntoMap(p -> Extends.ifNull((String)p.attr("app.name"), "NOT_REG"), (k, p) -> this.getDiscoverInfos(p.select(x -> x.getRemoteEndpoint().getAddress()).toList(), Collections.emptyList()));
    }

    public NameserverImpl(@NonNull NameserverConfig config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.config = config;
        this.dnsServer = new DnsServer(config.getDnsPort());
        this.dnsServer.setTtl(config.getDnsTtl());
        this.svrEps.addAll(Linq.from(config.getReplicaEndpoints()).select(Sockets::parseEndpoint).selectMany(Sockets::newAllEndpoints).toList());
        this.rs = Remoting.register(this, config.getRegisterPort(), false);
        this.rs.onDisconnected.combine((s, e) -> {
            String appName = (String)e.getClient().attr("app.name");
            if (appName == null) {
                return;
            }
            this.doDeregister(appName, e.getClient().getRemoteEndpoint().getAddress(), true, true);
        });
        this.rs.onPing.combine((s, e) -> this.attrs(e.getClient().getRemoteEndpoint().getAddress()).put("ping", (Serializable)((Object)String.format("%dms", (NtpClock.UTC.millis() - ((PingPacket)e.getValue()).getTimestamp()) * 2L))));
        this.ss = new UdpClient(this.getSyncPort());
        this.ss.onReceive.combine((s, e) -> {
            Object packet = ((UdpMessage)e.getValue()).packet;
            log.info("[{}] Replica {}", (Object)this.getSyncPort(), packet);
            if (!Extends.tryAs(packet, Map.class, p -> {
                Map sync = p;
                for (Map.Entry entry : sync.entrySet()) {
                    this.attrs(entry.getKey()).putAll((Map)entry.getValue());
                }
            }) && !Extends.tryAs(packet, DeregisterInfo.class, p -> this.doDeregister(p.appName, p.address, false, false))) {
                this.syncRegister((Set)packet);
            }
        });
    }

    public synchronized void syncRegister(@NonNull Set<InetSocketAddress> serverEndpoints) {
        if (serverEndpoints == null) {
            throw new NullPointerException("serverEndpoints is marked non-null but is null");
        }
        if (!this.svrEps.addAll(serverEndpoints) && serverEndpoints.containsAll(this.svrEps)) {
            return;
        }
        this.dnsServer.addHosts(NAME, 2, Linq.from(this.svrEps).select(InetSocketAddress::getAddress).toList());
        this.raiseEventAsync("CLIENT_SYNC", new NEventArgs<Set<InetSocketAddress>>(this.svrEps));
        Tasks.setTimeout(() -> {
            for (InetSocketAddress ssAddr : serverEndpoints) {
                this.ss.sendAsync(Sockets.newEndpoint(ssAddr, this.getSyncPort()), this.svrEps);
            }
        }, this.syncDelay, this.svrEps, Constants.TIMER_REPLACE_FLAG);
    }

    public void syncDeregister(@NonNull DeregisterInfo deregisterInfo) {
        if (deregisterInfo == null) {
            throw new NullPointerException("deregisterInfo is marked non-null but is null");
        }
        Tasks.setTimeout(() -> {
            for (InetSocketAddress ssAddr : this.svrEps) {
                this.ss.sendAsync(Sockets.newEndpoint(ssAddr, this.getSyncPort()), deregisterInfo);
            }
        }, this.syncDelay, DeregisterInfo.class, Constants.TIMER_REPLACE_FLAG);
    }

    public void syncAttributes() {
        Tasks.setTimeout(() -> {
            for (InetSocketAddress ssAddr : this.svrEps) {
                this.ss.sendAsync(Sockets.newEndpoint(ssAddr, this.getSyncPort()), this.attrs);
            }
        }, this.syncDelay, this.attrs, Constants.TIMER_REPLACE_FLAG);
    }

    @Override
    public int register(@NonNull String appName, int weight, Set<InetSocketAddress> serverEndpoints) {
        if (appName == null) {
            throw new NullPointerException("appName is marked non-null but is null");
        }
        Sys.logCtx("clientSize", this.rs.getClients().size());
        RemotingContext ctx = RemotingContext.context();
        ctx.getClient().attr("app.name", appName);
        InetAddress addr = ctx.getClient().getRemoteEndpoint().getAddress();
        Sys.logCtx("remoteAddr", addr);
        this.doRegister(appName, weight, addr);
        this.syncRegister(serverEndpoints);
        return this.config.getDnsPort();
    }

    void doRegister(String appName, int weight, InetAddress addr) {
        if (this.dnsServer.addHosts(appName, weight, Collections.singletonList(addr))) {
            this.raiseEventAsync("APP_ADDRESS_CHANGED", new Nameserver.AppChangedEventArgs(appName, addr, true, this.attrs(addr)));
        }
    }

    @Override
    public void deregister() {
        RemotingContext ctx = RemotingContext.context();
        String appName = (String)ctx.getClient().attr("app.name");
        if (appName == null) {
            throw new InvalidException("Must register first", new Object[0]);
        }
        this.doDeregister(appName, ctx.getClient().getRemoteEndpoint().getAddress(), false, true);
    }

    void doDeregister(String appName, InetAddress addr, boolean isDisconnected, boolean shouldSync) {
        int c = Linq.from(this.rs.getClients().values()).count(p -> Extends.eq((String)p.attr("app.name"), appName) && p.getRemoteEndpoint().getAddress().equals(addr));
        if (c == (isDisconnected ? 0 : 1)) {
            log.info("deregister {}", (Object)appName);
            if (this.dnsServer.removeHosts(appName, Collections.singletonList(addr))) {
                this.raiseEventAsync("APP_ADDRESS_CHANGED", new Nameserver.AppChangedEventArgs(appName, addr, false, this.attrs(addr)));
            }
            if (shouldSync) {
                this.syncDeregister(new DeregisterInfo(appName, addr));
            }
        }
    }

    @Override
    public <T extends Serializable> void attr(String appName, String key, T value) {
        this.attrs(appName).put(key, value);
        this.syncAttributes();
    }

    @Override
    public <T extends Serializable> T attr(String appName, String key) {
        return (T)this.attrs(appName).get(key);
    }

    Map<String, Serializable> attrs(Object key) {
        return this.attrs.computeIfAbsent(key, k -> new ConcurrentHashMap());
    }

    @Override
    public <T extends Serializable> void instanceAttr(String appName, String key, T value) {
        RemotingContext ctx = RemotingContext.context();
        this.attrs(ctx.getClient().getRemoteEndpoint().getAddress()).put(key, value);
        this.syncAttributes();
    }

    @Override
    public <T extends Serializable> T instanceAttr(String appName, String key) {
        RemotingContext ctx = RemotingContext.context();
        return (T)this.attrs(ctx.getClient().getRemoteEndpoint().getAddress()).get(key);
    }

    @Override
    public List<InetAddress> discover(@NonNull String appName) {
        if (appName == null) {
            throw new NullPointerException("appName is marked non-null but is null");
        }
        return this.dnsServer.getHosts(appName);
    }

    @Override
    public List<InetAddress> discoverAll(@NonNull String appName, boolean exceptCurrent) {
        if (appName == null) {
            throw new NullPointerException("appName is marked non-null but is null");
        }
        List<InetAddress> hosts = this.dnsServer.getAllHosts(appName);
        if (exceptCurrent) {
            RemotingContext ctx = RemotingContext.context();
            hosts.remove(ctx.getClient().getRemoteEndpoint().getAddress());
        }
        return hosts;
    }

    @Override
    public List<Nameserver.InstanceInfo> discover(@NonNull String appName, List<String> instanceAttrKeys) {
        if (appName == null) {
            throw new NullPointerException("appName is marked non-null but is null");
        }
        List<InetAddress> hosts = this.dnsServer.getHosts(appName);
        return this.getDiscoverInfos(hosts, instanceAttrKeys);
    }

    @Override
    public List<Nameserver.InstanceInfo> discoverAll(@NonNull String appName, boolean exceptCurrent, List<String> instanceAttrKeys) {
        if (appName == null) {
            throw new NullPointerException("appName is marked non-null but is null");
        }
        List<InetAddress> hosts = this.dnsServer.getAllHosts(appName);
        if (exceptCurrent) {
            RemotingContext ctx = RemotingContext.context();
            hosts.remove(ctx.getClient().getRemoteEndpoint().getAddress());
        }
        return this.getDiscoverInfos(hosts, instanceAttrKeys);
    }

    List<Nameserver.InstanceInfo> getDiscoverInfos(List<InetAddress> hosts, List<String> instanceAttrKeys) {
        return Linq.from(hosts).select(p -> {
            Map<String, Serializable> attrs = this.attrs(p);
            return new Nameserver.InstanceInfo((InetAddress)p, (String)((Object)attrs.get("app.id")), Linq.from(!CollectionUtils.isEmpty((Collection)instanceAttrKeys) ? instanceAttrKeys : attrs.keySet()).toMap(x -> x, attrs::get));
        }).toList();
    }

    public DnsServer getDnsServer() {
        return this.dnsServer;
    }

    public void setSyncDelay(long syncDelay) {
        this.syncDelay = syncDelay;
    }

    static class DeregisterInfo
    implements Serializable {
        private static final long serialVersionUID = 713672672746841635L;
        final String appName;
        final InetAddress address;

        public DeregisterInfo(String appName, InetAddress address) {
            this.appName = appName;
            this.address = address;
        }

        public String toString() {
            return "NameserverImpl.DeregisterInfo(appName=" + this.appName + ", address=" + this.address + ")";
        }
    }
}

