/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.rpc;

import io.netty.util.concurrent.FastThreadLocal;
import org.rx.core.Extends;
import org.rx.net.transport.TcpClient;
import org.rx.net.transport.TcpServer;
import org.rx.util.function.Func;

public final class RemotingContext {
    static final FastThreadLocal<RemotingContext> CTX = new FastThreadLocal();
    final TcpServer server;
    final TcpClient client;

    public static RemotingContext context() {
        RemotingContext ctx = (RemotingContext)CTX.getIfExists();
        Extends.require(ctx);
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static <T> T invoke(Func<T> fn, TcpServer rs, TcpClient rc) {
        CTX.set((Object)new RemotingContext(rs, rc));
        try {
            T t = fn.invoke();
            return t;
        }
        finally {
            CTX.remove();
        }
    }

    public TcpServer getServer() {
        return this.server;
    }

    public TcpClient getClient() {
        return this.client;
    }

    private RemotingContext(TcpServer server, TcpClient client) {
        this.server = server;
        this.client = client;
    }
}

