/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.rpc;

import java.net.InetSocketAddress;
import org.rx.net.Sockets;
import org.rx.net.transport.StatefulTcpClient;
import org.rx.net.transport.TcpClientConfig;
import org.rx.util.function.TripleAction;

public class RpcClientConfig<T> {
    private static final long serialVersionUID = -4952694662640163676L;
    public static final int NON_POOL_SIZE = -1;
    public static final int DEFAULT_VERSION = 0;
    private final TcpClientConfig tcpConfig;
    private int eventVersion = 0;
    private int minPoolSize;
    private int maxPoolSize = -1;
    private TripleAction<T, StatefulTcpClient> initHandler;

    public static <T> RpcClientConfig<T> statefulMode(String serverEndpoint, int eventVersion) {
        return RpcClientConfig.statefulMode(Sockets.parseEndpoint(serverEndpoint), eventVersion);
    }

    public static <T> RpcClientConfig<T> statefulMode(InetSocketAddress serverEndpoint, int eventVersion) {
        TcpClientConfig tcpClientConfig = new TcpClientConfig();
        tcpClientConfig.setServerEndpoint(serverEndpoint);
        tcpClientConfig.setEnableReconnect(true);
        RpcClientConfig<T> config = new RpcClientConfig<T>(tcpClientConfig);
        config.setEventVersion(eventVersion);
        return config;
    }

    public static <T> RpcClientConfig<T> poolMode(String serverEndpoint, int maxPoolSize) {
        return RpcClientConfig.poolMode(Sockets.parseEndpoint(serverEndpoint), 2, maxPoolSize);
    }

    public static <T> RpcClientConfig<T> poolMode(InetSocketAddress serverEndpoint, int minPoolSize, int maxPoolSize) {
        TcpClientConfig tcpClientConfig = new TcpClientConfig();
        tcpClientConfig.setServerEndpoint(serverEndpoint);
        tcpClientConfig.setEnableReconnect(false);
        RpcClientConfig<T> config = new RpcClientConfig<T>(tcpClientConfig);
        config.setMinPoolSize(minPoolSize);
        config.setMaxPoolSize(maxPoolSize);
        return config;
    }

    public boolean isUsePool() {
        return this.maxPoolSize > -1;
    }

    public RpcClientConfig(TcpClientConfig tcpConfig) {
        this.tcpConfig = tcpConfig;
    }

    public TcpClientConfig getTcpConfig() {
        return this.tcpConfig;
    }

    public int getEventVersion() {
        return this.eventVersion;
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public TripleAction<T, StatefulTcpClient> getInitHandler() {
        return this.initHandler;
    }

    public void setEventVersion(int eventVersion) {
        this.eventVersion = eventVersion;
    }

    public void setMinPoolSize(int minPoolSize) {
        this.minPoolSize = minPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public void setInitHandler(TripleAction<T, StatefulTcpClient> initHandler) {
        this.initHandler = initHandler;
    }

    public String toString() {
        return "RpcClientConfig(tcpConfig=" + this.getTcpConfig() + ", eventVersion=" + this.getEventVersion() + ", minPoolSize=" + this.getMinPoolSize() + ", maxPoolSize=" + this.getMaxPoolSize() + ", initHandler=" + this.getInitHandler() + ")";
    }
}

