/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.rpc;

import org.rx.core.Disposable;
import org.rx.core.ObjectPool;
import org.rx.core.Sys;
import org.rx.net.rpc.RpcClientConfig;
import org.rx.net.rpc.TcpClientPool;
import org.rx.net.transport.StatefulTcpClient;
import org.rx.net.transport.TcpClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RpcClientPool
extends Disposable
implements TcpClientPool {
    private static final Logger log = LoggerFactory.getLogger(RpcClientPool.class);
    final ObjectPool<StatefulTcpClient> pool;

    public RpcClientPool(RpcClientConfig<?> template) {
        int minSize = Math.max(2, template.getMinPoolSize());
        int maxSize = Math.max(minSize, template.getMaxPoolSize());
        this.pool = new ObjectPool<StatefulTcpClient>(minSize, maxSize, () -> {
            TcpClientConfig config = Sys.deepClone(template.getTcpConfig());
            StatefulTcpClient c = new StatefulTcpClient(config);
            c.connect(config.getServerEndpoint());
            log.debug("Create RpcClient {}", (Object)c);
            return c;
        }, c -> c.getConfig().isEnableReconnect() || c.isConnected(), c -> {
            c.getConfig().setEnableReconnect(false);
            c.onError.purge();
            c.onReceive.purge();
            c.onSend.purge();
            c.onDisconnected.purge();
            c.onConnected.purge();
            c.onReconnected.purge();
            c.onReconnecting.purge();
        });
        this.pool.setBorrowTimeout(template.getTcpConfig().getConnectTimeoutMillis());
        this.pool.setLeakDetectionThreshold(this.pool.getIdleTimeout());
    }

    @Override
    protected void freeObjects() {
        this.pool.close();
    }

    @Override
    public StatefulTcpClient borrowClient() {
        this.checkNotClosed();
        return this.pool.borrow();
    }

    @Override
    public StatefulTcpClient returnClient(StatefulTcpClient client) {
        this.checkNotClosed();
        this.pool.recycle(client);
        return null;
    }

    public RpcClientPool(ObjectPool<StatefulTcpClient> pool) {
        this.pool = pool;
    }
}

