/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.shadowsocks;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.List;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.rx.net.Sockets;
import org.rx.net.shadowsocks.SSCommon;
import org.rx.net.shadowsocks.encryption.ICrypto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class CipherCodec
extends MessageToMessageCodec<Object, Object> {
    private static final Logger log = LoggerFactory.getLogger(CipherCodec.class);
    public static final CipherCodec DEFAULT = new CipherCodec();

    protected void encode(ChannelHandlerContext ctx, Object msg, List<Object> out) throws Exception {
        ByteBuf buf = Sockets.getMessageBuf(msg);
        ICrypto crypt = (ICrypto)ctx.channel().attr(SSCommon.CIPHER).get();
        byte[] data = new byte[buf.readableBytes()];
        buf.getBytes(0, data);
        crypt.encrypt(data, buf);
        out.add(buf.retain());
    }

    protected void decode(ChannelHandlerContext ctx, Object msg, List<Object> out) throws Exception {
        ByteBuf buf = Sockets.getMessageBuf(msg);
        ICrypto crypt = (ICrypto)ctx.channel().attr(SSCommon.CIPHER).get();
        byte[] data = new byte[buf.readableBytes()];
        buf.getBytes(0, data);
        try {
            crypt.decrypt(data, buf);
        }
        catch (Exception e) {
            if (e instanceof InvalidCipherTextException) {
                log.warn("decode fail {}", (Object)e.getMessage());
                ctx.close();
                return;
            }
            throw e;
        }
        out.add(buf.retain());
    }
}

