/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.shadowsocks;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.handler.codec.socks.SocksAddressType;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetSocketAddress;
import java.util.List;
import org.rx.io.Bytes;
import org.rx.net.Sockets;
import org.rx.net.shadowsocks.SSAddressRequest;
import org.rx.net.shadowsocks.SSCommon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolCodec
extends MessageToMessageCodec<Object, Object> {
    private static final Logger log = LoggerFactory.getLogger(ProtocolCodec.class);
    private boolean tcpAddressed;

    protected void encode(ChannelHandlerContext ctx, Object msg, List<Object> out) throws Exception {
        ByteBuf buf = Sockets.getMessageBuf(msg);
        boolean isUdp = (Boolean)ctx.channel().attr(SSCommon.IS_UDP).get();
        InetSocketAddress addr = null;
        if (isUdp) {
            addr = (InetSocketAddress)ctx.channel().attr(SSCommon.REMOTE_SRC).get();
        }
        if (addr == null) {
            buf.retain();
        } else {
            SSAddressRequest addrRequest = addr.getAddress() instanceof Inet6Address ? new SSAddressRequest(SocksAddressType.IPv6, addr.getHostString(), addr.getPort()) : (addr.getAddress() instanceof Inet4Address ? new SSAddressRequest(SocksAddressType.IPv4, addr.getHostString(), addr.getPort()) : new SSAddressRequest(SocksAddressType.DOMAIN, addr.getHostString(), addr.getPort()));
            ByteBuf addrBuff = Bytes.directBuffer();
            addrRequest.encode(addrBuff);
            buf = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{addrBuff, buf.retain()});
        }
        msg = msg instanceof DatagramPacket ? ((DatagramPacket)msg).replace(buf) : buf;
        out.add(msg);
    }

    protected void decode(ChannelHandlerContext ctx, Object msg, List<Object> out) throws Exception {
        ByteBuf buf = Sockets.getMessageBuf(msg);
        if (buf.readableBytes() < 4) {
            return;
        }
        boolean isUdp = (Boolean)ctx.channel().attr(SSCommon.IS_UDP).get();
        if (isUdp || !this.tcpAddressed) {
            SSAddressRequest addrRequest = SSAddressRequest.decode(buf);
            if (addrRequest == null) {
                log.warn("fail to decode address request from {}, pls check client's cipher setting", (Object)ctx.channel().remoteAddress());
                if (!((Boolean)ctx.channel().attr(SSCommon.IS_UDP).get()).booleanValue()) {
                    ctx.close();
                }
                return;
            }
            InetSocketAddress addr = new InetSocketAddress(addrRequest.host(), addrRequest.port());
            ctx.channel().attr(SSCommon.REMOTE_DEST).set((Object)addr);
            if (!isUdp) {
                this.tcpAddressed = true;
            }
        }
        buf.retain();
        out.add(msg);
    }
}

