/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.shadowsocks;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.socks.SocksAddressType;
import io.netty.util.CharsetUtil;
import io.netty.util.NetUtil;
import java.net.IDN;
import org.rx.net.shadowsocks.SocksCommonUtils;

public final class SSAddressRequest {
    private final SocksAddressType addressType;
    private final String host;
    private final int port;

    public SSAddressRequest(SocksAddressType addressType, String host, int port) {
        if (addressType == null) {
            throw new NullPointerException("addressType");
        }
        if (host == null) {
            throw new NullPointerException("host");
        }
        switch (addressType) {
            case IPv4: {
                if (NetUtil.isValidIpV4Address((String)host)) break;
                throw new IllegalArgumentException(host + " is not a valid IPv4 address");
            }
            case DOMAIN: {
                if (IDN.toASCII(host).length() <= 255) break;
                throw new IllegalArgumentException(host + " IDN: " + IDN.toASCII(host) + " exceeds 255 char limit");
            }
            case IPv6: {
                if (NetUtil.isValidIpV6Address((String)host)) break;
                throw new IllegalArgumentException(host + " is not a valid IPv6 address");
            }
        }
        if (port <= 0 || port >= 65536) {
            throw new IllegalArgumentException(port + " is not in bounds 0 < x < 65536");
        }
        this.addressType = addressType;
        this.host = IDN.toASCII(host);
        this.port = port;
    }

    public SocksAddressType addressType() {
        return this.addressType;
    }

    public String host() {
        return IDN.toUnicode(this.host);
    }

    public int port() {
        return this.port;
    }

    public void encode(ByteBuf byteBuf) {
        byteBuf.writeByte((int)this.addressType.byteValue());
        switch (this.addressType) {
            case IPv4: 
            case IPv6: {
                byteBuf.writeBytes(NetUtil.createByteArrayFromIpAddressString((String)this.host));
                byteBuf.writeShort(this.port);
                break;
            }
            case DOMAIN: {
                byteBuf.writeByte(this.host.length());
                byteBuf.writeBytes(this.host.getBytes(CharsetUtil.US_ASCII));
                byteBuf.writeShort(this.port);
            }
        }
    }

    public static SSAddressRequest decode(ByteBuf byteBuf) {
        SSAddressRequest request = null;
        SocksAddressType addressType = SocksAddressType.valueOf((byte)byteBuf.readByte());
        switch (addressType) {
            case IPv4: {
                String host = SocksCommonUtils.intToIp(byteBuf.readInt());
                int port = byteBuf.readUnsignedShort();
                request = new SSAddressRequest(addressType, host, port);
                break;
            }
            case DOMAIN: {
                byte fieldLength = byteBuf.readByte();
                String host = SocksCommonUtils.readUsAscii(byteBuf, fieldLength);
                int port = byteBuf.readUnsignedShort();
                request = new SSAddressRequest(addressType, host, port);
                break;
            }
            case IPv6: {
                byte[] bytes = new byte[16];
                byteBuf.readBytes(bytes);
                String host = SocksCommonUtils.ipv6toStr(bytes);
                int port = byteBuf.readUnsignedShort();
                request = new SSAddressRequest(addressType, host, port);
                break;
            }
        }
        return request;
    }
}

