/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.shadowsocks;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DatagramPacket;
import java.net.InetSocketAddress;
import org.rx.net.shadowsocks.SSCommon;

@ChannelHandler.Sharable
public class ServerReceiveHandler
extends SimpleChannelInboundHandler<Object> {
    public static final ServerReceiveHandler DEFAULT = new ServerReceiveHandler();

    public ServerReceiveHandler() {
        super(false);
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        boolean isUdp = (Boolean)ctx.channel().attr(SSCommon.IS_UDP).get();
        if (isUdp) {
            DatagramPacket udpRaw = (DatagramPacket)msg;
            ByteBuf buf = (ByteBuf)udpRaw.content();
            if (buf.readableBytes() < 4) {
                return;
            }
            ctx.channel().attr(SSCommon.REMOTE_ADDRESS).set((Object)((InetSocketAddress)udpRaw.sender()));
            ctx.fireChannelRead((Object)buf);
            return;
        }
        ctx.channel().attr(SSCommon.REMOTE_ADDRESS).set((Object)((InetSocketAddress)ctx.channel().remoteAddress()));
        ctx.channel().pipeline().remove((ChannelHandler)this);
        ctx.fireChannelRead(msg);
    }
}

